/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldclient.provider.youtube.mapping;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.marmotta.ldclient.provider.xml.mapping.XPathValueMapper;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;

public class YoutubeUriMapper
extends XPathValueMapper {
    public YoutubeUriMapper(String xpath) {
        super(xpath);
    }

    public YoutubeUriMapper(String xpath, Map<String, String> namespaces) {
        super(xpath, namespaces);
    }

    public List<Value> map(String resourceUri, String selectedValue, ValueFactory factory) {
        if (selectedValue.startsWith("http://gdata.youtube.com/feeds/api/videos") && selectedValue.indexOf(63) >= 0) {
            return Collections.singletonList(factory.createURI(selectedValue.substring(0, selectedValue.indexOf(63))));
        }
        if (selectedValue.startsWith("http://www.youtube.com/v/")) {
            String[] p_components = selectedValue.split("/");
            String video_id = p_components[p_components.length - 1];
            return Collections.singletonList(factory.createURI("http://gdata.youtube.com/feeds/api/videos/" + video_id));
        }
        if (selectedValue.startsWith("http://www.youtube.com/watch")) {
            try {
                URI uri = new URI(selectedValue);
                List params = URLEncodedUtils.parse((URI)uri, (String)"UTF-8");
                String video_id = null;
                for (NameValuePair pair : params) {
                    if (!"v".equals(pair.getName())) continue;
                    video_id = pair.getValue();
                }
                if (video_id != null) {
                    return Collections.singletonList(factory.createURI("http://gdata.youtube.com/feeds/api/videos/" + video_id));
                }
            }
            catch (URISyntaxException e) {
                return Collections.singletonList(factory.createURI(selectedValue));
            }
        }
        return Collections.singletonList(factory.createURI(selectedValue));
    }
}

