/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.selectors;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.selectors.NodeSelector;
import org.apache.marmotta.ldpath.api.tests.NodeTest;

public class TestingSelector<Node>
implements NodeSelector<Node> {
    private NodeSelector<Node> delegate;
    private NodeTest<Node> test;

    public TestingSelector(NodeSelector<Node> delegate, NodeTest<Node> test) {
        this.delegate = delegate;
        this.test = test;
    }

    public Collection<Node> select(final RDFBackend<Node> rdfBackend, final Node context, List<Node> path, Map<Node, List<Node>> resultPaths) {
        Predicate predicate = new Predicate<Node>(){

            public boolean apply(Node input) {
                return TestingSelector.this.test.accept(rdfBackend, context, input);
            }
        };
        return Collections2.filter((Collection)this.delegate.select(rdfBackend, context, path, resultPaths), (Predicate)predicate);
    }

    public String getPathExpression(RDFBackend<Node> rdfBackend) {
        return String.format("%s[%s]", this.delegate.getPathExpression(rdfBackend), this.test.getPathExpression(rdfBackend));
    }

    public String getName(RDFBackend<Node> nodeRDFBackend) {
        return this.delegate.getName(nodeRDFBackend);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestingSelector that = (TestingSelector)o;
        if (this.delegate != null ? !this.delegate.equals(that.delegate) : that.delegate != null) {
            return false;
        }
        return !(this.test != null ? !this.test.equals(that.test) : that.test != null);
    }

    public int hashCode() {
        int result = this.delegate != null ? this.delegate.hashCode() : 0;
        result = 31 * result + (this.test != null ? this.test.hashCode() : 0);
        return result;
    }
}

