/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions;

import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;

public class CountFunction<Node>
extends SelectorFunction<Node> {
    private final URI dataType = URI.create("http://www.w3.org/2001/XMLSchema#integer");

    @SafeVarargs
    public final Collection<Node> apply(RDFBackend<Node> backend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        LinkedList<Object> result = new LinkedList<Object>();
        for (Collection<Node> coll : args) {
            Object intLit = backend.createLiteral(String.valueOf(coll.size()), null, this.dataType);
            result.add(intLit);
        }
        return result;
    }

    public String getSignature() {
        return "fn:count(nodes : URIResourceList, ...) : IntegerLiteralList";
    }

    public String getDescription() {
        return "Counts the number of resources in the arguments";
    }

    public String getLocalName() {
        return "count";
    }
}

