/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.model.transformers.DateTimeTransformer;
import org.apache.marmotta.ldpath.model.transformers.StringTransformer;

public class SortFunction<Node>
extends SelectorFunction<Node> {
    private StringTransformer<Node> transformer = new StringTransformer();
    private DateTimeTransformer<Node> dateTransformer = new DateTimeTransformer();

    @SafeVarargs
    public final Collection<Node> apply(final RDFBackend<Node> nodeRDFBackend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        Object order = "string";
        Object direction = "asc";
        if (args.length > 1) {
            order = this.transformer.transform((RDFBackend)nodeRDFBackend, (Object)args[1].iterator().next(), (Map)null);
        }
        if (args.length > 2) {
            direction = this.transformer.transform((RDFBackend)nodeRDFBackend, (Object)args[2].iterator().next(), (Map)null);
        }
        Comparator comparator = null;
        if ("string".equalsIgnoreCase((String)order)) {
            comparator = new Comparator<Node>(){
                Collator stringCollator = Collator.getInstance(Locale.getDefault());

                @Override
                public int compare(Node o1, Node o2) {
                    return this.stringCollator.compare((String)SortFunction.this.transformer.transform(nodeRDFBackend, o1, (Map)null), (String)SortFunction.this.transformer.transform(nodeRDFBackend, o2, (Map)null));
                }
            };
        } else if ("number".equalsIgnoreCase((String)order)) {
            comparator = new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return (int)Math.signum(nodeRDFBackend.doubleValue(o2) - nodeRDFBackend.doubleValue(o1));
                }
            };
        } else if ("date".equalsIgnoreCase((String)order)) {
            comparator = new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return (int)(((Date)SortFunction.this.dateTransformer.transform(nodeRDFBackend, o2, (Map)null)).getTime() - ((Date)SortFunction.this.dateTransformer.transform(nodeRDFBackend, o1, (Map)null)).getTime());
                }
            };
        }
        if ("desc".equalsIgnoreCase((String)direction) && comparator != null) {
            final Comparator comparator2 = comparator;
            comparator = new Comparator<Node>(){

                @Override
                public int compare(Node o1, Node o2) {
                    return comparator2.compare(o2, o1);
                }
            };
        }
        ArrayList<Node> result = new ArrayList<Node>(args[0]);
        if (comparator != null) {
            Collections.sort(result, comparator);
        }
        return result;
    }

    public String getLocalName() {
        return "sort";
    }

    public String getSignature() {
        return "fn:sort(nodes : NodeList [, (\"string\"|\"number\"|\"date\") [, (\"asc\"|\"desc\") ] ]) : NodeList ";
    }

    public String getDescription() {
        return "Sort the node list passed as first argument. The second argument can be used to determine the sort method, the third argument to determine the sort direction.";
    }
}

