/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.selectors;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.marmotta.ldpath.api.backend.NodeBackend;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.selectors.NodeSelector;

public class ReversePropertySelector<Node>
implements NodeSelector<Node> {
    private final Node property;

    public ReversePropertySelector(Node property) {
        this.property = property;
    }

    public Collection<Node> select(RDFBackend<Node> rdfBackend, Node context, List<Node> path, Map<Node, List<Node>> resultPaths) {
        if (rdfBackend.isURI(context) || rdfBackend.isBlank(context)) {
            if (path != null && resultPaths != null) {
                Collection results = rdfBackend.listSubjects(context, this.property);
                for (Object n : results) {
                    resultPaths.put((Node)n, (List<Node>)new ImmutableList.Builder().addAll(path).add(context).add(n).build());
                }
                return results;
            }
            return rdfBackend.listSubjects(this.property, context);
        }
        return Collections.emptyList();
    }

    public String getPathExpression(NodeBackend<Node> backend) {
        if (this.property != null) {
            return String.format("^<%s>", backend.stringValue(this.property));
        }
        return "^*";
    }

    public String getName(NodeBackend<Node> nodeRDFBackend) {
        return nodeRDFBackend.stringValue(this.property);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReversePropertySelector that = (ReversePropertySelector)o;
        return !(this.property != null ? !this.property.equals(that.property) : that.property != null);
    }

    public int hashCode() {
        return this.property != null ? this.property.hashCode() : 0;
    }
}

