/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions.xml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.apache.marmotta.ldpath.api.backend.RDFBackend;
import org.apache.marmotta.ldpath.api.functions.SelectorFunction;
import org.apache.marmotta.ldpath.model.transformers.StringTransformer;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Text;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathFunction<Node>
extends SelectorFunction<Node> {
    private static final Logger log = LoggerFactory.getLogger(XPathFunction.class);
    private final StringTransformer<Node> transformer = new StringTransformer();

    public Collection<Node> apply(RDFBackend<Node> rdfBackend, Node context, Collection<Node> ... args) throws IllegalArgumentException {
        Iterator<Node> it;
        if (args.length < 1) {
            throw new IllegalArgumentException("XPath expression is required as first argument.");
        }
        HashSet<String> xpaths = new HashSet<String>();
        for (Node xpath : args[0]) {
            try {
                xpaths.add(this.transformer.transform(rdfBackend, xpath, null));
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("First argument must not contain anything else than String-Literals!");
            }
        }
        if (args.length < 2) {
            log.debug("Use context {} to execute xpaths {}", context, xpaths);
            it = Collections.singleton(context).iterator();
        } else {
            log.debug("execute xpaths {} on parsed parameters", xpaths);
            it = org.apache.marmotta.ldpath.util.Collections.iterator((int)1, (Collection[])args);
        }
        ArrayList<Object> result = new ArrayList<Object>();
        while (it.hasNext()) {
            Node n = it.next();
            try {
                for (String r : this.doFilter(this.transformer.transform(rdfBackend, n, null), xpaths)) {
                    result.add(rdfBackend.createLiteral(r));
                }
            }
            catch (IOException e) {
            }
        }
        return result;
    }

    private LinkedList<String> doFilter(String in, Set<String> xpaths) throws IOException {
        LinkedList<String> result = new LinkedList<String>();
        try {
            Document doc = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING).build((Reader)new StringReader(in));
            XMLOutputter out = new XMLOutputter();
            for (String xp : xpaths) {
                XPathExpression xpath = XPathFactory.instance().compile(xp, Filters.content());
                for (Content node : xpath.evaluate((Object)doc)) {
                    if (node instanceof Element) {
                        result.add(out.outputString((Element)node));
                        continue;
                    }
                    if (!(node instanceof Text)) continue;
                    result.add(out.outputString((Text)node));
                }
            }
            return result;
        }
        catch (JDOMException xpe) {
            throw new IllegalArgumentException("error while processing xpath expressions: '" + xpaths + "'", xpe);
        }
    }

    public String getLocalName() {
        return "xpath";
    }

    public String getSignature() {
        return "fn:xpath(xpath: String [, nodes: XMLLiteralList]) : LiteralList";
    }

    public String getDescription() {
        return "Evaluate an XPath expression on either the value of the context node or the values of the nodes passed as arguments.";
    }
}

