/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.ldpath.model.functions.xml;

import java.util.regex.Pattern;
import org.apache.marmotta.ldpath.model.functions.AbstractTextFilterFunction;

public class RemoveXmlTagsFunction<Node>
extends AbstractTextFilterFunction<Node> {
    static final Pattern XML_TAG = Pattern.compile("<(\"[^\"]*\"|'[^']*'|[^>])*>", 8);

    protected String doFilter(String in) {
        return XML_TAG.matcher(in).replaceAll("");
    }

    public String getLocalName() {
        return "removeTags";
    }

    public String getDescription() {
        return "Function to remove all XML or HTML tags from the content. Can be used in-path, using the current context nodes as argument.";
    }
}

