/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.commons.sesame.test.sparql;

import org.apache.marmotta.commons.sesame.test.base.AbstractRepositoryConnectionMatcher;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;

public abstract class SparqlMatcher<T extends RepositoryConnection>
extends AbstractRepositoryConnectionMatcher<T> {
    protected final String baseUri;
    protected final String query;

    protected SparqlMatcher(String baseUri, String query) {
        if (query == null) {
            throw new IllegalArgumentException("query must not be null");
        }
        this.baseUri = baseUri;
        this.query = query;
    }

    @Override
    protected final boolean matchesConnection(RepositoryConnection connection) throws RepositoryException {
        try {
            return this.matchesSPARQL(connection);
        }
        catch (MalformedQueryException e) {
            throw new IllegalArgumentException("Invalid SPARQL Query: " + this.query, e);
        }
        catch (QueryEvaluationException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    protected abstract boolean matchesSPARQL(RepositoryConnection var1) throws MalformedQueryException, RepositoryException, QueryEvaluationException;
}

