/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.versioning.filter;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.core.api.modules.MarmottaHttpFilter;
import org.apache.marmotta.platform.versioning.utils.MementoUtils;
import org.slf4j.Logger;

@ApplicationScoped
public class MementoFilter
implements MarmottaHttpFilter {
    private static final String FILTER_PATTERN = "/(resource|meta|content)/.*";
    @Inject
    private Logger log;
    @Inject
    ConfigurationService configurationService;
    private static final Pattern URI_PATTERN = Pattern.compile("(/[^/]*){3}/(.*)");

    public String getPattern() {
        return FILTER_PATTERN;
    }

    public int getPriority() {
        return 0x3FFFFFFF;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.log.info("init memento filter");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest request;
        if (servletRequest instanceof HttpServletRequest && ((request = (HttpServletRequest)servletRequest).getMethod().equals("GET") || request.getMethod().equals("HEAD"))) {
            HttpServletResponse response = (HttpServletResponse)servletResponse;
            URL resource = this.getResourceURL(request);
            if (resource != null) {
                response.addHeader("Link", "<" + MementoUtils.timegateURI(resource.toString(), this.configurationService.getBaseUri()) + ">; rel=\"timegate\"," + "<" + MementoUtils.timemapURI(resource.toString(), this.configurationService.getBaseUri()) + ">; rel=\"timemap\"");
            }
            filterChain.doFilter(servletRequest, (ServletResponse)response);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    private URL getResourceURL(HttpServletRequest request) {
        try {
            if (request.getParameter("uri") != null) {
                if (request.getParameter("uri").startsWith("http://") || request.getParameter("uri").startsWith("https://")) {
                    return new URL(request.getParameter("uri"));
                }
            } else {
                if (request.getRequestURI().startsWith("/resource/")) {
                    return new URL(request.getRequestURL().toString());
                }
                if (request.getRequestURI().startsWith("/content/") || request.getRequestURI().startsWith("/meta/")) {
                    return new URL(this.restoreResource(request.getRequestURI()));
                }
            }
        }
        catch (MalformedURLException e) {
            this.log.error(e.getMessage());
        }
        return null;
    }

    private String restoreResource(String uri) throws MalformedURLException {
        Matcher m = URI_PATTERN.matcher(uri);
        if (m.matches()) {
            return this.configurationService.getBaseUri() + "resource" + "/" + m.group(2);
        }
        throw new MalformedURLException("original url can not be restored");
    }

    public void destroy() {
    }
}

