/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.versioning.model;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.marmotta.kiwi.versioning.model.Version;
import org.apache.marmotta.platform.versioning.exception.MementoException;
import org.apache.marmotta.platform.versioning.utils.MementoUtils;
import org.openrdf.model.Resource;

public class MementoVersionSet {
    private Version first;
    private Version last;
    private Version previous;
    private Version next;
    private Version current;
    private Resource original;

    public MementoVersionSet(Resource resource) {
        this.original = resource;
    }

    public Set<String> buildLinks(String baseURI) throws MementoException {
        String prefix = baseURI + "memento" + "/" + "resource" + "/";
        HashSet<String> links = new HashSet<String>();
        if (this.first == null || this.last == null || this.current == null) {
            throw new MementoException("Memento links cannot be produced");
        }
        links.add(this.buildLink(prefix, this.original.toString(), this.first.getCommitTime(), "first memento"));
        links.add(this.buildLink(prefix, this.original.toString(), this.last.getCommitTime(), "last memento"));
        links.add(this.buildLink(prefix, this.original.toString(), this.current.getCommitTime(), "memento"));
        links.add("<" + this.original.toString() + ">;rel=\"original\"");
        if (this.next != null) {
            links.add(this.buildLink(prefix, this.original.toString(), this.next.getCommitTime(), "next memento"));
        }
        if (this.previous != null) {
            links.add(this.buildLink(prefix, this.original.toString(), this.previous.getCommitTime(), "prev memento"));
        }
        return links;
    }

    private String buildLink(String prefix, String resource, Date date, String rel) {
        return "<" + prefix + MementoUtils.MEMENTO_DATE_FORMAT.format(date) + "/" + resource + ">;datetime=\"" + MementoUtils.MEMENTO_DATE_FORMAT.format(date) + "\";rel=\"" + rel + "\"";
    }

    public Resource getOriginal() {
        return this.original;
    }

    public Version getFirst() {
        return this.first;
    }

    public void setFirst(Version first) {
        this.first = first;
    }

    public Version getLast() {
        return this.last;
    }

    public void setLast(Version last) {
        this.last = last;
    }

    public Version getPrevious() {
        return this.previous;
    }

    public void setPrevious(Version previous) {
        this.previous = previous;
    }

    public Version getNext() {
        return this.next;
    }

    public void setNext(Version next) {
        this.next = next;
    }

    public Version getCurrent() {
        return this.current;
    }

    public void setCurrent(Version current) {
        this.current = current;
    }
}

