/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.versioning.webservices;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.marmotta.commons.http.ContentType;
import org.apache.marmotta.commons.http.MarmottaHttpUtils;
import org.apache.marmotta.commons.util.DateUtils;
import org.apache.marmotta.kiwi.versioning.model.Version;
import org.apache.marmotta.kiwi.versioning.repository.SnapshotRepositoryConnection;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.apache.marmotta.platform.core.api.io.MarmottaIOService;
import org.apache.marmotta.platform.core.api.triplestore.SesameService;
import org.apache.marmotta.platform.versioning.api.MementoService;
import org.apache.marmotta.platform.versioning.api.VersionSerializerService;
import org.apache.marmotta.platform.versioning.exception.MementoException;
import org.apache.marmotta.platform.versioning.io.VersionSerializer;
import org.apache.marmotta.platform.versioning.model.MementoVersionSet;
import org.apache.marmotta.platform.versioning.services.VersioningSailProvider;
import org.apache.marmotta.platform.versioning.utils.MementoUtils;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFWriter;
import org.openrdf.rio.Rio;
import org.openrdf.sail.SailException;
import org.slf4j.Logger;

@ApplicationScoped
@Path(value="/memento")
public class MementoWebService {
    @Inject
    private Logger log;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private SesameService sesameService;
    @Inject
    private MementoService mementoService;
    @Inject
    private VersioningSailProvider versioningService;
    @Inject
    private MarmottaIOService lmfIOService;
    @Inject
    private VersionSerializerService versionSerializerService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/timegate/{resource:.+}")
    public Response timgateService(@PathParam(value="resource") String resource_string, @HeaderParam(value="Accept-Datetime") String date_string) {
        Response response;
        Preconditions.checkNotNull((Object)resource_string, (Object)"Resource URI may not null");
        Preconditions.checkNotNull((Object)date_string, (Object)"Accept-Datetime Header may not be null");
        RepositoryConnection conn = this.sesameService.getConnection();
        try {
            Date date = DateUtils.parseDate((String)date_string);
            URI resource = conn.getValueFactory().createURI(resource_string);
            MementoVersionSet versions = this.mementoService.getVersionSet((Resource)resource, date);
            Set<String> links = versions.buildLinks(this.configurationService.getBaseUri());
            links.add("<" + MementoUtils.timemapURI(resource_string, this.configurationService.getBaseUri()) + ">;rel=timemap");
            response = Response.status((int)301).location(MementoUtils.resourceURI(resource_string, versions.getCurrent().getCommitTime(), this.configurationService.getBaseUri())).header("Vary", (Object)"negotiate, accept-datetime, accept").header("Memento-Datetime", (Object)versions.getCurrent().getCommitTime().toString()).header("Link", (Object)Joiner.on((String)", ").join(links)).build();
        }
        catch (MementoException e) {
            Response response2;
            try {
                response2 = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
            }
            catch (Throwable throwable) {
                try {
                    conn.commit();
                    conn.close();
                    throw throwable;
                }
                catch (RepositoryException e2) {
                    return Response.serverError().entity((Object)"Versioning sail cannot be initialized").build();
                }
                catch (IllegalArgumentException e3) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e3.getMessage()).build();
                }
                catch (NullPointerException e4) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e4.getMessage()).build();
                }
            }
            conn.commit();
            conn.close();
            return response2;
        }
        conn.commit();
        conn.close();
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/resource/{date:[^/]+}/{resource:.+}")
    public Response resourceService(@PathParam(value="date") String date_string, @PathParam(value="resource") String resource_string, @HeaderParam(value="Accept") String types_string) {
        try {
            Preconditions.checkNotNull((Object)resource_string, (Object)"Resource URI may not null");
            Preconditions.checkNotNull((Object)date_string, (Object)"Date may not be null");
            Preconditions.checkNotNull((Object)types_string, (Object)"Accept Header may not be null");
            RepositoryConnection conn = this.sesameService.getConnection();
            try {
                final Date date = MementoUtils.MEMENTO_DATE_FORMAT.parse(date_string);
                final URI resource = conn.getValueFactory().createURI(resource_string);
                ContentType type = this.getContentType(types_string);
                final RDFFormat serializer = this.lmfIOService.getSerializer(type.getMime());
                StreamingOutput entity = new StreamingOutput(){

                    public void write(OutputStream output) throws IOException, WebApplicationException {
                        RDFWriter writer = Rio.createWriter((RDFFormat)serializer, (OutputStream)output);
                        try {
                            SnapshotRepositoryConnection con = MementoWebService.this.versioningService.getSnapshot(date);
                            URI subject = con.getValueFactory().createURI(resource.stringValue());
                            try {
                                con.exportStatements((Resource)subject, null, null, true, (RDFHandler)writer, new Resource[0]);
                            }
                            catch (RepositoryException e) {
                                throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
                            }
                            catch (RDFHandlerException e) {
                                throw new IOException("error while writing RDF data to stream");
                            }
                            finally {
                                con.commit();
                                con.close();
                            }
                        }
                        catch (RepositoryException e) {
                            throw new WebApplicationException((Throwable)e, Response.Status.INTERNAL_SERVER_ERROR);
                        }
                    }
                };
                MementoVersionSet versions = this.mementoService.getVersionSet((Resource)resource, date);
                Set<String> links = versions.buildLinks(this.configurationService.getBaseUri());
                links.add("<" + MementoUtils.timegateURI(resource_string, this.configurationService.getBaseUri()) + ">;rel=timegate");
                links.add("<" + MementoUtils.timemapURI(resource_string, this.configurationService.getBaseUri()) + ">;rel=timemap");
                Response response = Response.ok().header("Link", (Object)Joiner.on((String)", ").join(links)).header("Content-Type", (Object)type.toString()).header("Memento-Datetime", (Object)MementoUtils.MEMENTO_DATE_FORMAT.format(versions.getCurrent().getCommitTime())).entity((Object)entity).build();
                return response;
            }
            catch (ParseException e) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Cannot parse date").build();
                return response;
            }
            catch (IllegalArgumentException e) {
                Response response = Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
                return response;
            }
            catch (MementoException e) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)e.getMessage()).build();
                return response;
            }
            finally {
                conn.commit();
                conn.close();
            }
        }
        catch (IllegalArgumentException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
        catch (RepositoryException e) {
            return Response.serverError().entity((Object)"Versioning sail cannot be initialized").build();
        }
        catch (NullPointerException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Path(value="/timemap/{resource:.+}")
    public Response timemapService(@PathParam(value="resource") String resource_string, @HeaderParam(value="Accept") String types_string) {
        try {
            Preconditions.checkNotNull((Object)resource_string, (Object)"Resource URI may not null");
            Preconditions.checkNotNull((Object)types_string, (Object)"Accept Header may not be null");
            RepositoryConnection conn = this.sesameService.getConnection();
            try {
                final URI resource = conn.getValueFactory().createURI(resource_string);
                List types = MarmottaHttpUtils.parseAcceptHeader((String)types_string);
                final RepositoryResult<Version> versions = this.versioningService.listVersions((Resource)resource);
                final VersionSerializer serializer = this.versionSerializerService.getSerializer(types);
                StreamingOutput entity = new StreamingOutput(){

                    public void write(OutputStream output) throws IOException, WebApplicationException {
                        serializer.write((Resource)resource, (RepositoryResult<Version>)versions, output);
                    }
                };
                HashSet<String> links = new HashSet<String>();
                links.add("<" + MementoUtils.timegateURI(resource_string, this.configurationService.getBaseUri()) + ">;rel=timegate");
                links.add("<" + resource_string + ">;rel=original");
                Response response = Response.ok().header("Link", (Object)Joiner.on((String)", ").join(links)).header("Content-Type", (Object)serializer.getContentType().toString()).entity((Object)entity).build();
                return response;
            }
            catch (SailException e) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Cannot list versions").build();
                return response;
            }
            catch (IOException e) {
                Response response = Response.status((Response.Status)Response.Status.UNSUPPORTED_MEDIA_TYPE).entity((Object)"cannot produce content type").build();
                return response;
            }
            finally {
                conn.commit();
                conn.close();
            }
        }
        catch (RepositoryException e) {
            return Response.serverError().entity((Object)"Versioning sail cannot be initialized").build();
        }
        catch (NullPointerException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)e.getMessage()).build();
        }
    }

    private ContentType getContentType(String types) throws IllegalArgumentException {
        List acceptedTypes = MarmottaHttpUtils.parseAcceptHeader((String)types);
        List offeredTypes = MarmottaHttpUtils.parseStringList((Collection)this.lmfIOService.getProducedTypes());
        ContentType type = MarmottaHttpUtils.bestContentType((List)offeredTypes, (List)acceptedTypes);
        if (type == null) {
            throw new IllegalArgumentException("Requested type is not supported");
        }
        return type;
    }
}

