/*
 * Decompiled with CFR 0.152.
 */
package org.apache.marmotta.platform.zookeeper.listeners;

import at.salzburgresearch.nodekeeper.NodeKeeper;
import at.salzburgresearch.nodekeeper.NodeListener;
import at.salzburgresearch.nodekeeper.exception.NodeKeeperException;
import at.salzburgresearch.nodekeeper.model.Node;
import java.io.IOException;
import java.util.Arrays;
import java.util.UUID;
import org.apache.marmotta.platform.core.api.config.ConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationListener
extends NodeListener<String> {
    private static Logger log = LoggerFactory.getLogger(ConfigurationListener.class);
    private ConfigurationService configurationService;

    public ConfigurationListener(ConfigurationService configurationService, NodeKeeper nodekeeper) {
        this.configurationService = configurationService;
        this.nodekeeper = nodekeeper;
    }

    public void onNodeCreated(Node<String> node) {
        ConfigurationLevel level = this.getConfigurationLevel(node);
        String key = node.getPath().substring(node.getPath().lastIndexOf("/") + 1);
        String value = (String)node.getData();
        try {
            for (ConfigurationLevel existing : new ConfigurationLevel[]{ConfigurationLevel.GLOBAL, ConfigurationLevel.CLUSTER, ConfigurationLevel.INSTANCE}) {
                String exvalue;
                if (existing.compareTo(level) <= 0 || (exvalue = this.getConfiguration(key, existing)) == null) continue;
                log.info("ZOOKEEPER: ignoring configuration option {}, because there is a more specific configuration on level {}", (Object)key, (Object)existing);
                return;
            }
            log.info("ZOOKEEPER: setting configuration option {} = {}", (Object)key, (Object)value);
            if (value.contains("\n")) {
                this.configurationService.setListConfiguration(key, Arrays.asList(value.split("\n")));
            } else {
                this.configurationService.setConfiguration(key, value);
            }
        }
        catch (NodeKeeperException | IOException | InterruptedException e) {
            log.error("ZOOKEEPER: error reading Zookeeper configuration", e);
        }
    }

    public void onNodeUpdated(Node<String> node) {
        this.onNodeCreated(node);
    }

    public void onNodeDeleted(Node<String> node) {
        ConfigurationLevel level = this.getConfigurationLevel(node);
        String key = node.getPath().substring(node.getPath().lastIndexOf("/") + 1);
        try {
            String exvalue;
            for (ConfigurationLevel existing : new ConfigurationLevel[]{ConfigurationLevel.GLOBAL, ConfigurationLevel.CLUSTER, ConfigurationLevel.INSTANCE}) {
                if (existing.compareTo(level) <= 0 || (exvalue = this.getConfiguration(key, existing)) == null) continue;
                log.info("ZOOKEEPER: ignoring delete option {}, because there is a more specific configuration on level {}", (Object)key, (Object)existing);
                return;
            }
            for (ConfigurationLevel existing : new ConfigurationLevel[]{ConfigurationLevel.INSTANCE, ConfigurationLevel.CLUSTER, ConfigurationLevel.GLOBAL}) {
                if (existing.compareTo(level) >= 0 || (exvalue = this.getConfiguration(key, existing)) == null) continue;
                log.info("ZOOKEEPER: iupdating option {} to its more generic value {} at level {}", new Object[]{key, exvalue, existing});
                this.configurationService.setConfiguration(key, exvalue);
                return;
            }
            log.info("ZOOKEEPER: deleting configuration option {}", (Object)key);
            this.configurationService.removeConfiguration(key);
        }
        catch (NodeKeeperException | IOException | InterruptedException e) {
            log.error("ZOOKEEPER: error reading Zookeeper configuration", e);
        }
    }

    public Class<String> getType() {
        return String.class;
    }

    private String getConfiguration(String key, ConfigurationLevel level) throws InterruptedException, IOException, NodeKeeperException {
        String path;
        String uuid = this.configurationService.getStringConfiguration("zookeeper.instance", UUID.randomUUID().toString());
        String cluster = this.configurationService.getStringConfiguration("zookeeper.cluster", "default");
        switch (level) {
            case INSTANCE: {
                path = String.format("/marmotta/clusters/%s/instances/%s/config/%s", cluster, uuid, key);
                break;
            }
            case CLUSTER: {
                path = String.format("/marmotta/clusters/%s/config/%s", cluster, key);
                break;
            }
            default: {
                path = String.format("/marmotta/config/%s", key);
            }
        }
        Node node = this.nodekeeper.readNode(path, String.class);
        if (node != null) {
            return (String)node.getData();
        }
        return null;
    }

    private ConfigurationLevel getConfigurationLevel(Node<String> node) {
        if (node.getPath().contains("instances")) {
            return ConfigurationLevel.INSTANCE;
        }
        if (node.getPath().contains("clusters")) {
            return ConfigurationLevel.CLUSTER;
        }
        return ConfigurationLevel.GLOBAL;
    }

    private static enum ConfigurationLevel {
        GLOBAL,
        CLUSTER,
        INSTANCE;

    }
}

