/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency.graph.tasks;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.archiva.dependency.graph.DependencyGraph;
import org.apache.maven.archiva.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.archiva.dependency.graph.DependencyGraphEdge;
import org.apache.maven.archiva.dependency.graph.DependencyGraphNode;
import org.apache.maven.archiva.dependency.graph.DependencyGraphUtils;
import org.apache.maven.archiva.dependency.graph.tasks.DependencyManagementStack;
import org.apache.maven.archiva.dependency.graph.walk.BaseVisitor;
import org.apache.maven.archiva.dependency.graph.walk.DependencyGraphVisitor;
import org.apache.maven.archiva.model.ArtifactReference;
import org.apache.maven.archiva.model.VersionedReference;

public class DependencyManagementApplier
extends BaseVisitor
implements DependencyGraphVisitor {
    private DependencyManagementStack depStack = new DependencyManagementStack();
    private DependencyGraphBuilder builder;
    private Map nodeVersionChanges = new HashMap();
    private int nodesAdded = 0;

    public void discoverGraph(DependencyGraph graph) {
        super.discoverGraph(graph);
        this.nodeVersionChanges.clear();
        this.depStack.reset();
        this.nodesAdded = 0;
    }

    public void discoverNode(DependencyGraphNode node) {
        super.discoverNode(node);
        this.depStack.push(node);
        List edgesFrom = this.graph.getEdgesFrom(node);
        for (DependencyGraphEdge edge : edgesFrom) {
            DependencyManagementStack.Rules rules = this.depStack.getRules(edge);
            if (rules == null) continue;
            DependencyGraphNode subnode = this.graph.getNode(edge.getNodeTo());
            node.getExcludes().addAll(rules.exclusions);
            String specifiedVersion = rules.artifact.getVersion();
            String trackedVersion = (String)this.nodeVersionChanges.get(edge.getNodeTo());
            String nodeVersion = subnode.getArtifact().getVersion();
            String actualVersion = StringUtils.defaultString((String)trackedVersion, (String)nodeVersion);
            if (!StringUtils.equals((String)specifiedVersion, (String)actualVersion)) {
                this.nodeVersionChanges.put(edge.getNodeTo(), specifiedVersion);
            }
            if (!StringUtils.isNotBlank((String)rules.scope)) continue;
            edge.setScope(rules.scope);
        }
    }

    public void finishNode(DependencyGraphNode node) {
        super.finishNode(node);
        this.depStack.pop();
    }

    public void finishGraph(DependencyGraph graph) {
        super.finishGraph(graph);
        for (ArtifactReference ref : this.nodeVersionChanges.keySet()) {
            String toVersion = (String)this.nodeVersionChanges.get(ref);
            this.collapseVersions(graph, ref, ref.getVersion(), toVersion);
        }
    }

    private void collapseVersions(DependencyGraph graph, ArtifactReference fromRef, String fromVersion, String toVersion) {
        if (StringUtils.equals((String)fromVersion, (String)toVersion)) {
            return;
        }
        ArtifactReference toRef = new ArtifactReference();
        toRef.setGroupId(fromRef.getGroupId());
        toRef.setArtifactId(fromRef.getArtifactId());
        toRef.setVersion(toVersion);
        toRef.setClassifier(fromRef.getClassifier());
        toRef.setType(fromRef.getType());
        DependencyGraphNode nodeFROM = graph.getNode(fromRef);
        DependencyGraphNode nodeTO = graph.getNode(toRef);
        if (nodeTO == null) {
            nodeTO = new DependencyGraphNode(toRef);
            nodeTO.setResolved(false);
            graph.addNode(nodeTO);
            VersionedReference projectRef = new VersionedReference();
            projectRef.setGroupId(toRef.getGroupId());
            projectRef.setArtifactId(toRef.getArtifactId());
            projectRef.setVersion(toRef.getVersion());
            this.builder.resolveNode(graph, nodeTO, projectRef);
            ++this.nodesAdded;
        }
        DependencyGraphUtils.collapseNodes(graph, nodeFROM, nodeTO);
    }

    public DependencyGraphBuilder getBuilder() {
        return this.builder;
    }

    public void setBuilder(DependencyGraphBuilder builder) {
        this.builder = builder;
    }

    public boolean hasCreatedNodes() {
        return this.nodesAdded > 0;
    }
}

