/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency.graph.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.maven.archiva.dependency.graph.DependencyGraph;
import org.apache.maven.archiva.dependency.graph.DependencyGraphKeys;
import org.apache.maven.archiva.dependency.graph.DependencyGraphNode;
import org.apache.maven.archiva.dependency.graph.GraphTask;
import org.apache.maven.archiva.dependency.graph.PotentialCyclicEdgeProducer;
import org.apache.maven.archiva.dependency.graph.functors.ToArtifactReferenceTransformer;
import org.apache.maven.archiva.dependency.graph.tasks.RefineConflictsVisitor;
import org.apache.maven.archiva.dependency.graph.walk.WalkDepthFirstSearch;

public class RefineConflictsTask
implements GraphTask,
PotentialCyclicEdgeProducer {
    public void executeTask(DependencyGraph graph) {
        WalkDepthFirstSearch walker = new WalkDepthFirstSearch();
        RefineConflictsVisitor refineConflictsVisitor = new RefineConflictsVisitor();
        MultiValueMap depMap = new MultiValueMap();
        for (DependencyGraphNode node : graph.getNodes()) {
            String key = DependencyGraphKeys.toManagementKey(node.getArtifact());
            depMap.put((Object)key, (Object)node);
        }
        ToArtifactReferenceTransformer nodeToArtifact = new ToArtifactReferenceTransformer();
        for (Map.Entry entry : depMap.entrySet()) {
            Collection nodes = (Collection)entry.getValue();
            if (nodes.size() <= 1) continue;
            ArrayList conflictingArtifacts = new ArrayList();
            conflictingArtifacts.addAll(nodes);
            CollectionUtils.transform(conflictingArtifacts, (Transformer)nodeToArtifact);
            refineConflictsVisitor.resetConflictingArtifacts();
            refineConflictsVisitor.addAllConflictingArtifacts(conflictingArtifacts);
            walker.visit(graph, refineConflictsVisitor);
        }
    }

    public String getTaskId() {
        return "refine-conflicts";
    }
}

