/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency.graph.tasks;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.archiva.dependency.graph.DependencyGraphEdge;
import org.apache.maven.archiva.dependency.graph.walk.BaseVisitor;
import org.apache.maven.archiva.dependency.graph.walk.DependencyGraphVisitor;
import org.apache.maven.archiva.dependency.graph.walk.DependencyGraphWalker;
import org.apache.maven.archiva.model.ArtifactReference;

public class FlagCyclicEdgesVisitor
extends BaseVisitor
implements DependencyGraphVisitor {
    private DependencyGraphWalker walker;
    private Set cyclicEdges = new HashSet();

    public FlagCyclicEdgesVisitor(DependencyGraphWalker walker) {
        this.walker = walker;
    }

    public void discoverEdge(DependencyGraphEdge edge) {
        ArtifactReference artifact = edge.getNodeTo();
        if (this.walker.getNodeVisitState(artifact) == DependencyGraphWalker.PROCESSING) {
            edge.setDisabled(true);
            edge.setDisabledType(0);
            edge.setDisabledReason("Cycle detected");
            this.cyclicEdges.add(edge);
        }
    }

    public Set getCyclicEdges() {
        return this.cyclicEdges;
    }
}

