/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency.graph.tasks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.archiva.dependency.graph.DependencyGraph;
import org.apache.maven.archiva.dependency.graph.DependencyGraphEdge;
import org.apache.maven.archiva.dependency.graph.DependencyGraphKeys;
import org.apache.maven.archiva.dependency.graph.DependencyGraphNode;
import org.apache.maven.archiva.dependency.graph.tasks.AbstractReduceEdgeVisitor;
import org.apache.maven.archiva.dependency.graph.walk.DependencyGraphVisitor;

public class ReduceTransitiveEdgesVisitor
extends AbstractReduceEdgeVisitor
implements DependencyGraphVisitor {
    private Map nodeDistanceMap = new HashMap();
    private int currentDepth;

    public void discoverGraph(DependencyGraph graph) {
        super.discoverGraph(graph);
        this.nodeDistanceMap.clear();
        this.currentDepth = 0;
    }

    public void discoverEdge(DependencyGraphEdge edge) {
        EdgeInfo edgeInfo;
        String nodeTo = DependencyGraphKeys.toKey(edge.getNodeTo());
        String nodeFrom = DependencyGraphKeys.toKey(edge.getNodeFrom());
        HashMap<String, EdgeInfo> edgeInfoMap = (HashMap<String, EdgeInfo>)this.nodeDistanceMap.get(nodeTo);
        if (edgeInfoMap == null) {
            edgeInfoMap = new HashMap<String, EdgeInfo>();
            this.nodeDistanceMap.put(nodeTo, edgeInfoMap);
        }
        if ((edgeInfo = (EdgeInfo)edgeInfoMap.get(nodeFrom)) == null) {
            edgeInfo = new EdgeInfo();
            edgeInfo.edge = edge;
            edgeInfo.depth = this.currentDepth;
            edgeInfoMap.put(nodeFrom, edgeInfo);
        } else if (this.currentDepth < edgeInfo.depth) {
            edgeInfo.depth = this.currentDepth;
            edgeInfoMap.put(nodeFrom, edgeInfo);
        }
        this.nodeDistanceMap.put(nodeTo, edgeInfoMap);
    }

    public void discoverNode(DependencyGraphNode node) {
        super.discoverNode(node);
        ++this.currentDepth;
    }

    public void finishNode(DependencyGraphNode node) {
        super.finishNode(node);
        --this.currentDepth;
    }

    public void finishGraph(DependencyGraph graph) {
        super.finishGraph(graph);
        EdgeInfoDepthComparator edgeInfoDepthComparator = new EdgeInfoDepthComparator();
        for (Map edgeInfoMap : this.nodeDistanceMap.values()) {
            if (edgeInfoMap.size() <= 1) continue;
            ArrayList edgeInfos = new ArrayList();
            edgeInfos.addAll(edgeInfoMap.values());
            Collections.sort(edgeInfos, edgeInfoDepthComparator);
            for (int i = 1; i < edgeInfos.size(); ++i) {
                EdgeInfo edgeInfo = (EdgeInfo)edgeInfos.get(i);
                graph.removeEdge(edgeInfo.edge);
            }
        }
    }

    class EdgeInfoDepthComparator
    implements Comparator {
        EdgeInfoDepthComparator() {
        }

        public int compare(Object obj0, Object obj1) {
            EdgeInfo edgeInfo0 = (EdgeInfo)obj0;
            EdgeInfo edgeInfo1 = (EdgeInfo)obj1;
            return edgeInfo0.depth - edgeInfo1.depth;
        }
    }

    class EdgeInfo {
        public DependencyGraphEdge edge;
        public int depth = Integer.MAX_VALUE;

        EdgeInfo() {
        }
    }
}

