/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency.graph.tasks;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.comparators.ReverseComparator;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.commons.collections.list.TypedList;
import org.apache.maven.archiva.common.utils.VersionComparator;
import org.apache.maven.archiva.dependency.graph.DependencyGraph;
import org.apache.maven.archiva.dependency.graph.DependencyGraphEdge;
import org.apache.maven.archiva.dependency.graph.DependencyGraphKeys;
import org.apache.maven.archiva.dependency.graph.DependencyGraphNode;
import org.apache.maven.archiva.dependency.graph.DependencyGraphUtils;
import org.apache.maven.archiva.dependency.graph.walk.BaseVisitor;
import org.apache.maven.archiva.dependency.graph.walk.DependencyGraphVisitor;
import org.apache.maven.archiva.model.ArtifactReference;

public class RefineConflictsVisitor
extends BaseVisitor
implements DependencyGraphVisitor {
    private List conflictingArtifacts;
    private Map foundNodesMap = new HashMap();
    private int currentDepth = 0;
    private DependencyGraph currentGraph;

    public RefineConflictsVisitor() {
        this.conflictingArtifacts = TypedList.decorate(new ArrayList(), ArtifactReference.class);
    }

    public void discoverGraph(DependencyGraph graph) {
        super.discoverGraph(graph);
        this.currentGraph = graph;
        this.foundNodesMap.clear();
    }

    public void discoverNode(DependencyGraphNode node) {
        super.discoverNode(node);
        ++this.currentDepth;
        List edgesFrom = this.currentGraph.getEdgesFrom(node);
        for (DependencyGraphEdge edge : edgesFrom) {
            String nodeKey;
            NodeLocation nodeloc;
            if (!this.conflictingArtifacts.contains(edge.getNodeTo()) || (nodeloc = (NodeLocation)this.foundNodesMap.get(nodeKey = DependencyGraphKeys.toKey(edge.getNodeTo()))) != null && this.currentDepth >= nodeloc.depth) continue;
            nodeloc = new NodeLocation(edge.getNodeTo(), edge, this.currentDepth);
            this.foundNodesMap.put(nodeKey, nodeloc);
        }
    }

    public void finishGraph(DependencyGraph graph) {
        super.finishGraph(graph);
        if (MapUtils.isEmpty((Map)this.foundNodesMap)) {
            return;
        }
        ArtifactReference winningArtifact = this.findWinningArtifact(this.foundNodesMap.values());
        DependencyGraphNode winningNode = graph.getNode(winningArtifact);
        HashSet losingNodes = new HashSet();
        Predicate losersPredicate = NotPredicate.getInstance((Predicate)new NodeLocationPredicate(winningArtifact));
        CollectionUtils.select(this.foundNodesMap.values(), (Predicate)losersPredicate, losingNodes);
        for (NodeLocation losingNodeLoc : losingNodes) {
            DependencyGraphNode losingNode = graph.getNode(losingNodeLoc.artifact);
            DependencyGraphUtils.collapseNodes(graph, losingNode, winningNode);
        }
    }

    private ArtifactReference findWinningArtifact(Collection nodes) {
        ArrayList remainingNodes = new ArrayList();
        remainingNodes.addAll(nodes);
        Collections.sort(remainingNodes, new DepthComparator());
        NodeLocation nearestNode = (NodeLocation)remainingNodes.get(0);
        int nearest = nearestNode.depth;
        DistantNodeLocationPredicate distantLocations = new DistantNodeLocationPredicate(nearest);
        CollectionUtils.filter(remainingNodes, (Predicate)distantLocations);
        if (remainingNodes.size() == 1) {
            NodeLocation nodeloc = (NodeLocation)remainingNodes.get(0);
            return nodeloc.artifact;
        }
        Collections.sort(remainingNodes, new ReverseComparator((Comparator)new NodeLocationVersionComparator()));
        NodeLocation nodeloc = (NodeLocation)remainingNodes.get(0);
        return nodeloc.artifact;
    }

    public void finishNode(DependencyGraphNode node) {
        super.finishNode(node);
        --this.currentDepth;
    }

    public List getConflictingArtifacts() {
        return this.conflictingArtifacts;
    }

    public void addAllConflictingArtifacts(Collection nodes) {
        this.conflictingArtifacts.addAll(nodes);
    }

    public void resetConflictingArtifacts() {
        this.conflictingArtifacts.clear();
    }

    class DistantNodeLocationPredicate
    implements Predicate {
        private int cutoff;

        public DistantNodeLocationPredicate(int distantCutoff) {
            this.cutoff = distantCutoff;
        }

        public boolean evaluate(Object object) {
            boolean satisfies = false;
            if (object instanceof NodeLocation) {
                NodeLocation nodeloc = (NodeLocation)object;
                satisfies = nodeloc.depth >= this.cutoff;
            }
            return satisfies;
        }
    }

    class NodeLocationVersionComparator
    implements Comparator {
        NodeLocationVersionComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null && o2 != null) {
                return 1;
            }
            if (o1 != null && o2 == null) {
                return -1;
            }
            if (o1 instanceof NodeLocation && o2 instanceof NodeLocation) {
                String version1 = ((NodeLocation)o1).artifact.getVersion();
                String version2 = ((NodeLocation)o2).artifact.getVersion();
                VersionComparator.getInstance().compare(version1, version2);
            }
            return 0;
        }
    }

    class NodeLocationPredicate
    implements Predicate {
        private ArtifactReference artifact;

        public NodeLocationPredicate(ArtifactReference artifact) {
            this.artifact = artifact;
        }

        public NodeLocationPredicate(DependencyGraphNode node) {
            this(node.getArtifact());
        }

        public boolean evaluate(Object object) {
            boolean satisfies = false;
            if (object instanceof NodeLocation) {
                NodeLocation nodeloc = (NodeLocation)object;
                satisfies = nodeloc.artifact.equals((Object)this.artifact);
            }
            return satisfies;
        }
    }

    class NodeLocation {
        public ArtifactReference artifact;
        public DependencyGraphEdge edge;
        public int depth;

        public NodeLocation(ArtifactReference artifact, DependencyGraphEdge edge, int depth) {
            this.artifact = artifact;
            this.edge = edge;
            this.depth = depth;
        }
    }

    class DepthComparator
    implements Comparator {
        DepthComparator() {
        }

        public int compare(Object obj0, Object obj1) {
            NodeLocation nodeLoc0 = (NodeLocation)obj0;
            NodeLocation nodeLoc1 = (NodeLocation)obj1;
            return nodeLoc0.depth - nodeLoc1.depth;
        }
    }
}

