/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archiva.dependency.graph.walk;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.maven.archiva.dependency.graph.DependencyGraph;
import org.apache.maven.archiva.dependency.graph.DependencyGraphEdge;
import org.apache.maven.archiva.dependency.graph.DependencyGraphNode;
import org.apache.maven.archiva.dependency.graph.functors.EdgeDisabledPredicate;
import org.apache.maven.archiva.dependency.graph.walk.DependencyGraphVisitor;
import org.apache.maven.archiva.dependency.graph.walk.DependencyGraphWalker;
import org.apache.maven.archiva.model.ArtifactReference;

public class WalkBreadthFirstSearch
implements DependencyGraphWalker {
    private Map nodeVisitStates = new HashMap();
    private Predicate edgePredicate = NotPredicate.getInstance((Predicate)new EdgeDisabledPredicate());

    public Predicate getEdgePredicate() {
        return this.edgePredicate;
    }

    public void setEdgePredicate(Predicate edgePredicate) {
        this.edgePredicate = edgePredicate;
    }

    public Integer getNodeVisitState(DependencyGraphNode node) {
        return (Integer)this.nodeVisitStates.get(node.getArtifact());
    }

    public Integer getNodeVisitState(ArtifactReference artifact) {
        return (Integer)this.nodeVisitStates.get(artifact);
    }

    public void setNodeVisitState(DependencyGraphNode node, Integer state) {
        this.nodeVisitStates.put(node.getArtifact(), state);
    }

    public void setNodeVisitState(ArtifactReference artifact, Integer state) {
        this.nodeVisitStates.put(artifact, state);
    }

    private void visitEdge(DependencyGraph graph, DependencyGraphEdge e, DependencyGraphVisitor visitor) {
        visitor.discoverEdge(e);
        DependencyGraphNode node = graph.getNode(e.getNodeTo());
        if (this.getNodeVisitState(node) == UNSEEN) {
            this.setNodeVisitState(node, PROCESSING);
        }
        visitor.finishEdge(e);
    }

    private void visitNode(DependencyGraph graph, DependencyGraphNode node, DependencyGraphVisitor visitor) {
        this.setNodeVisitState(node, PROCESSING);
        visitor.discoverNode(node);
        for (DependencyGraphEdge e : graph.getEdgesFrom(node)) {
            if (!this.edgePredicate.evaluate((Object)e)) continue;
            this.visitEdge(graph, e, visitor);
        }
        for (DependencyGraphEdge e : graph.getEdgesFrom(node)) {
            DependencyGraphNode nodeTo;
            Integer state;
            if (!this.edgePredicate.evaluate((Object)e) || (state = this.getNodeVisitState(nodeTo = graph.getNode(e.getNodeTo()))) != UNSEEN && state != PROCESSING) continue;
            this.visitNode(graph, nodeTo, visitor);
        }
        visitor.finishNode(node);
        this.setNodeVisitState(node, SEEN);
    }

    public void visit(DependencyGraph graph, DependencyGraphVisitor visitor) {
        this.visit(graph, graph.getRootNode(), visitor);
    }

    public void visit(DependencyGraph graph, DependencyGraphNode startNode, DependencyGraphVisitor visitor) {
        this.nodeVisitStates.clear();
        Iterator nodes = graph.getNodes().iterator();
        while (nodes.hasNext()) {
            this.setNodeVisitState((DependencyGraphNode)nodes.next(), UNSEEN);
        }
        visitor.discoverGraph(graph);
        this.visitNode(graph, startNode, visitor);
        visitor.finishGraph(graph);
    }
}

