/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.notification.wagon;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.repository.layout.DefaultRepositoryLayout;
import org.apache.maven.continuum.ContinuumException;
import org.apache.maven.continuum.configuration.ConfigurationException;
import org.apache.maven.continuum.configuration.ConfigurationService;
import org.apache.maven.continuum.model.project.BuildDefinition;
import org.apache.maven.continuum.model.project.BuildResult;
import org.apache.maven.continuum.model.project.Project;
import org.apache.maven.continuum.model.project.ProjectNotifier;
import org.apache.maven.continuum.notification.AbstractContinuumNotifier;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Site;
import org.apache.maven.profiles.DefaultProfileManager;
import org.apache.maven.profiles.ProfileManager;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.settings.MavenSettingsBuilder;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.CommandExecutionException;
import org.apache.maven.wagon.CommandExecutor;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.notification.NotificationException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class WagonContinuumNotifier
extends AbstractContinuumNotifier
implements Contextualizable {
    public static final String BUILD_OUTPUT_FILE_NAME = "buildresult.txt";
    private static final String CONTEXT_MAVEN_PROJECT = "CONTEXT_MAVEN_PROJECT";
    private ConfigurationService configurationService;
    private WagonManager wagonManager;
    private MavenProjectBuilder projectBuilder;
    private MavenSettingsBuilder settingsBuilder;
    private String localRepository;
    private Settings settings;
    private ProfileManager profileManager;
    private PlexusContainer container;

    public void sendNotification(String source, Set recipients, Map configuration, Map context) throws NotificationException {
        Project project = (Project)context.get("project");
        ProjectNotifier projectNotifier = (ProjectNotifier)context.get("projectNotifier");
        BuildResult build = (BuildResult)context.get("build");
        BuildDefinition buildDefinition = (BuildDefinition)context.get("buildDefinition");
        if (build == null) {
            return;
        }
        try {
            MavenProject mavenProject = this.getMavenProject(project, buildDefinition);
            configuration.put(CONTEXT_MAVEN_PROJECT, mavenProject);
            if (source.equals("BuildComplete")) {
                this.buildComplete(project, projectNotifier, build, configuration);
            }
        }
        catch (ContinuumException e) {
            throw new NotificationException("Error while notifiying.", (Throwable)e);
        }
    }

    private void buildComplete(Project project, ProjectNotifier projectNotifier, BuildResult build, Map configuration) throws ContinuumException {
        Wagon wagon;
        String id = null;
        String url = null;
        if (configuration.containsKey("url")) {
            url = (String)configuration.get("url");
            id = (String)configuration.get("id");
        } else {
            MavenProject mavenProject = (MavenProject)configuration.get(CONTEXT_MAVEN_PROJECT);
            DistributionManagement distributionManagement = mavenProject.getDistributionManagement();
            if (distributionManagement == null) {
                throw new ContinuumException("Missing distribution management information in the project.");
            }
            Site site = distributionManagement.getSite();
            if (site == null) {
                throw new ContinuumException("Missing site information in the distribution management element in the project.");
            }
            url = site.getUrl();
            id = site.getId();
        }
        if (url == null) {
            throw new ContinuumException("The URL to the site is not defined.");
        }
        Repository repository = new Repository(id, url);
        try {
            wagon = this.wagonManager.getWagon(repository.getProtocol());
        }
        catch (UnsupportedProtocolException e) {
            throw new ContinuumException("Unsupported protocol: '" + repository.getProtocol() + "'", (Throwable)e);
        }
        if (!wagon.supportsDirectoryCopy()) {
            throw new ContinuumException("Wagon protocol '" + repository.getProtocol() + "' doesn't support directory copying");
        }
        try {
            ProxyInfo proxyInfo;
            if (this.getLogger().isDebugEnabled()) {
                Debug debug = new Debug();
                wagon.addSessionListener((SessionListener)debug);
                wagon.addTransferListener((TransferListener)debug);
            }
            if ((proxyInfo = this.getProxyInfo(repository)) != null) {
                wagon.connect(repository, this.getAuthenticationInfo(id), proxyInfo);
            } else {
                wagon.connect(repository, this.getAuthenticationInfo(id));
            }
            File buildOutputFile = this.configurationService.getBuildOutputFile(build.getId(), build.getProject().getId());
            wagon.put(buildOutputFile, BUILD_OUTPUT_FILE_NAME);
            if (wagon instanceof CommandExecutor) {
                CommandExecutor exec = (CommandExecutor)wagon;
                exec.executeCommand("chmod -Rf g+w " + repository.getBasedir());
            }
        }
        catch (ConfigurationException e) {
            throw new ContinuumException("Error uploading build results to deployed site.", (Throwable)e);
        }
        catch (ResourceDoesNotExistException e) {
            throw new ContinuumException("Error uploading site", (Throwable)e);
        }
        catch (TransferFailedException e) {
            throw new ContinuumException("Error uploading site", (Throwable)e);
        }
        catch (AuthorizationException e) {
            throw new ContinuumException("Error uploading site", (Throwable)e);
        }
        catch (ConnectionException e) {
            throw new ContinuumException("Error uploading site", (Throwable)e);
        }
        catch (AuthenticationException e) {
            throw new ContinuumException("Error uploading site", (Throwable)e);
        }
        catch (CommandExecutionException e) {
            throw new ContinuumException("Error uploading site", (Throwable)e);
        }
        finally {
            try {
                wagon.disconnect();
            }
            catch (ConnectionException e) {
                this.getLogger().error("Error disconnecting wagon - ignored", (Throwable)e);
            }
        }
    }

    public void sendNotification(String arg0, Set arg1, Properties arg2) throws NotificationException {
        throw new NotificationException("Not implemented.");
    }

    private MavenProject getMavenProject(Project project, BuildDefinition buildDefinition) throws ContinuumException {
        File projectWorkingDir = new File(this.configurationService.getWorkingDirectory(), Integer.toString(project.getId()));
        File pomFile = new File(projectWorkingDir, buildDefinition.getBuildFile());
        MavenProject mavenProject = null;
        try {
            mavenProject = this.projectBuilder.build(pomFile, this.getLocalRepository(), this.getProfileManager());
        }
        catch (ProjectBuildingException e) {
            throw new ContinuumException("Unable to acquire the MavenProject in " + pomFile.getAbsolutePath(), (Throwable)e);
        }
        return mavenProject;
    }

    private Settings getSettings() {
        if (this.settings == null) {
            try {
                this.settings = this.settingsBuilder.buildSettings();
            }
            catch (IOException e) {
                this.getLogger().error("Failed to get Settings", (Throwable)e);
            }
            catch (XmlPullParserException e) {
                this.getLogger().error("Failed to get Settings", (Throwable)e);
            }
        }
        return this.settings;
    }

    private ArtifactRepository getLocalRepository() {
        String repo = this.localRepository;
        if (this.getSettings() != null && !StringUtils.isEmpty((String)this.getSettings().getLocalRepository())) {
            repo = this.getSettings().getLocalRepository();
        }
        return new DefaultArtifactRepository("local-repository", "file://" + repo, (ArtifactRepositoryLayout)new DefaultRepositoryLayout());
    }

    private ProfileManager getProfileManager() {
        if (this.profileManager == null) {
            this.profileManager = new DefaultProfileManager(this.container, this.getSettings());
        }
        return this.profileManager;
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }

    private ProxyInfo getProxyInfo(Repository repository) {
        Settings settings = this.getSettings();
        if (settings.getProxies() != null && !settings.getProxies().isEmpty()) {
            for (Proxy p : settings.getProxies()) {
                this.wagonManager.addProxy(p.getProtocol(), p.getHost(), p.getPort(), p.getUsername(), p.getPassword(), p.getNonProxyHosts());
            }
        }
        return this.wagonManager.getProxy(repository.getProtocol());
    }

    private AuthenticationInfo getAuthenticationInfo(String repositoryId) {
        Settings settings = this.getSettings();
        Server server = settings.getServer(repositoryId);
        if (server == null) {
            return null;
        }
        this.wagonManager.addAuthenticationInfo(repositoryId, server.getUsername(), server.getPassword(), server.getPrivateKey(), server.getPassphrase());
        return this.wagonManager.getAuthenticationInfo(repositoryId);
    }
}

