/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.maven.continuum.configuration.ConfigurationService;
import org.apache.maven.continuum.utils.PlexusContainerManager;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class RepositoryBrowseServlet
extends HttpServlet {
    private ConfigurationService configuration;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        PlexusContainer container = PlexusContainerManager.getInstance().getContainer();
        try {
            this.configuration = (ConfigurationService)container.lookup(ConfigurationService.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new ServletException("Unable to get configuration service", (Throwable)e);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        File f = this.getFile(req);
        if (f.exists()) {
            this.doDownload(res, f);
        } else {
            res.sendError(404);
        }
    }

    private File getFile(HttpServletRequest req) {
        String fileName;
        String path = "";
        if (StringUtils.isNotEmpty((String)req.getPathInfo())) {
            path = req.getPathInfo().substring(1);
        }
        if ((fileName = this.cleanUrl(path)).indexOf("..") >= 0 || fileName.startsWith("/")) {
            throw new IllegalArgumentException("file " + fileName + " isn't allowed.");
        }
        return new File(this.configuration.getDeploymentRepositoryDirectory(), fileName);
    }

    protected long getLastModified(HttpServletRequest req) {
        File f = this.getFile(req);
        long mod = f.exists() ? f.lastModified() : super.getLastModified(req);
        return mod;
    }

    public String getServletInfo() {
        return ((Object)((Object)this)).getClass().getName() + " by Continuum Team";
    }

    private void doDownload(HttpServletResponse response, File file) throws IOException {
        if (!file.isFile()) {
            response.sendError(403);
        } else {
            ServletOutputStream output = response.getOutputStream();
            ServletContext context = this.getServletConfig().getServletContext();
            String mimetype = context.getMimeType(file.getName());
            if (mimetype == null) {
                mimetype = "application/octet-stream";
            }
            response.setContentType(mimetype);
            if (!mimetype.startsWith("text/")) {
                response.setHeader("Content-Disposition", "attachement; filename=\"" + file.getName() + "\"");
            }
            IOUtil.copy((InputStream)new FileInputStream(file), (OutputStream)output);
        }
    }

    private String cleanUrl(String url) {
        if (url == null) {
            throw new NullPointerException("The url cannot be null.");
        }
        String pathSeparator = "";
        int indexOfDoubleDot = -1;
        if (url.indexOf("../") > 1) {
            pathSeparator = "/";
            indexOfDoubleDot = url.indexOf("../");
        }
        if (url.indexOf("..\\") > 1) {
            pathSeparator = "\\";
            indexOfDoubleDot = url.indexOf("..\\");
        }
        String newUrl = url;
        if (indexOfDoubleDot > 1) {
            int startOfTextToRemove = url.substring(0, indexOfDoubleDot - 1).lastIndexOf(pathSeparator);
            String beginUrl = "";
            if (startOfTextToRemove >= 0) {
                beginUrl = url.substring(0, startOfTextToRemove);
            }
            String endUrl = url.substring(indexOfDoubleDot + 3);
            newUrl = beginUrl + pathSeparator + endUrl;
            if (newUrl.indexOf("../") > 1 || newUrl.indexOf("..\\") > 1) {
                newUrl = this.cleanUrl(newUrl);
            }
        }
        return newUrl;
    }
}

