/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.web.tool;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.summit.pull.RequestTool;
import org.codehaus.plexus.summit.rundata.RunData;
import org.codehaus.plexus.util.StringUtils;

public class WorkingCopyContentGenerator
extends AbstractLogEnabled
implements RequestTool {
    private String contextPath;
    private File basedir;

    public String generate(Object item, String baseUrl, File basedir) {
        this.basedir = basedir;
        List directoryEntries = (List)item;
        StringBuffer buf = new StringBuffer();
        buf.append("+&nbsp;<a href=\"").append(baseUrl).append("?userDirectory=/\">/</a><br />");
        this.print(directoryEntries, "&nbsp;&nbsp;", baseUrl, buf);
        return buf.toString();
    }

    private void print(List dirs, String indent, String baseUrl, StringBuffer buf) {
        Iterator i = dirs.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            this.print(obj, indent, baseUrl, buf);
        }
    }

    private void print(Object obj, String indent, String baseUrl, StringBuffer buf) {
        if (obj instanceof File) {
            File f = (File)obj;
            if (!f.isDirectory()) {
                String fileName = f.getName();
                if (!(".cvsignore".equals(fileName) || "vssver.scc".equals(fileName) || ".DS_Store".equals(fileName))) {
                    String userDirectory = f.getParentFile().getAbsolutePath().equals(this.basedir.getAbsolutePath()) ? "/" : f.getParentFile().getAbsolutePath().substring(this.basedir.getAbsolutePath().length() + 1);
                    userDirectory = StringUtils.replace((String)userDirectory, (String)"\\", (String)"/");
                    buf.append(indent).append("&nbsp;&nbsp;&nbsp;<a target=\"blank\" href=\"").append(this.getFileUrl(userDirectory, fileName)).append("\">").append(fileName).append("</a><br />");
                }
            } else {
                String directoryName = f.getName();
                if (!("CVS".equals(directoryName) || ".svn".equals(directoryName) || "SCCS".equals(directoryName) || ".bzr".equals(directoryName))) {
                    String userDirectory = f.getAbsolutePath().substring(this.basedir.getAbsolutePath().length() + 1);
                    userDirectory = StringUtils.replace((String)userDirectory, (String)"\\", (String)"/");
                    buf.append(indent).append("+&nbsp;<a href=\"").append(baseUrl).append("?userDirectory=").append(userDirectory).append("\">").append(directoryName).append("</a><br />");
                }
            }
        } else {
            this.print((List)obj, indent + "&nbsp;&nbsp;", baseUrl, buf);
        }
    }

    private String getBrowseServletPath() {
        return this.contextPath + "/servlet/browse?file=";
    }

    private String getFileUrl(String directory, String fileName) {
        String filePath = StringUtils.isEmpty((String)directory) || "/".equals(directory) ? this.basedir.getName() + "/" + fileName : this.basedir.getName() + "/" + directory + "/" + fileName;
        return this.getBrowseServletPath() + filePath;
    }

    public void setRunData(RunData data) {
        this.contextPath = data.getContextPath();
    }

    public void refresh() {
    }
}

