/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.continuum.xmlrpc.server;

import java.io.IOException;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.maven.continuum.xmlrpc.server.ContinuumXmlRpcConfig;
import org.apache.maven.continuum.xmlrpc.server.ContinuumXmlRpcServletServer;
import org.apache.maven.continuum.xmlrpc.server.PropertiesHandlerMapping;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.server.AbstractReflectiveHandlerMapping;
import org.apache.xmlrpc.server.PropertyHandlerMapping;
import org.apache.xmlrpc.server.RequestProcessorFactoryFactory;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcServerConfigImpl;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLifecycleException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.redback.authentication.AuthenticationDataSource;
import org.codehaus.plexus.redback.authentication.AuthenticationException;
import org.codehaus.plexus.redback.authentication.PasswordBasedAuthenticationDataSource;
import org.codehaus.plexus.redback.policy.AccountLockedException;
import org.codehaus.plexus.redback.system.DefaultSecuritySession;
import org.codehaus.plexus.redback.system.SecuritySession;
import org.codehaus.plexus.redback.system.SecuritySystem;
import org.codehaus.plexus.redback.users.UserNotFoundException;

public class ContinuumXmlRpcServlet
extends HttpServlet {
    private ContinuumXmlRpcServletServer server;
    private SecuritySystem securitySystem;

    public String getServletInfo() {
        return "Continuum XMLRPC Servlet";
    }

    public void destroy() {
        if (this.server != null) {
            try {
                this.getPlexusContainer().release((Object)this.server);
            }
            catch (ServletException e) {
                this.log("Unable to release XmlRpcServletServer.", e);
            }
            catch (ComponentLifecycleException e) {
                this.log("Unable to release XmlRpcServletServer.", e);
            }
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this.ensureContainerSet(servletConfig);
        this.initServer();
    }

    public void initServer() throws ServletException {
        this.server = new ContinuumXmlRpcServletServer();
        try {
            this.securitySystem = (SecuritySystem)this.getPlexusContainer().lookup(SecuritySystem.ROLE);
        }
        catch (ComponentLookupException e) {
            throw new ServletException("Can't init the xml rpc server, unable to obtain security system", (Throwable)e);
        }
        try {
            XmlRpcServerConfigImpl cfg = (XmlRpcServerConfigImpl)this.server.getConfig();
            cfg.setEnabledForExtensions(true);
            PropertiesHandlerMapping mapping = (PropertiesHandlerMapping)((Object)this.lookup(PropertyHandlerMapping.class.getName()));
            mapping.setRequestProcessorFactoryFactory((RequestProcessorFactoryFactory)this.lookup(RequestProcessorFactoryFactory.class.getName()));
            mapping.load();
            mapping.setAuthenticationHandler(this.getAuthenticationHandler());
            this.server.setHandlerMapping((XmlRpcHandlerMapping)mapping);
        }
        catch (XmlRpcException e) {
            throw new ServletException("Can't init the xml rpc server", (Throwable)e);
        }
    }

    private AbstractReflectiveHandlerMapping.AuthenticationHandler getAuthenticationHandler() {
        AbstractReflectiveHandlerMapping.AuthenticationHandler handler = new AbstractReflectiveHandlerMapping.AuthenticationHandler(){

            public boolean isAuthorized(XmlRpcRequest pRequest) {
                if (pRequest.getConfig() instanceof ContinuumXmlRpcConfig) {
                    ContinuumXmlRpcConfig config = (ContinuumXmlRpcConfig)pRequest.getConfig();
                    try {
                        if (config.getBasicUserName() == null) {
                            config.setSecuritySession((SecuritySession)new DefaultSecuritySession());
                            return true;
                        }
                        PasswordBasedAuthenticationDataSource authdatasource = new PasswordBasedAuthenticationDataSource();
                        authdatasource.setPrincipal(config.getBasicUserName());
                        authdatasource.setPassword(config.getBasicPassword());
                        config.setSecuritySession(ContinuumXmlRpcServlet.this.securitySystem.authenticate((AuthenticationDataSource)authdatasource));
                        return config.getSecuritySession().isAuthenticated();
                    }
                    catch (AuthenticationException e) {
                        e.printStackTrace();
                        return false;
                    }
                    catch (AccountLockedException e) {
                        e.printStackTrace();
                        return false;
                    }
                    catch (UserNotFoundException e) {
                        e.printStackTrace();
                        return false;
                    }
                }
                System.out.println("unknown xml rpc configiration object found...");
                return false;
            }
        };
        return handler;
    }

    public void doPost(HttpServletRequest pRequest, HttpServletResponse pResponse) throws IOException, ServletException {
        this.server.execute(pRequest, pResponse);
    }

    private void ensureContainerSet(ServletConfig sc) throws ServletException {
        ServletContext context = sc.getServletContext();
        PlexusContainer xworkContainer = (PlexusContainer)context.getAttribute("webwork.plexus.container");
        if (xworkContainer != null) {
            context.setAttribute("plexus", (Object)xworkContainer);
            return;
        }
        if (context.getAttribute("plexus") != null) {
            context.log("Plexus container already in context.");
            return;
        }
        HashMap keys = new HashMap();
        try {
            DefaultPlexusContainer pc = new DefaultPlexusContainer("default", keys, "META-INF/plexus/application.xml", new ClassWorld("plexus.core", ((Object)((Object)this)).getClass().getClassLoader()));
            context.setAttribute("plexus", (Object)pc);
        }
        catch (PlexusContainerException e) {
            throw new ServletException("Unable to initialize Plexus Container.", (Throwable)e);
        }
    }

    private PlexusContainer getPlexusContainer() throws ServletException {
        PlexusContainer container = (PlexusContainer)this.getServletContext().getAttribute("plexus");
        if (container == null) {
            throw new ServletException("Unable to find plexus container.");
        }
        return container;
    }

    public Object lookup(String role) throws ServletException {
        try {
            return this.getPlexusContainer().lookup(role);
        }
        catch (ComponentLookupException e) {
            throw new ServletException("Unable to lookup role [" + role + "]", (Throwable)e);
        }
    }

    public Object lookup(String role, String hint) throws ServletException {
        try {
            return this.getPlexusContainer().lookup(role, hint);
        }
        catch (ComponentLookupException e) {
            throw new ServletException("Unable to lookup role [" + role + "] hint [" + hint + "]", (Throwable)e);
        }
    }
}

