/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.docrenderer.pdf.itext;

import com.lowagie.text.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.maven.doxia.docrenderer.DocumentRendererContext;
import org.apache.maven.doxia.docrenderer.DocumentRendererException;
import org.apache.maven.doxia.docrenderer.pdf.AbstractPdfRenderer;
import org.apache.maven.doxia.docrenderer.pdf.PdfRenderer;
import org.apache.maven.doxia.document.DocumentCover;
import org.apache.maven.doxia.document.DocumentMeta;
import org.apache.maven.doxia.document.DocumentModel;
import org.apache.maven.doxia.document.DocumentTOCItem;
import org.apache.maven.doxia.module.itext.ITextSink;
import org.apache.maven.doxia.module.itext.ITextSinkFactory;
import org.apache.maven.doxia.module.itext.ITextUtil;
import org.apache.maven.doxia.parser.module.ParserModule;
import org.apache.maven.doxia.sink.Sink;
import org.apache.xml.utils.DefaultErrorHandler;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@Deprecated
@Component(role=PdfRenderer.class, hint="itext")
public class ITextPdfRenderer
extends AbstractPdfRenderer {
    private static final String XSLT_RESOURCE = "TOC.xslt";
    private static final TransformerFactory TRANSFORMER_FACTORY = TransformerFactory.newInstance();
    private static final DocumentBuilderFactory DOCUMENT_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();
    private static final DocumentBuilder DOCUMENT_BUILDER;

    @Override
    public void generatePdf(File inputFile, File pdfFile) throws DocumentRendererException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Generating : " + pdfFile);
        }
        try {
            ITextUtil.writePdf((InputStream)new FileInputStream(inputFile), (OutputStream)new FileOutputStream(pdfFile));
        }
        catch (IOException e) {
            throw new DocumentRendererException("Cannot create PDF from " + inputFile + ": " + e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new DocumentRendererException("Error creating PDF from " + inputFile + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void render(Map<String, ParserModule> filesToProcess, File outputDirectory, DocumentModel documentModel) throws DocumentRendererException, IOException {
        this.render(filesToProcess, outputDirectory, documentModel, null);
    }

    @Override
    public void render(Map<String, ParserModule> filesToProcess, File outputDirectory, DocumentModel documentModel, DocumentRendererContext context) throws DocumentRendererException, IOException {
        List<File> iTextFiles;
        File pdfOutputFile;
        this.copyResources(outputDirectory);
        if (documentModel == null) {
            this.getLogger().debug("No document model, generating all documents individually.");
            this.renderIndividual(filesToProcess, outputDirectory, context);
            return;
        }
        String outputName = this.getOutputName(documentModel);
        File outputITextFile = new File(outputDirectory, outputName + ".xml");
        if (!outputITextFile.getParentFile().exists()) {
            outputITextFile.getParentFile().mkdirs();
        }
        if (!(pdfOutputFile = new File(outputDirectory, outputName + ".pdf")).getParentFile().exists()) {
            pdfOutputFile.getParentFile().mkdirs();
        }
        if (documentModel.getToc() == null || documentModel.getToc().getItems() == null) {
            this.getLogger().info("No TOC is defined in the document descriptor. Merging all documents.");
            iTextFiles = this.parseAllFiles(filesToProcess, outputDirectory, context);
        } else {
            this.getLogger().debug("Using TOC defined in the document descriptor.");
            iTextFiles = this.parseTOCFiles(outputDirectory, documentModel, context);
        }
        String generateTOC = context != null && context.get("generateTOC") != null ? context.get("generateTOC").toString() : "start";
        File iTextFile = new File(outputDirectory, outputName + ".xml");
        File iTextOutput = new File(outputDirectory, outputName + "." + this.getOutputExtension());
        Document document = this.generateDocument(iTextFiles);
        this.transform(documentModel, document, iTextFile, generateTOC);
        this.generatePdf(iTextFile, iTextOutput);
    }

    @Override
    public void renderIndividual(Map<String, ParserModule> filesToProcess, File outputDirectory) throws DocumentRendererException, IOException {
        this.renderIndividual(filesToProcess, outputDirectory, null);
    }

    @Override
    public void renderIndividual(Map<String, ParserModule> filesToProcess, File outputDirectory, DocumentRendererContext context) throws DocumentRendererException, IOException {
        for (Map.Entry<String, ParserModule> entry : filesToProcess.entrySet()) {
            File pdfOutputFile;
            String key = entry.getKey();
            ParserModule module = entry.getValue();
            File fullDoc = new File(this.getBaseDir(), module.getSourceDirectory() + File.separator + key);
            String output = key;
            for (String extension : module.getExtensions()) {
                String lowerCaseExtension = extension.toLowerCase(Locale.ENGLISH);
                if (output.toLowerCase(Locale.ENGLISH).indexOf("." + lowerCaseExtension) == -1) continue;
                output = output.substring(0, output.toLowerCase(Locale.ENGLISH).indexOf("." + lowerCaseExtension));
            }
            File outputITextFile = new File(outputDirectory, output + ".xml");
            if (!outputITextFile.getParentFile().exists()) {
                outputITextFile.getParentFile().mkdirs();
            }
            if (!(pdfOutputFile = new File(outputDirectory, output + ".pdf")).getParentFile().exists()) {
                pdfOutputFile.getParentFile().mkdirs();
            }
            this.parse(fullDoc, module, outputITextFile, context);
            this.generatePdf(outputITextFile, pdfOutputFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(File fullDoc, ParserModule module, File iTextFile, DocumentRendererContext context) throws DocumentRendererException, IOException {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Parsing file " + fullDoc.getAbsolutePath());
        }
        System.setProperty("itext.basedir", iTextFile.getParentFile().getAbsolutePath());
        XmlStreamWriter writer = null;
        ITextSink sink = null;
        try {
            writer = WriterFactory.newXmlWriter((File)iTextFile);
            sink = (ITextSink)new ITextSinkFactory().createSink((Writer)writer);
            sink.setClassLoader((ClassLoader)new URLClassLoader(new URL[]{iTextFile.getParentFile().toURI().toURL()}));
            this.parse(fullDoc.getAbsolutePath(), module.getParserId(), (Sink)sink, context);
        }
        finally {
            if (sink != null) {
                sink.flush();
                sink.close();
            }
            IOUtil.close((Writer)writer);
            System.getProperties().remove("itext.basedir");
        }
    }

    private Document generateDocument(List<File> iTextFiles) throws DocumentRendererException, IOException {
        Document document = DOCUMENT_BUILDER.newDocument();
        document.appendChild(document.createElement("itext"));
        for (File iTextFile : iTextFiles) {
            Document iTextDocument;
            try {
                iTextDocument = DOCUMENT_BUILDER.parse(iTextFile);
            }
            catch (SAXException e) {
                throw new DocumentRendererException("SAX Error : " + e.getMessage());
            }
            Node chapter = iTextDocument.getElementsByTagName("chapter").item(0);
            try {
                document.getDocumentElement().appendChild(document.importNode(chapter, true));
            }
            catch (DOMException e) {
                throw new DocumentRendererException("Error appending chapter for " + iTextFile + " : " + e.getMessage());
            }
        }
        return document;
    }

    private Transformer initTransformer() throws DocumentRendererException {
        try {
            Transformer transformer = TRANSFORMER_FACTORY.newTransformer(new StreamSource(ITextPdfRenderer.class.getResourceAsStream(XSLT_RESOURCE)));
            transformer.setErrorListener(TRANSFORMER_FACTORY.getErrorListener());
            transformer.setOutputProperty("omit-xml-declaration", "false");
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            return transformer;
        }
        catch (TransformerConfigurationException e) {
            throw new DocumentRendererException("Error configuring Transformer for TOC.xslt: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new DocumentRendererException("Error configuring Transformer for TOC.xslt: " + e.getMessage());
        }
    }

    private void addTransformerParameters(Transformer transformer, DocumentModel documentModel, File iTextFile, String generateTOC) {
        if (documentModel == null) {
            return;
        }
        this.addTransformerParameter(transformer, "toc.position", generateTOC);
        boolean hasNullMeta = false;
        if (documentModel.getMeta() == null) {
            hasNullMeta = true;
            documentModel.setMeta(new DocumentMeta());
        }
        this.addTransformerParameter(transformer, "meta.author", documentModel.getMeta().getAllAuthorNames(), System.getProperty("user.name", "null"));
        this.addTransformerParameter(transformer, "meta.creator", documentModel.getMeta().getCreator(), System.getProperty("user.name", "null"));
        SimpleDateFormat sdf = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        this.addTransformerParameter(transformer, "meta.creationdate", documentModel.getMeta().getCreationdate(), sdf.format(new Date()));
        this.addTransformerParameter(transformer, "meta.keywords", documentModel.getMeta().getAllKeyWords());
        this.addTransformerParameter(transformer, "meta.pagesize", documentModel.getMeta().getPageSize(), ITextUtil.getPageSize((Rectangle)ITextUtil.getDefaultPageSize()));
        this.addTransformerParameter(transformer, "meta.producer", documentModel.getMeta().getGenerator(), "Apache Doxia iText");
        this.addTransformerParameter(transformer, "meta.subject", documentModel.getMeta().getSubject(), documentModel.getMeta().getTitle() != null ? documentModel.getMeta().getTitle() : "");
        this.addTransformerParameter(transformer, "meta.title", documentModel.getMeta().getTitle());
        if (hasNullMeta) {
            documentModel.setMeta(null);
        }
        boolean hasNullCover = false;
        if (documentModel.getCover() == null) {
            hasNullCover = true;
            documentModel.setCover(new DocumentCover());
        }
        this.addTransformerParameter(transformer, "cover.author", documentModel.getCover().getAllAuthorNames(), System.getProperty("user.name", "null"));
        String companyLogo = this.getLogoURL(documentModel.getCover().getCompanyLogo(), iTextFile.getParentFile());
        this.addTransformerParameter(transformer, "cover.companyLogo", companyLogo);
        this.addTransformerParameter(transformer, "cover.companyName", documentModel.getCover().getCompanyName());
        if (documentModel.getCover().getCoverdate() == null) {
            documentModel.getCover().setCoverDate(new Date());
            this.addTransformerParameter(transformer, "cover.date", documentModel.getCover().getCoverdate());
            documentModel.getCover().setCoverDate(null);
        } else {
            this.addTransformerParameter(transformer, "cover.date", documentModel.getCover().getCoverdate());
        }
        this.addTransformerParameter(transformer, "cover.subtitle", documentModel.getCover().getCoverSubTitle());
        this.addTransformerParameter(transformer, "cover.title", documentModel.getCover().getCoverTitle());
        this.addTransformerParameter(transformer, "cover.type", documentModel.getCover().getCoverType());
        this.addTransformerParameter(transformer, "cover.version", documentModel.getCover().getCoverVersion());
        String projectLogo = this.getLogoURL(documentModel.getCover().getProjectLogo(), iTextFile.getParentFile());
        this.addTransformerParameter(transformer, "cover.projectLogo", projectLogo);
        this.addTransformerParameter(transformer, "cover.projectName", documentModel.getCover().getProjectName());
        if (hasNullCover) {
            documentModel.setCover(null);
        }
    }

    private void addTransformerParameter(Transformer transformer, String name, String value, String defaultValue) {
        if (StringUtils.isEmpty((String)value)) {
            this.addTransformerParameter(transformer, name, defaultValue);
        } else {
            this.addTransformerParameter(transformer, name, value);
        }
    }

    private void addTransformerParameter(Transformer transformer, String name, String value) {
        if (StringUtils.isEmpty((String)value)) {
            return;
        }
        transformer.setParameter(name, value);
    }

    private void transform(DocumentModel documentModel, Document document, File iTextFile, String generateTOC) throws DocumentRendererException {
        Transformer transformer = this.initTransformer();
        this.addTransformerParameters(transformer, documentModel, iTextFile, generateTOC);
        XmlStreamWriter writer = null;
        try {
            writer = WriterFactory.newXmlWriter((File)iTextFile);
            transformer.transform(new DOMSource(document), new StreamResult((Writer)writer));
        }
        catch (TransformerException e) {
            throw new DocumentRendererException("Error transforming Document " + document + ": " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new DocumentRendererException("Error transforming Document " + document + ": " + e.getMessage(), e);
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    private List<File> parseAllFiles(Map<String, ParserModule> filesToProcess, File outputDirectory, DocumentRendererContext context) throws DocumentRendererException, IOException {
        LinkedList<File> iTextFiles = new LinkedList<File>();
        for (Map.Entry<String, ParserModule> entry : filesToProcess.entrySet()) {
            String key = entry.getKey();
            ParserModule module = entry.getValue();
            File fullDoc = new File(this.getBaseDir(), module.getSourceDirectory() + File.separator + key);
            String outputITextName = key.substring(0, key.lastIndexOf(46) + 1) + "xml";
            File outputITextFileTmp = new File(outputDirectory, outputITextName);
            outputITextFileTmp.deleteOnExit();
            if (!outputITextFileTmp.getParentFile().exists()) {
                outputITextFileTmp.getParentFile().mkdirs();
            }
            iTextFiles.add(outputITextFileTmp);
            this.parse(fullDoc, module, outputITextFileTmp, context);
        }
        return iTextFiles;
    }

    private List<File> parseTOCFiles(File outputDirectory, DocumentModel documentModel, DocumentRendererContext context) throws DocumentRendererException, IOException {
        LinkedList<File> iTextFiles = new LinkedList<File>();
        for (DocumentTOCItem tocItem : documentModel.getToc().getItems()) {
            if (tocItem.getRef() == null) {
                this.getLogger().debug("No ref defined for the tocItem '" + tocItem.getName() + "' in the document descriptor. IGNORING");
                continue;
            }
            String href = StringUtils.replace((String)tocItem.getRef(), (String)"\\", (String)"/");
            if (href.lastIndexOf(46) != -1) {
                href = href.substring(0, href.lastIndexOf(46));
            }
            Collection modules = this.parserModuleManager.getParserModules();
            for (ParserModule module : modules) {
                File moduleBasedir = new File(this.getBaseDir(), module.getSourceDirectory());
                if (!moduleBasedir.exists()) continue;
                for (String extension : module.getExtensions()) {
                    String doc = href + "." + extension;
                    File source = new File(moduleBasedir, doc);
                    if (!source.exists()) {
                        doc = href.indexOf("." + extension) != -1 ? href + ".vm" : href + "." + extension + ".vm";
                        source = new File(moduleBasedir, doc);
                    }
                    if (!source.exists()) continue;
                    String outputITextName = doc.substring(0, doc.lastIndexOf(46) + 1) + "xml";
                    File outputITextFileTmp = new File(outputDirectory, outputITextName);
                    outputITextFileTmp.deleteOnExit();
                    if (!outputITextFileTmp.getParentFile().exists()) {
                        outputITextFileTmp.getParentFile().mkdirs();
                    }
                    iTextFiles.add(outputITextFileTmp);
                    this.parse(source, module, outputITextFileTmp, context);
                }
            }
        }
        return iTextFiles;
    }

    private String getLogoURL(String logo, File parentFile) {
        if (logo == null) {
            return null;
        }
        try {
            return new URL(logo).toString();
        }
        catch (MalformedURLException e) {
            try {
                File f = new File(parentFile, logo);
                if (f.exists()) {
                    return f.toURI().toURL().toString();
                }
                this.getLogger().warn("The logo " + f.getAbsolutePath() + " doesnt exist. IGNORING");
            }
            catch (MalformedURLException e1) {
                this.getLogger().debug("Failed to convert to URL: " + logo, (Throwable)e1);
            }
            return null;
        }
    }

    static {
        TRANSFORMER_FACTORY.setErrorListener((ErrorListener)new DefaultErrorHandler());
        try {
            DOCUMENT_BUILDER = DOCUMENT_BUILDER_FACTORY.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Error building document :" + e.getMessage());
        }
    }
}

