/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.docbook;

import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DocBookParser
implements Parser {
    private int level = 0;
    private Stack parent = new Stack();
    private Collection failedElements = new HashSet();
    private static final Collection hierElements = new HashSet();
    private static final Collection verbatimElements = new HashSet();
    private static final Collection boldElements = new HashSet();
    private static final Collection italicElements = new HashSet();
    private static final Collection monospaceElements = new HashSet();

    public void parse(Reader reader, Sink sink) throws ParseException {
        try {
            MXParser parser = new MXParser();
            parser.setInput(reader);
            this.parseDocBook((XmlPullParser)parser, sink);
        }
        catch (XmlPullParserException e) {
            throw new ParseException("Error parsing the model.", (Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ParseException("Error parsing the model.", (Exception)e);
        }
    }

    public void parseDocBook(XmlPullParser parser, Sink sink) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        while (eventType != 1) {
            if (eventType == 2) {
                String id = this.getAttributeValue(parser, "id");
                if (id != null) {
                    sink.anchor(id);
                }
                if (hierElements.contains(parser.getName())) {
                    ++this.level;
                    if (this.level == 1) {
                        sink.body();
                    } else if (this.level == 2) {
                        sink.section1();
                    } else if (this.level == 3) {
                        sink.section2();
                    } else if (this.level == 4) {
                        sink.section3();
                    } else if (this.level == 5) {
                        sink.section4();
                    } else if (this.level == 6) {
                        sink.section5();
                    }
                } else if (parser.getName().endsWith("info") && this.level == 1) {
                    sink.head();
                    this.parent.push(parser.getName());
                } else if (parser.getName().equals("itemizedlist")) {
                    sink.list();
                    this.parent.push(parser.getName());
                } else if (parser.getName().equals("orderedlist")) {
                    int numeration = 0;
                    String style = this.getAttributeValue(parser, "numeration");
                    if (style.equals("arabic")) {
                        numeration = 0;
                    } else if (style.equals("loweralpha")) {
                        numeration = 1;
                    } else if (style.equals("lowerroman")) {
                        numeration = 3;
                    } else if (style.equals("upperalpha")) {
                        numeration = 2;
                    } else if (style.equals("upperroman")) {
                        numeration = 4;
                    }
                    sink.numberedList(numeration);
                    this.parent.push(parser.getName());
                } else if (parser.getName().equals("listitem")) {
                    if (this.isParent("variablelist")) {
                        sink.definition();
                    } else {
                        sink.listItem();
                    }
                } else if (parser.getName().equals("variablelist")) {
                    sink.definitionList();
                    this.parent.push(parser.getName());
                } else if (parser.getName().equals("varlistentry")) {
                    sink.definitionListItem();
                } else if (parser.getName().equals("term")) {
                    sink.definedTerm();
                } else if (parser.getName().equals("figure") || parser.getName().equals("informalfigure")) {
                    sink.figure();
                    this.parent.push(parser.getName());
                } else if (parser.getName().equals("imageobject")) {
                    String fileref = this.getAttributeValue(parser, "fileref");
                    if (fileref != null) {
                        sink.figureGraphics(fileref);
                        this.parent.push(parser.getName());
                    }
                } else if (parser.getName().equals("caption") && this.isParent("figure")) {
                    sink.figureCaption();
                } else if (parser.getName().equals("table") || parser.getName().equals("informaltable")) {
                    sink.table();
                    this.parent.push(parser.getName());
                } else if (parser.getName().equals("thead")) {
                    this.parent.push(parser.getName());
                } else if (parser.getName().equals("tr") || parser.getName().equals("row")) {
                    sink.tableRow();
                } else if (parser.getName().equals("entry") && this.isParent("thead") || parser.getName().equals("th")) {
                    sink.tableHeaderCell();
                } else if (parser.getName().equals("entry")) {
                    sink.tableCell();
                } else if (parser.getName().equals("caption") && (this.isParent("informaltable") || this.isParent("table"))) {
                    sink.tableCaption();
                } else if ((parser.getName().equals("para") || parser.getName().equals("simpara")) && !this.isParent("formalpara")) {
                    sink.paragraph();
                } else if (parser.getName().equals("formalpara")) {
                    this.parent.push(parser.getName());
                    sink.paragraph();
                } else if (parser.getName().equals("title") && this.isParent("formalpara")) {
                    sink.bold();
                } else if (verbatimElements.contains(parser.getName())) {
                    sink.verbatim(true);
                } else if (boldElements.contains(parser.getName()) && monospaceElements.contains(parser.getName())) {
                    sink.bold();
                    sink.monospaced();
                } else if (italicElements.contains(parser.getName()) && monospaceElements.contains(parser.getName())) {
                    sink.italic();
                    sink.monospaced();
                } else if (boldElements.contains(parser.getName())) {
                    sink.bold();
                } else if (italicElements.contains(parser.getName())) {
                    sink.italic();
                } else if (monospaceElements.contains(parser.getName())) {
                    sink.monospaced();
                } else if (parser.getName().equals("title")) {
                    if (parser.getName().equals("figure") || parser.getName().equals("informalfigure")) {
                        sink.figureCaption();
                    } else if (parser.getName().equals("table") || parser.getName().equals("informaltable")) {
                        sink.tableCaption();
                    } else if (this.level == 1) {
                        sink.title();
                    } else if (this.level == 2) {
                        sink.sectionTitle1();
                    } else if (this.level == 3) {
                        sink.sectionTitle2();
                    } else if (this.level == 4) {
                        sink.sectionTitle3();
                    } else if (this.level == 5) {
                        sink.sectionTitle4();
                    } else if (this.level == 6) {
                        sink.sectionTitle5();
                    }
                } else if (parser.getName().equals("ulink")) {
                    String url = this.getAttributeValue(parser, "url");
                    if (url != null) {
                        this.parent.push(parser.getName());
                        sink.link(url);
                    }
                } else if (parser.getName().equals("email")) {
                    sink.link("mailto:" + parser.nextText());
                    sink.link_();
                } else if (parser.getName().equals("link")) {
                    String linkend = this.getAttributeValue(parser, "linkend");
                    if (linkend != null) {
                        this.parent.push(parser.getName());
                        sink.link("#" + linkend);
                    }
                } else if (parser.getName().equals("xref")) {
                    String linkend = this.getAttributeValue(parser, "linkend");
                    if (linkend != null) {
                        sink.link("#" + linkend);
                        sink.text("Link");
                        sink.link_();
                    }
                } else {
                    this.failedElements.add(parser.getName());
                }
            } else if (eventType == 3) {
                if (hierElements.contains(parser.getName())) {
                    --this.level;
                    if (this.level == 1) {
                        sink.body_();
                    } else if (this.level == 2) {
                        sink.section1_();
                    } else if (this.level == 3) {
                        sink.section2_();
                    } else if (this.level == 4) {
                        sink.section3_();
                    } else if (this.level == 5) {
                        sink.section4_();
                    } else if (this.level == 6) {
                        sink.section5_();
                    }
                } else if (parser.getName().endsWith("info") && this.level == 1) {
                    sink.head_();
                    this.parent.pop();
                } else if (parser.getName().equals("itemizedlist")) {
                    sink.list_();
                    this.parent.pop();
                } else if (parser.getName().equals("orderedlist")) {
                    sink.numberedList_();
                    this.parent.pop();
                } else if (parser.getName().equals("listitem")) {
                    if (this.isParent("variablelist")) {
                        sink.definition_();
                    } else {
                        sink.listItem_();
                    }
                } else if (parser.getName().equals("variablelist")) {
                    sink.definitionList_();
                } else if (parser.getName().equals("varlistentry")) {
                    sink.definitionListItem_();
                } else if (parser.getName().equals("term")) {
                    sink.definedTerm_();
                } else if (parser.getName().equals("figure") || parser.getName().equals("informalfigure")) {
                    sink.figure_();
                    this.parent.pop();
                } else if (parser.getName().equals("caption") && this.isParent("figure")) {
                    sink.figureCaption_();
                } else if (parser.getName().equals("table") || parser.getName().equals("informaltable")) {
                    sink.table_();
                    this.parent.pop();
                } else if (parser.getName().equals("thead")) {
                    this.parent.pop();
                } else if (parser.getName().equals("tr") || parser.getName().equals("row")) {
                    sink.tableRow_();
                } else if (parser.getName().equals("entry") && this.isParent("thead") || parser.getName().equals("th")) {
                    sink.tableHeaderCell_();
                } else if (parser.getName().equals("entry")) {
                    sink.tableCell_();
                } else if (parser.getName().equals("caption") && (this.isParent("informaltable") || this.isParent("table"))) {
                    sink.tableCaption_();
                } else if ((parser.getName().equals("para") || parser.getName().equals("simpara")) && !this.isParent("formalpara")) {
                    sink.paragraph_();
                } else if (parser.getName().equals("formalpara")) {
                    this.parent.pop();
                    sink.paragraph_();
                } else if (parser.getName().equals("title") && this.isParent("formalpara")) {
                    sink.text(". ");
                    sink.bold_();
                } else if (verbatimElements.contains(parser.getName())) {
                    sink.verbatim_();
                } else if (boldElements.contains(parser.getName()) && monospaceElements.contains(parser.getName())) {
                    sink.bold_();
                    sink.monospaced_();
                } else if (italicElements.contains(parser.getName()) && monospaceElements.contains(parser.getName())) {
                    sink.italic_();
                    sink.monospaced_();
                } else if (boldElements.contains(parser.getName())) {
                    sink.bold_();
                } else if (italicElements.contains(parser.getName())) {
                    sink.italic_();
                } else if (monospaceElements.contains(parser.getName())) {
                    sink.monospaced_();
                } else if (parser.getName().equals("title")) {
                    if (parser.getName().equals("figure") || parser.getName().equals("informalfigure")) {
                        sink.figureCaption_();
                    } else if (parser.getName().equals("table") || parser.getName().equals("informaltable")) {
                        sink.tableCaption_();
                    } else if (this.level == 1) {
                        sink.title_();
                    } else if (this.level == 2) {
                        sink.sectionTitle1_();
                    } else if (this.level == 3) {
                        sink.sectionTitle2_();
                    } else if (this.level == 4) {
                        sink.sectionTitle3_();
                    } else if (this.level == 5) {
                        sink.sectionTitle4_();
                    } else if (this.level == 6) {
                        sink.sectionTitle5_();
                    }
                } else if ((parser.getName().equals("ulink") || parser.getName().equals("link")) && this.isParent(parser.getName())) {
                    this.parent.pop();
                    sink.link_();
                }
            } else if (eventType == 4) {
                sink.text(parser.getText());
            }
            eventType = parser.next();
        }
        if (!this.failedElements.isEmpty()) {
            System.out.println("Doxia was unable to handle following elements");
            Iterator i = this.failedElements.iterator();
            while (i.hasNext()) {
                System.out.print(i.next().toString() + " ");
            }
            System.out.println();
        }
    }

    private String getAttributeValue(XmlPullParser parser, String name) {
        for (int i = 0; i < parser.getAttributeCount(); ++i) {
            if (!parser.getAttributeName(i).equals(name)) continue;
            return parser.getAttributeValue(i);
        }
        return null;
    }

    private boolean isParent(String element) {
        if (this.parent.size() > 0) {
            return this.parent.peek().equals(element);
        }
        return false;
    }

    static {
        hierElements.add("set");
        hierElements.add("book");
        hierElements.add("part");
        hierElements.add("chapter");
        hierElements.add("section");
        hierElements.add("sect1");
        hierElements.add("sect2");
        hierElements.add("sect3");
        hierElements.add("sect4");
        hierElements.add("sect5");
        hierElements.add("article");
        hierElements.add("preface");
        hierElements.add("partintro");
        hierElements.add("appendix");
        hierElements.add("bibliography");
        hierElements.add("reference");
        hierElements.add("bibliography");
        hierElements.add("bibliodiv");
        hierElements.add("glossary");
        hierElements.add("refentry");
        hierElements.add("refnamediv");
        hierElements.add("refsection");
        hierElements.add("refsect1");
        hierElements.add("refsect2");
        hierElements.add("refsect3");
        verbatimElements.add("programlisting");
        verbatimElements.add("screen");
        verbatimElements.add("literallayout");
        verbatimElements.add("synopsis");
        boldElements.add("command");
        boldElements.add("keycap");
        boldElements.add("shortcut");
        boldElements.add("userinput");
        italicElements.add("parameter");
        italicElements.add("replaceable");
        italicElements.add("medialabel");
        italicElements.add("structfield");
        italicElements.add("systemitem");
        italicElements.add("citetitle");
        italicElements.add("emphasis");
        italicElements.add("foreignphrase");
        italicElements.add("wordasword");
        monospaceElements.add("classname");
        monospaceElements.add("exceptionname");
        monospaceElements.add("interfacename");
        monospaceElements.add("methodname");
        monospaceElements.add("computeroutput");
        monospaceElements.add("constant");
        monospaceElements.add("envar");
        monospaceElements.add("function");
        monospaceElements.add("parameter");
        monospaceElements.add("replaceable");
        monospaceElements.add("literal");
        monospaceElements.add("code");
        monospaceElements.add("option");
        monospaceElements.add("prompt");
        monospaceElements.add("structfield");
        monospaceElements.add("systemitem");
        monospaceElements.add("structfield");
        monospaceElements.add("userinput");
        monospaceElements.add("varname");
        monospaceElements.add("sgmltag");
        monospaceElements.add("tag");
        monospaceElements.add("uri");
    }
}

