/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.docbook;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.module.docbook.DocbookMarkup;
import org.apache.maven.doxia.sink.AbstractXmlSink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.FileUtils;

public class DocBookSink
extends AbstractXmlSink
implements DocbookMarkup {
    public static final String DEFAULT_SGML_PUBLIC_ID = "-//OASIS//DTD DocBook V4.4//EN";
    public static final String DEFAULT_XML_PUBLIC_ID = "-//OASIS//DTD DocBook V4.4//EN";
    public static final String DEFAULT_XML_SYSTEM_ID = "http://www.oasis-open.org/docbook/xml/4.4/docbookx.dtd";
    public static final String DEFAULT_SGML_SYSTEM_ID = "http://www.oasis-open.org/docbook/sgml/4.4/docbookx.dtd";
    private PrintWriter out;
    private boolean xmlMode = false;
    private String styleSheet = null;
    private String lang = null;
    private String publicId = null;
    private String systemId = null;
    private String italicBeginTag;
    private String italicEndTag;
    private String boldBeginTag;
    private String boldEndTag;
    private String monospacedBeginTag;
    private String monospacedEndTag;
    private String horizontalRuleElement;
    private String pageBreakElement;
    private String lineBreakElement;
    private String graphicsFileName;
    private boolean hasTitle;
    private boolean authorDateFlag;
    private boolean verbatimFlag;
    private boolean externalLinkFlag;
    private boolean tableHasCaption;
    private PrintWriter savedOut;
    private String tableRows;
    private StringWriter tableRowsWriter;
    private boolean tableHasGrid;
    private boolean skip;
    private String encoding;

    protected DocBookSink(Writer writer) {
        this(writer, null);
    }

    protected DocBookSink(Writer writer, String encoding) {
        this.out = new PrintWriter(writer);
        this.encoding = encoding;
        this.setItalicElement("<emphasis>");
        this.setBoldElement("<emphasis role=\"bold\">");
        this.setMonospacedElement("<literal>");
        this.setHorizontalRuleElement("<!-- HR -->");
        this.setPageBreakElement("<!-- PB -->");
        this.setLineBreakElement("<!-- LB -->");
    }

    protected DocBookSink(Writer writer, String encoding, String languageId) {
        this(writer, encoding);
        this.lang = languageId;
    }

    public static final String escapeSGML(String text, boolean xmlMode) {
        int length = text.length();
        StringBuffer buffer = new StringBuffer(length);
        block6: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    buffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block6;
                }
                default: {
                    if (xmlMode) {
                        buffer.append(c);
                        continue block6;
                    }
                    if (c <= '~') {
                        buffer.append(c);
                        continue block6;
                    }
                    buffer.append("&#");
                    buffer.append((int)c);
                    buffer.append(';');
                }
            }
        }
        return buffer.toString();
    }

    public void setXMLMode(boolean mode) {
        this.xmlMode = mode;
    }

    public boolean isXMLMode() {
        return this.xmlMode;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setStyleSheet(String sheet) {
        this.styleSheet = sheet;
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public void setPublicId(String id) {
        this.publicId = id;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setSystemId(String id) {
        this.systemId = id;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setLanguage(String language) {
        this.lang = language;
    }

    public String getLanguage() {
        return this.lang;
    }

    public void setItalicElement(String tag) {
        if (tag == null) {
            tag = "";
        }
        this.italicBeginTag = tag;
        this.italicEndTag = this.makeEndTag(this.italicBeginTag);
    }

    private String makeEndTag(String beginTag) {
        int length = beginTag.length();
        if (length == 0) {
            return "";
        }
        if (beginTag.charAt(0) != '<' || beginTag.charAt(length - 1) != '>') {
            throw new IllegalArgumentException("'" + beginTag + "', not a tag");
        }
        StringTokenizer tokens = new StringTokenizer(beginTag, "<> \t\n\r\f");
        if (!tokens.hasMoreTokens()) {
            throw new IllegalArgumentException("'" + beginTag + "', invalid tag");
        }
        return "</" + tokens.nextToken() + ">";
    }

    public String getItalicElement() {
        return this.italicBeginTag;
    }

    public void setBoldElement(String tag) {
        if (tag == null) {
            tag = "";
        }
        this.boldBeginTag = tag;
        this.boldEndTag = this.makeEndTag(this.boldBeginTag);
    }

    public String getBoldElement() {
        return this.boldBeginTag;
    }

    public void setMonospacedElement(String tag) {
        if (tag == null) {
            tag = "";
        }
        this.monospacedBeginTag = tag;
        this.monospacedEndTag = this.makeEndTag(this.monospacedBeginTag);
    }

    public String getMonospacedElement() {
        return this.monospacedBeginTag;
    }

    public void setHorizontalRuleElement(String element) {
        this.horizontalRuleElement = element;
    }

    public String getHorizontalRuleElement() {
        return this.horizontalRuleElement;
    }

    public void setPageBreakElement(String element) {
        this.pageBreakElement = element;
    }

    public String getPageBreakElement() {
        return this.pageBreakElement;
    }

    public void setLineBreakElement(String element) {
        this.lineBreakElement = element;
    }

    public String getLineBreakElement() {
        return this.lineBreakElement;
    }

    protected void resetState() {
        this.hasTitle = false;
        this.authorDateFlag = false;
        this.verbatimFlag = false;
        this.externalLinkFlag = false;
        this.graphicsFileName = null;
        this.tableHasCaption = false;
        this.savedOut = null;
        this.tableRows = null;
        this.tableHasGrid = false;
    }

    public void head() {
        this.resetState();
        MutableAttributeSet att = this.writeXmlHeader("article");
        this.writeStartTag(ARTICLE_TAG, att);
    }

    protected MutableAttributeSet writeXmlHeader(String root) {
        if (this.xmlMode) {
            this.markup("<?xml version=\"1.0\"");
            if (this.encoding != null) {
                this.markup(" encoding=\"" + this.encoding + "\"");
            }
            this.markup("?>");
            if (this.styleSheet != null) {
                this.markup("<?xml-stylesheet type=\"text/css\" href=\"" + this.styleSheet + "\" ?>");
            }
        }
        this.markup("<!DOCTYPE " + root + " PUBLIC");
        String pubId = this.publicId == null ? (this.xmlMode ? "-//OASIS//DTD DocBook V4.4//EN" : "-//OASIS//DTD DocBook V4.4//EN") : this.publicId;
        this.markup(" \"" + pubId + "\"");
        String sysId = this.systemId;
        if (sysId == null) {
            sysId = this.xmlMode ? DEFAULT_XML_SYSTEM_ID : DEFAULT_SGML_SYSTEM_ID;
        }
        this.markup(" \"" + sysId + "\">");
        SimpleAttributeSet att = new SimpleAttributeSet();
        if (this.lang != null) {
            att.addAttribute(HTML.Attribute.LANG.toString(), this.lang);
        }
        return att;
    }

    public void head_() {
        if (this.hasTitle) {
            this.writeEndTag(ARTICLEINFO_TAG);
            this.hasTitle = false;
        }
    }

    public void title() {
        this.writeStartTag(ARTICLEINFO_TAG);
        this.writeStartTag(HTML.Tag.TITLE);
        this.hasTitle = true;
    }

    public void title_() {
        this.writeEndTag(HTML.Tag.TITLE);
    }

    public void author() {
        this.authorDateFlag = true;
        this.writeStartTag(CORPAUTHOR_TAG);
    }

    public void author_() {
        this.writeEndTag(CORPAUTHOR_TAG);
        this.authorDateFlag = false;
    }

    public void date() {
        this.authorDateFlag = true;
        this.writeStartTag(DATE_TAG);
    }

    public void date_() {
        this.writeEndTag(DATE_TAG);
        this.authorDateFlag = false;
    }

    public void body_() {
        this.writeEndTag(ARTICLE_TAG);
        this.out.flush();
        this.resetState();
    }

    public void section1() {
        this.writeStartTag(SECTION_TAG);
    }

    public void section1_() {
        this.writeEndTag(SECTION_TAG);
    }

    public void section2() {
        this.writeStartTag(SECTION_TAG);
    }

    public void section2_() {
        this.writeEndTag(SECTION_TAG);
    }

    public void section3() {
        this.writeStartTag(SECTION_TAG);
    }

    public void section3_() {
        this.writeEndTag(SECTION_TAG);
    }

    public void section4() {
        this.writeStartTag(SECTION_TAG);
    }

    public void section4_() {
        this.writeEndTag(SECTION_TAG);
    }

    public void section5() {
        this.writeStartTag(SECTION_TAG);
    }

    public void section5_() {
        this.writeEndTag(SECTION_TAG);
    }

    public void sectionTitle() {
        this.writeStartTag(HTML.Tag.TITLE);
    }

    public void sectionTitle_() {
        this.writeEndTag(HTML.Tag.TITLE);
    }

    public void sectionTitle1() {
        this.writeStartTag(HTML.Tag.TITLE);
    }

    public void sectionTitle1_() {
        this.writeEndTag(HTML.Tag.TITLE);
    }

    public void sectionTitle2() {
        this.writeStartTag(HTML.Tag.TITLE);
    }

    public void sectionTitle2_() {
        this.writeEndTag(HTML.Tag.TITLE);
    }

    public void sectionTitle3() {
        this.writeStartTag(HTML.Tag.TITLE);
    }

    public void sectionTitle3_() {
        this.writeEndTag(HTML.Tag.TITLE);
    }

    public void sectionTitle4() {
        this.writeStartTag(HTML.Tag.TITLE);
    }

    public void sectionTitle4_() {
        this.writeEndTag(HTML.Tag.TITLE);
    }

    public void sectionTitle5() {
        this.writeStartTag(HTML.Tag.TITLE);
    }

    public void sectionTitle5_() {
        this.writeEndTag(HTML.Tag.TITLE);
    }

    public void list() {
        this.writeStartTag(ITEMIZEDLIST_TAG);
    }

    public void list_() {
        this.writeEndTag(ITEMIZEDLIST_TAG);
    }

    public void listItem() {
        this.writeStartTag(LISTITEM_TAG);
    }

    public void listItem_() {
        this.writeEndTag(LISTITEM_TAG);
    }

    public void numberedList(int numbering) {
        String numeration;
        switch (numbering) {
            case 2: {
                numeration = "upperalpha";
                break;
            }
            case 1: {
                numeration = "loweralpha";
                break;
            }
            case 4: {
                numeration = "upperroman";
                break;
            }
            case 3: {
                numeration = "lowerroman";
                break;
            }
            default: {
                numeration = "arabic";
            }
        }
        SimpleAttributeSet att = new SimpleAttributeSet();
        att.addAttribute("numeration", numeration);
        this.writeStartTag(ORDEREDLIST_TAG, att);
    }

    public void numberedList_() {
        this.writeEndTag(ORDEREDLIST_TAG);
    }

    public void numberedListItem() {
        this.writeStartTag(LISTITEM_TAG);
    }

    public void numberedListItem_() {
        this.writeEndTag(LISTITEM_TAG);
    }

    public void definitionList() {
        this.writeStartTag(VARIABLELIST_TAG);
    }

    public void definitionList_() {
        this.writeEndTag(VARIABLELIST_TAG);
    }

    public void definitionListItem() {
        this.writeStartTag(VARLISTENTRY_TAG);
    }

    public void definitionListItem_() {
        this.writeEndTag(VARLISTENTRY_TAG);
    }

    public void definedTerm() {
        this.writeStartTag(TERM_TAG);
    }

    public void definedTerm_() {
        this.writeEndTag(TERM_TAG);
    }

    public void definition() {
        this.writeStartTag(LISTITEM_TAG);
    }

    public void definition_() {
        this.writeEndTag(LISTITEM_TAG);
    }

    public void paragraph() {
        this.writeStartTag(PARA_TAG);
    }

    public void paragraph_() {
        this.writeEndTag(PARA_TAG);
    }

    public void verbatim(boolean boxed) {
        this.verbatimFlag = true;
        this.writeStartTag(PROGRAMLISTING_TAG);
    }

    public void verbatim_() {
        this.writeEndTag(PROGRAMLISTING_TAG);
        this.verbatimFlag = false;
    }

    public void horizontalRule() {
        this.markup(this.horizontalRuleElement);
    }

    public void pageBreak() {
        this.markup(this.pageBreakElement);
    }

    public void figure_() {
        this.graphicElement();
    }

    protected void graphicElement() {
        if (this.graphicsFileName != null) {
            String format = FileUtils.extension((String)this.graphicsFileName).toUpperCase(Locale.ENGLISH);
            if (format.length() == 0) {
                format = "JPEG";
            }
            this.writeStartTag(MEDIAOBJECT_TAG);
            this.writeStartTag(IMAGEOBJECT_TAG);
            SimpleAttributeSet att = new SimpleAttributeSet();
            att.addAttribute("format", format);
            att.addAttribute("fileref", DocBookSink.escapeSGML(this.graphicsFileName, this.xmlMode));
            if (this.xmlMode) {
                this.writeSimpleTag(IMAGEDATA_TAG, att);
            } else {
                this.writeStartTag(IMAGEDATA_TAG, att);
                this.writeEndTag(IMAGEDATA_TAG);
            }
            this.writeEndTag(IMAGEOBJECT_TAG);
            this.writeEndTag(MEDIAOBJECT_TAG);
            this.graphicsFileName = null;
        }
    }

    public void figureGraphics(String name) {
        this.graphicsFileName = name + ".jpeg";
    }

    public void figureCaption() {
        this.writeStartTag(FIGURE_TAG);
        this.writeStartTag(HTML.Tag.TITLE);
    }

    public void figureCaption_() {
        this.writeEndTag(HTML.Tag.TITLE);
        this.graphicElement();
        this.writeEndTag(FIGURE_TAG);
    }

    public void table() {
        this.tableHasCaption = false;
    }

    public void table_() {
        if (this.tableHasCaption) {
            this.tableHasCaption = false;
            this.out.write(this.tableRows);
            this.writeEndTag(HTML.Tag.TABLE);
        } else {
            int sep;
            String frame;
            if (this.tableHasGrid) {
                frame = "all";
                sep = 1;
            } else {
                frame = "none";
                sep = 0;
            }
            SimpleAttributeSet att = new SimpleAttributeSet();
            att.addAttribute("frame", frame);
            att.addAttribute("rowsep", String.valueOf(sep));
            att.addAttribute("colsep", String.valueOf(sep));
            this.writeStartTag(INFORMALTABLE_TAG, att);
            this.out.write(this.tableRows);
            this.writeEndTag(INFORMALTABLE_TAG);
        }
        this.tableRows = null;
        this.tableHasGrid = false;
    }

    public void tableRows(int[] justification, boolean grid) {
        this.tableHasGrid = grid;
        this.out.flush();
        this.savedOut = this.out;
        this.tableRowsWriter = new StringWriter();
        this.out = new PrintWriter(this.tableRowsWriter);
        SimpleAttributeSet att = new SimpleAttributeSet();
        att.addAttribute("cols", String.valueOf(justification.length));
        this.writeStartTag(TGROUP_TAG, att);
        for (int i = 0; i < justification.length; ++i) {
            String justif;
            switch (justification[i]) {
                case 1: {
                    justif = "left";
                    break;
                }
                case 2: {
                    justif = "right";
                    break;
                }
                default: {
                    justif = "center";
                }
            }
            att = new SimpleAttributeSet();
            att.addAttribute(HTML.Attribute.ALIGN.toString(), justif);
            if (this.xmlMode) {
                this.writeSimpleTag(COLSPEC_TAG, att);
                continue;
            }
            this.writeStartTag(COLSPEC_TAG, att);
            this.writeEndTag(COLSPEC_TAG);
        }
        this.writeStartTag(TBODY_TAG);
    }

    public void tableRows_() {
        this.writeEndTag(TBODY_TAG);
        this.writeEndTag(TGROUP_TAG);
        this.out.flush();
        if (this.tableRowsWriter == null) {
            throw new IllegalArgumentException("tableRows( int[] justification, boolean grid ) was not called before.");
        }
        this.tableRows = this.tableRowsWriter.toString();
        this.tableRowsWriter = null;
        this.out = this.savedOut;
    }

    public void tableRow() {
        this.writeStartTag(ROW_TAG);
    }

    public void tableRow_() {
        this.writeEndTag(ROW_TAG);
    }

    public void tableCell() {
        this.writeStartTag(ENTRY_TAG);
    }

    public void tableCell_() {
        this.writeEndTag(ENTRY_TAG);
    }

    public void tableHeaderCell() {
        this.writeStartTag(ENTRY_TAG);
    }

    public void tableHeaderCell_() {
        this.writeEndTag(ENTRY_TAG);
    }

    public void tableCaption() {
        int sep;
        String frame;
        this.tableHasCaption = true;
        if (this.tableHasGrid) {
            frame = "all";
            sep = 1;
        } else {
            frame = "none";
            sep = 0;
        }
        SimpleAttributeSet att = new SimpleAttributeSet();
        att.addAttribute("frame", frame);
        att.addAttribute("rowsep", String.valueOf(sep));
        att.addAttribute("colsep", String.valueOf(sep));
        this.writeStartTag(HTML.Tag.TABLE, att);
        this.writeStartTag(HTML.Tag.TITLE);
    }

    public void tableCaption_() {
        this.writeEndTag(HTML.Tag.TITLE);
    }

    public void anchor(String name) {
        if (name == null) {
            throw new NullPointerException("Anchor name cannot be null!");
        }
        if (this.authorDateFlag) {
            return;
        }
        String id = name;
        if (!DoxiaUtils.isValidId((String)id)) {
            id = DoxiaUtils.encodeId((String)name);
            this.getLog().warn((CharSequence)("Modified invalid anchor name: " + name));
        }
        SimpleAttributeSet att = new SimpleAttributeSet();
        att.addAttribute(HTML.Attribute.ID, id);
        if (this.xmlMode) {
            this.writeSimpleTag(ANCHOR_TAG, att);
        } else {
            this.writeStartTag(ANCHOR_TAG, att);
        }
    }

    public void anchor_() {
        if (!this.authorDateFlag && !this.xmlMode) {
            this.writeEndTag(ANCHOR_TAG);
        }
    }

    public void link(String name) {
        if (name == null) {
            throw new NullPointerException("Link name cannot be null!");
        }
        if (DoxiaUtils.isExternalLink((String)name)) {
            this.externalLinkFlag = true;
            SimpleAttributeSet att = new SimpleAttributeSet();
            att.addAttribute("url", HtmlTools.escapeHTML((String)name, (boolean)this.xmlMode));
            this.writeStartTag(ULINK_TAG, att);
        } else {
            SimpleAttributeSet att = new SimpleAttributeSet();
            att.addAttribute("linkend", HtmlTools.escapeHTML((String)name));
            this.writeStartTag(LINK_TAG, att);
        }
    }

    public void link_() {
        if (this.externalLinkFlag) {
            this.writeEndTag(ULINK_TAG);
            this.externalLinkFlag = false;
        } else {
            this.writeEndTag(LINK_TAG);
        }
    }

    public void italic() {
        this.markup(this.italicBeginTag);
    }

    public void italic_() {
        this.markup(this.italicEndTag);
    }

    public void bold() {
        this.markup(this.boldBeginTag);
    }

    public void bold_() {
        this.markup(this.boldEndTag);
    }

    public void monospaced() {
        if (!this.authorDateFlag) {
            this.markup(this.monospacedBeginTag);
        }
    }

    public void monospaced_() {
        if (!this.authorDateFlag) {
            this.markup(this.monospacedEndTag);
        }
    }

    public void lineBreak() {
        this.markup(this.lineBreakElement);
    }

    public void nonBreakingSpace() {
        this.markup("&#x00A0;");
    }

    public void text(String text) {
        if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    public void comment(String comment) {
        StringBuffer buffer = new StringBuffer(comment.length() + 9);
        buffer.append('<').append('!').append('-').append('-').append(' ');
        buffer.append(comment);
        buffer.append(' ').append('-').append('-').append('>');
        this.markup(buffer.toString());
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        this.getLog().warn((CharSequence)("Unknown Sink event in DocBookSink: " + name + ", ignoring!"));
    }

    protected void markup(String text) {
        if (!this.skip) {
            this.out.write(text);
        }
    }

    protected void content(String text) {
        if (!this.skip) {
            this.out.write(DocBookSink.escapeSGML(text, this.xmlMode));
        }
    }

    protected void verbatimContent(String text) {
        if (!this.skip) {
            this.out.write(DocBookSink.escapeSGML(text, this.xmlMode));
        }
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }

    protected void write(String text) {
        this.markup(DocBookSink.unifyEOLs((String)text));
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }
}

