/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.markdown;

import com.vladsch.flexmark.ast.Heading;
import com.vladsch.flexmark.ast.HtmlCommentBlock;
import com.vladsch.flexmark.ast.util.TextCollectingVisitor;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.html.LinkResolverFactory;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.profiles.pegdown.PegdownOptionsAdapter;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.builder.Extension;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataHolder;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.markup.HtmlMarkup;
import org.apache.maven.doxia.module.markdown.FlexmarkDoxiaExtension;
import org.apache.maven.doxia.module.markdown.FlexmarkDoxiaLinkResolver;
import org.apache.maven.doxia.module.xhtml.XhtmlParser;
import org.apache.maven.doxia.parser.AbstractParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.sink.Sink;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;

@Component(role=org.apache.maven.doxia.parser.Parser.class, hint="markdown")
public class MarkdownParser
extends AbstractParser {
    public static final String ROLE_HINT = "markdown";
    private static final String MULTI_MARKDOWN_METADATA_SECTION = "^(((?:[^\\s:][^:]*):(?:.*(?:\r?\n\\p{Blank}+[^\\s].*)*\r?\n))+)(?:\\s*\r?\n)";
    private static final String MULTI_MARKDOWN_METADATA_ENTRY = "([^\\s:][^:]*):(.*(?:\r?\n\\p{Blank}+[^\\s].*)*)\r?\n";
    private static final String[] STANDARD_METADATA_KEYS = new String[]{"title", "author", "date", "address", "affiliation", "copyright", "email", "keywords", "language", "phone", "subtitle"};
    @Requirement
    private MarkdownHtmlParser parser;

    public int getType() {
        return 1;
    }

    public void parse(Reader source, Sink sink) throws ParseException {
        try {
            String html = this.toHtml(source);
            this.parser.parse(new StringReader(html), sink);
        }
        catch (IOException e) {
            throw new ParseException("Failed reading Markdown source document", (Exception)e);
        }
    }

    private String toHtml(Reader source) throws IOException {
        String text = IOUtil.toString((Reader)source);
        MutableDataHolder flexmarkOptions = PegdownOptionsAdapter.flexmarkOptions((int)64503, (Extension[])new Extension[0]).toMutable();
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        for (Extension extension : (Iterable)flexmarkOptions.get(Parser.EXTENSIONS)) {
            extensions.add(extension);
        }
        extensions.add(FlexmarkDoxiaExtension.create());
        flexmarkOptions.set(Parser.EXTENSIONS, extensions);
        flexmarkOptions.set(HtmlRenderer.HTML_BLOCK_OPEN_TAG_EOL, (Object)false);
        flexmarkOptions.set(HtmlRenderer.HTML_BLOCK_CLOSE_TAG_EOL, (Object)false);
        flexmarkOptions.set(HtmlRenderer.MAX_TRAILING_BLANK_LINES, (Object)-1);
        Parser parser = Parser.builder((DataHolder)flexmarkOptions).build();
        HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)flexmarkOptions).linkResolverFactory((LinkResolverFactory)new FlexmarkDoxiaLinkResolver.Factory()).build();
        StringBuilder html = new StringBuilder(1000);
        html.append("<html>");
        html.append("<head>");
        Pattern metadataPattern = Pattern.compile(MULTI_MARKDOWN_METADATA_SECTION, 8);
        Matcher metadataMatcher = metadataPattern.matcher(text);
        boolean haveTitle = false;
        if (metadataMatcher.find()) {
            metadataPattern = Pattern.compile(MULTI_MARKDOWN_METADATA_ENTRY, 8);
            Matcher lineMatcher = metadataPattern.matcher(metadataMatcher.group(1));
            boolean first = true;
            while (lineMatcher.find()) {
                String key = StringUtils.trimToEmpty((String)lineMatcher.group(1));
                if (first) {
                    boolean found = false;
                    for (String k : STANDARD_METADATA_KEYS) {
                        if (!k.equalsIgnoreCase(key)) continue;
                        found = true;
                        break;
                    }
                    if (!found) break;
                    first = false;
                }
                String value = StringUtils.trimToEmpty((String)lineMatcher.group(2));
                if ("title".equalsIgnoreCase(key)) {
                    haveTitle = true;
                    html.append("<title>");
                    html.append(StringEscapeUtils.escapeXml((String)value));
                    html.append("</title>");
                    continue;
                }
                if ("author".equalsIgnoreCase(key)) {
                    html.append("<meta name='author' content='");
                    html.append(StringEscapeUtils.escapeXml((String)value));
                    html.append("' />");
                    continue;
                }
                if ("date".equalsIgnoreCase(key)) {
                    html.append("<meta name='date' content='");
                    html.append(StringEscapeUtils.escapeXml((String)value));
                    html.append("' />");
                    continue;
                }
                html.append("<meta name='");
                html.append(StringEscapeUtils.escapeXml((String)key));
                html.append("' content='");
                html.append(StringEscapeUtils.escapeXml((String)value));
                html.append("' />");
            }
            if (!first) {
                text = text.substring(metadataMatcher.end());
            }
        }
        Document rootNode = parser.parse(text);
        String markdownHtml = renderer.render((Node)rootNode);
        if (!haveTitle && rootNode.hasChildren()) {
            Node firstNode;
            for (firstNode = rootNode.getFirstChild(); firstNode != null && !(firstNode instanceof Heading) && firstNode instanceof HtmlCommentBlock; firstNode = firstNode.getNext()) {
            }
            if (firstNode instanceof Heading) {
                html.append("<title>");
                TextCollectingVisitor collectingVisitor = new TextCollectingVisitor(new Class[0]);
                String headingText = collectingVisitor.collectAndGetText(firstNode);
                html.append(StringEscapeUtils.escapeXml((String)headingText));
                html.append("</title>");
            }
        }
        html.append("</head>");
        html.append("<body>");
        html.append(markdownHtml);
        html.append("</body>");
        html.append("</html>");
        return html.toString();
    }

    @Component(role=MarkdownHtmlParser.class)
    public static class MarkdownHtmlParser
    extends XhtmlParser {
        protected boolean baseEndTag(XmlPullParser parser, Sink sink) {
            boolean visited = super.baseEndTag(parser, sink);
            if (!visited && parser.getName().equals(HtmlMarkup.DIV.toString())) {
                this.handleUnknown(parser, sink, 3);
                visited = true;
            }
            return visited;
        }

        protected boolean baseStartTag(XmlPullParser parser, Sink sink) {
            boolean visited = super.baseStartTag(parser, sink);
            if (!visited && parser.getName().equals(HtmlMarkup.DIV.toString())) {
                this.handleUnknown(parser, sink, 2);
                visited = true;
            }
            return visited;
        }
    }
}

