/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.markdown;

import com.vladsch.flexmark.ext.wikilink.internal.WikiLinkLinkResolver;
import com.vladsch.flexmark.html.IndependentLinkResolverFactory;
import com.vladsch.flexmark.html.LinkResolver;
import com.vladsch.flexmark.html.renderer.LinkResolverBasicContext;
import com.vladsch.flexmark.html.renderer.LinkStatus;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlexmarkDoxiaLinkResolver
implements LinkResolver {
    final Pattern pattern = Pattern.compile("^(?![^:]+:)((?:\\./)?(?:\\.\\./)*[^\\.]+).(?:md|markdown)(#[^#\\.]*){0,1}$");

    public FlexmarkDoxiaLinkResolver(@NotNull LinkResolverBasicContext context) {
    }

    @NotNull
    public ResolvedLink resolveLink(@NotNull Node node, @NotNull LinkResolverBasicContext context, @NotNull ResolvedLink link) {
        Matcher matcher;
        if (link.getLinkType() == LinkType.LINK && (matcher = this.pattern.matcher(link.getUrl())).matches()) {
            return link.withStatus(LinkStatus.VALID).withUrl((CharSequence)matcher.replaceAll("$1.html$2"));
        }
        return link;
    }

    public static class Factory
    extends IndependentLinkResolverFactory {
        @Nullable
        public Set<Class<?>> getBeforeDependents() {
            HashSet set = new HashSet();
            set.add(WikiLinkLinkResolver.Factory.class);
            return set;
        }

        @NotNull
        public LinkResolver apply(@NotNull LinkResolverBasicContext context) {
            return new FlexmarkDoxiaLinkResolver(context);
        }
    }
}

