/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.rtf;

import org.apache.maven.doxia.module.rtf.FontMetrics;

class Font {
    private int size;
    private FontMetrics metrics;

    Font(int style, int size) throws Exception {
        this.size = size;
        this.metrics = FontMetrics.find(style);
    }

    int ascent() {
        return this.toTwips(this.metrics.ascent);
    }

    int descent() {
        return this.toTwips(this.metrics.descent);
    }

    TextExtents textExtents(String text) {
        int width = 0;
        short ascent = 0;
        short descent = 0;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            int c = text.charAt(i);
            if (c > 255) {
                c = 32;
            }
            FontMetrics.CharMetrics charMetrics = this.metrics.charMetrics[c];
            width += charMetrics.wx;
            if (charMetrics.ury > ascent) {
                ascent = charMetrics.ury;
            }
            if (charMetrics.lly >= descent) continue;
            descent = charMetrics.lly;
        }
        int height = ascent + Math.abs(descent);
        return new TextExtents(this.toTwips(width), this.toTwips(height), this.toTwips(ascent));
    }

    private int toTwips(int length) {
        return (int)Math.rint((double)length * (double)this.size / 50.0);
    }

    static class TextExtents {
        int width;
        int height;
        int ascent;

        TextExtents(int width, int height, int ascent) {
            this.width = width;
            this.height = height;
            this.ascent = ascent;
        }
    }
}

