// =================== DO NOT EDIT THIS FILE ====================
// Generated by Modello 2.1.2,
// any modifications will be overwritten.
// ==============================================================

package org.apache.maven.doxia.site.decoration.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.text.DateFormat;
import org.apache.maven.doxia.site.decoration.Banner;
import org.apache.maven.doxia.site.decoration.Body;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.LinkItem;
import org.apache.maven.doxia.site.decoration.Logo;
import org.apache.maven.doxia.site.decoration.Menu;
import org.apache.maven.doxia.site.decoration.MenuItem;
import org.apache.maven.doxia.site.decoration.PublishDate;
import org.apache.maven.doxia.site.decoration.Skin;
import org.apache.maven.doxia.site.decoration.Version;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.pull.EntityReplacementMap;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/**
 * Class DecorationXpp3Reader.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class DecorationXpp3Reader
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * If set the parser will be loaded with all single characters
     * from the XHTML specification.
     * The entities used:
     * <ul>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent</li>
     * <li>http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent</li>
     * </ul>
     */
    private boolean addDefaultEntities = true;

    /**
     * Field contentTransformer.
     */
    public final ContentTransformer contentTransformer;


      //----------------/
     //- Constructors -/
    //----------------/

    public DecorationXpp3Reader()
    {
        this( new ContentTransformer()
        {
            public String transform( String source, String fieldName )
            {
                return source;
            }
        } );
    } //-- org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Reader()

    public DecorationXpp3Reader(ContentTransformer contentTransformer)
    {
        this.contentTransformer = contentTransformer;
    } //-- org.apache.maven.doxia.site.decoration.io.xpp3.DecorationXpp3Reader(ContentTransformer)


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method checkFieldWithDuplicate.
     * 
     * @param parser a parser object.
     * @param parsed a parsed object.
     * @param alias a alias object.
     * @param tagName a tagName object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean checkFieldWithDuplicate( XmlPullParser parser, String tagName, String alias, java.util.Set parsed )
        throws XmlPullParserException
    {
        if ( !( parser.getName().equals( tagName ) || parser.getName().equals( alias ) ) )
        {
            return false;
        }
        if ( !parsed.add( tagName ) )
        {
            throw new XmlPullParserException( "Duplicated tag: '" + tagName + "'", parser, null );
        }
        return true;
    } //-- boolean checkFieldWithDuplicate( XmlPullParser, String, String, java.util.Set )

    /**
     * Method checkUnknownAttribute.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @param tagName a tagName object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @throws IOException IOException if any.
     */
    private void checkUnknownAttribute( XmlPullParser parser, String attribute, String tagName, boolean strict )
        throws XmlPullParserException, IOException
    {
        // strictXmlAttributes = true for model: if strict == true, not only elements are checked but attributes too
        if ( strict )
        {
            throw new XmlPullParserException( "Unknown attribute '" + attribute + "' for tag '" + tagName + "'", parser, null );
        }
    } //-- void checkUnknownAttribute( XmlPullParser, String, String, boolean )

    /**
     * Method checkUnknownElement.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @throws IOException IOException if any.
     */
    private void checkUnknownElement( XmlPullParser parser, boolean strict )
        throws XmlPullParserException, IOException
    {
        if ( strict )
        {
            throw new XmlPullParserException( "Unrecognised tag: '" + parser.getName() + "'", parser, null );
        }

        for ( int unrecognizedTagCount = 1; unrecognizedTagCount > 0; )
        {
            int eventType = parser.next();
            if ( eventType == XmlPullParser.START_TAG )
            {
                unrecognizedTagCount++;
            }
            else if ( eventType == XmlPullParser.END_TAG )
            {
                unrecognizedTagCount--;
            }
        }
    } //-- void checkUnknownElement( XmlPullParser, boolean )

    /**
     * Returns the state of the "add default entities" flag.
     * 
     * @return boolean
     */
    public boolean getAddDefaultEntities()
    {
        return addDefaultEntities;
    } //-- boolean getAddDefaultEntities()

    /**
     * Method getBooleanValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getBooleanValue( s, attribute, parser, null );
    } //-- boolean getBooleanValue( String, String, XmlPullParser )

    /**
     * Method getBooleanValue.
     * 
     * @param s a s object.
     * @param defaultValue a defaultValue object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return boolean
     */
    private boolean getBooleanValue( String s, String attribute, XmlPullParser parser, String defaultValue )
        throws XmlPullParserException
    {
        if ( s != null && s.length() != 0 )
        {
            return Boolean.valueOf( s ).booleanValue();
        }
        if ( defaultValue != null )
        {
            return Boolean.valueOf( defaultValue ).booleanValue();
        }
        return false;
    } //-- boolean getBooleanValue( String, String, XmlPullParser, String )

    /**
     * Method getByteValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return byte
     */
    private byte getByteValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Byte.valueOf( s ).byteValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a byte", parser, nfe );
                }
            }
        }
        return 0;
    } //-- byte getByteValue( String, String, XmlPullParser, boolean )

    /**
     * Method getCharacterValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return char
     */
    private char getCharacterValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            return s.charAt( 0 );
        }
        return 0;
    } //-- char getCharacterValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, XmlPullParser parser )
        throws XmlPullParserException
    {
        return getDateValue( s, attribute, null, parser );
    } //-- java.util.Date getDateValue( String, String, XmlPullParser )

    /**
     * Method getDateValue.
     * 
     * @param s a s object.
     * @param parser a parser object.
     * @param dateFormat a dateFormat object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Date
     */
    private java.util.Date getDateValue( String s, String attribute, String dateFormat, XmlPullParser parser )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            String effectiveDateFormat = dateFormat;
            if ( dateFormat == null )
            {
                effectiveDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS";
            }
            if ( "long".equals( effectiveDateFormat ) )
            {
                try
                {
                    return new java.util.Date( Long.parseLong( s ) );
                }
                catch ( NumberFormatException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
            else
            {
                try
                {
                    DateFormat dateParser = new java.text.SimpleDateFormat( effectiveDateFormat, java.util.Locale.US );
                    return dateParser.parse( s );
                }
                catch ( java.text.ParseException e )
                {
                    throw new XmlPullParserException( e.getMessage(), parser, e );
                }
            }
        }
        return null;
    } //-- java.util.Date getDateValue( String, String, String, XmlPullParser )

    /**
     * Method getDoubleValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return double
     */
    private double getDoubleValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Double.valueOf( s ).doubleValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- double getDoubleValue( String, String, XmlPullParser, boolean )

    /**
     * Method getFloatValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return float
     */
    private float getFloatValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Float.valueOf( s ).floatValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a floating point number", parser, nfe );
                }
            }
        }
        return 0;
    } //-- float getFloatValue( String, String, XmlPullParser, boolean )

    /**
     * Method getIntegerValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return int
     */
    private int getIntegerValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Integer.valueOf( s ).intValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be an integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- int getIntegerValue( String, String, XmlPullParser, boolean )

    /**
     * Method getLongValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return long
     */
    private long getLongValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Long.valueOf( s ).longValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a long integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- long getLongValue( String, String, XmlPullParser, boolean )

    /**
     * Method getRequiredAttributeValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return String
     */
    private String getRequiredAttributeValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s == null )
        {
            if ( strict )
            {
                throw new XmlPullParserException( "Missing required value for attribute '" + attribute + "'", parser, null );
            }
        }
        return s;
    } //-- String getRequiredAttributeValue( String, String, XmlPullParser, boolean )

    /**
     * Method getShortValue.
     * 
     * @param s a s object.
     * @param strict a strict object.
     * @param parser a parser object.
     * @param attribute a attribute object.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return short
     */
    private short getShortValue( String s, String attribute, XmlPullParser parser, boolean strict )
        throws XmlPullParserException
    {
        if ( s != null )
        {
            try
            {
                return Short.valueOf( s ).shortValue();
            }
            catch ( NumberFormatException nfe )
            {
                if ( strict )
                {
                    throw new XmlPullParserException( "Unable to parse element '" + attribute + "', must be a short integer", parser, nfe );
                }
            }
        }
        return 0;
    } //-- short getShortValue( String, String, XmlPullParser, boolean )

    /**
     * Method getTrimmedValue.
     * 
     * @param s a s object.
     * @return String
     */
    private String getTrimmedValue( String s )
    {
        if ( s != null )
        {
            s = s.trim();
        }
        return s;
    } //-- String getTrimmedValue( String )

    /**
     * Method interpolatedTrimmed.
     * 
     * @param value a value object.
     * @param context a context object.
     * @return String
     */
    private String interpolatedTrimmed( String value, String context )
    {
        return getTrimmedValue( contentTransformer.transform( value, context ) );
    } //-- String interpolatedTrimmed( String, String )

    /**
     * Method nextTag.
     * 
     * @param parser a parser object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return int
     */
    private int nextTag( XmlPullParser parser )
        throws IOException, XmlPullParserException
    {
        int eventType = parser.next();
        if ( eventType == XmlPullParser.TEXT )
        {
            eventType = parser.next();
        }
        if ( eventType != XmlPullParser.START_TAG && eventType != XmlPullParser.END_TAG )
        {
            throw new XmlPullParserException( "expected START_TAG or END_TAG not " + XmlPullParser.TYPES[eventType], parser, null );
        }
        return eventType;
    } //-- int nextTag( XmlPullParser )

    /**
     * Method read.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return DecorationModel
     */
    public DecorationModel read( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        DecorationModel decorationModel = null;
        int eventType = parser.getEventType();
        boolean parsed = false;
        while ( eventType != XmlPullParser.END_DOCUMENT )
        {
            if ( eventType == XmlPullParser.START_TAG )
            {
                if ( strict && ! "project".equals( parser.getName() ) )
                {
                    throw new XmlPullParserException( "Expected root element 'project' but found '" + parser.getName() + "'", parser, null );
                }
                else if ( parsed )
                {
                    // fallback, already expected a XmlPullParserException due to invalid XML
                    throw new XmlPullParserException( "Duplicated tag: 'project'", parser, null );
                }
                decorationModel = parseDecorationModel( parser, strict );
                decorationModel.setModelEncoding( parser.getInputEncoding() );
                parsed = true;
            }
            eventType = parser.next();
        }
        if ( parsed )
        {
            return decorationModel;
        }
        throw new XmlPullParserException( "Expected root element 'project' but found no element at all: invalid XML document", parser, null );
    } //-- DecorationModel read( XmlPullParser, boolean )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader a reader object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return DecorationModel
     */
    public DecorationModel read( Reader reader, boolean strict )
        throws IOException, XmlPullParserException
    {
        XmlPullParser parser = addDefaultEntities ? new MXParser(EntityReplacementMap.defaultEntityReplacementMap) : new MXParser( );

        parser.setInput( reader );


        return read( parser, strict );
    } //-- DecorationModel read( Reader, boolean )

    /**
     * @see ReaderFactory#newXmlReader
     * 
     * @param reader a reader object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return DecorationModel
     */
    public DecorationModel read( Reader reader )
        throws IOException, XmlPullParserException
    {
        return read( reader, true );
    } //-- DecorationModel read( Reader )

    /**
     * Method read.
     * 
     * @param in a in object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return DecorationModel
     */
    public DecorationModel read( InputStream in, boolean strict )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ), strict );
    } //-- DecorationModel read( InputStream, boolean )

    /**
     * Method read.
     * 
     * @param in a in object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return DecorationModel
     */
    public DecorationModel read( InputStream in )
        throws IOException, XmlPullParserException
    {
        return read( ReaderFactory.newXmlReader( in ) );
    } //-- DecorationModel read( InputStream )

    /**
     * Method parseBanner.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Banner
     */
    private Banner parseBanner( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Banner banner = new Banner();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "name", null, parsed ) )
            {
                banner.setName( interpolatedTrimmed( parser.nextText(), "name" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "src", null, parsed ) )
            {
                banner.setSrc( interpolatedTrimmed( parser.nextText(), "src" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "alt", null, parsed ) )
            {
                banner.setAlt( interpolatedTrimmed( parser.nextText(), "alt" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "href", null, parsed ) )
            {
                banner.setHref( interpolatedTrimmed( parser.nextText(), "href" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "border", null, parsed ) )
            {
                banner.setBorder( interpolatedTrimmed( parser.nextText(), "border" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "width", null, parsed ) )
            {
                banner.setWidth( interpolatedTrimmed( parser.nextText(), "width" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "height", null, parsed ) )
            {
                banner.setHeight( interpolatedTrimmed( parser.nextText(), "height" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "title", null, parsed ) )
            {
                banner.setTitle( interpolatedTrimmed( parser.nextText(), "title" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return banner;
    } //-- Banner parseBanner( XmlPullParser, boolean )

    /**
     * Method parseBody.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Body
     */
    private Body parseBody( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Body body = new Body();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "head", null, parsed ) )
            {
                body.setHead( interpolatedTrimmed( parser.nextText(), "head" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "links", null, parsed ) )
            {
                java.util.List<LinkItem> links = new java.util.ArrayList<LinkItem>();
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "item".equals( parser.getName() ) )
                    {
                        links.add( parseLinkItem( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
                body.setLinks( links );
            }
            else if ( checkFieldWithDuplicate( parser, "breadcrumbs", null, parsed ) )
            {
                java.util.List<LinkItem> breadcrumbs = new java.util.ArrayList<LinkItem>();
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "item".equals( parser.getName() ) )
                    {
                        breadcrumbs.add( parseLinkItem( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
                body.setBreadcrumbs( breadcrumbs );
            }
            else if ( "menu".equals( parser.getName() ) )
            {
                java.util.List<Menu> menus = body.getMenus();
                if ( menus == null )
                {
                    menus = new java.util.ArrayList<Menu>();
                }
                menus.add( parseMenu( parser, strict ) );
                body.setMenus( menus );
            }
            else if ( checkFieldWithDuplicate( parser, "footer", null, parsed ) )
            {
                body.setFooter( interpolatedTrimmed( parser.nextText(), "footer" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return body;
    } //-- Body parseBody( XmlPullParser, boolean )

    /**
     * Method parseDecorationModel.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return DecorationModel
     */
    private DecorationModel parseDecorationModel( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        DecorationModel decorationModel = new DecorationModel();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "xmlns".equals( name ) )
            {
                // ignore xmlns attribute in root class, which is a reserved attribute name
            }
            else if ( "name".equals( name ) )
            {
                decorationModel.setName( interpolatedTrimmed( value, "name" ) );
            }
            else if ( "combine.self".equals( name ) )
            {
                decorationModel.setCombineSelf( interpolatedTrimmed( value, "combine.self" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "bannerLeft", null, parsed ) )
            {
                decorationModel.setBannerLeft( parseBanner( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "bannerRight", null, parsed ) )
            {
                decorationModel.setBannerRight( parseBanner( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "publishDate", null, parsed ) )
            {
                decorationModel.setPublishDate( parsePublishDate( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "version", null, parsed ) )
            {
                decorationModel.setVersion( parseVersion( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "edit", null, parsed ) )
            {
                decorationModel.setEdit( interpolatedTrimmed( parser.nextText(), "edit" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "poweredBy", null, parsed ) )
            {
                java.util.List<Logo> poweredBy = new java.util.ArrayList<Logo>();
                while ( parser.nextTag() == XmlPullParser.START_TAG )
                {
                    if ( "logo".equals( parser.getName() ) )
                    {
                        poweredBy.add( parseLogo( parser, strict ) );
                    }
                    else
                    {
                        checkUnknownElement( parser, strict );
                    }
                }
                decorationModel.setPoweredBy( poweredBy );
            }
            else if ( checkFieldWithDuplicate( parser, "skin", null, parsed ) )
            {
                decorationModel.setSkin( parseSkin( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "body", null, parsed ) )
            {
                decorationModel.setBody( parseBody( parser, strict ) );
            }
            else if ( checkFieldWithDuplicate( parser, "custom", null, parsed ) )
            {
                decorationModel.setCustom( org.codehaus.plexus.util.xml.Xpp3DomBuilder.build( parser, true ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return decorationModel;
    } //-- DecorationModel parseDecorationModel( XmlPullParser, boolean )

    /**
     * Method parseLinkItem.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return LinkItem
     */
    private LinkItem parseLinkItem( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        LinkItem linkItem = new LinkItem();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "name".equals( name ) )
            {
                linkItem.setName( interpolatedTrimmed( value, "name" ) );
            }
            else if ( "href".equals( name ) )
            {
                linkItem.setHref( interpolatedTrimmed( value, "href" ) );
            }
            else if ( "img".equals( name ) )
            {
                linkItem.setImg( interpolatedTrimmed( value, "img" ) );
            }
            else if ( "position".equals( name ) )
            {
                linkItem.setPosition( interpolatedTrimmed( value, "position" ) );
            }
            else if ( "alt".equals( name ) )
            {
                linkItem.setAlt( interpolatedTrimmed( value, "alt" ) );
            }
            else if ( "border".equals( name ) )
            {
                linkItem.setBorder( interpolatedTrimmed( value, "border" ) );
            }
            else if ( "width".equals( name ) )
            {
                linkItem.setWidth( interpolatedTrimmed( value, "width" ) );
            }
            else if ( "height".equals( name ) )
            {
                linkItem.setHeight( interpolatedTrimmed( value, "height" ) );
            }
            else if ( "target".equals( name ) )
            {
                linkItem.setTarget( interpolatedTrimmed( value, "target" ) );
            }
            else if ( "title".equals( name ) )
            {
                linkItem.setTitle( interpolatedTrimmed( value, "title" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return linkItem;
    } //-- LinkItem parseLinkItem( XmlPullParser, boolean )

    /**
     * Method parseLogo.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Logo
     */
    private Logo parseLogo( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Logo logo = new Logo();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "name".equals( name ) )
            {
                logo.setName( interpolatedTrimmed( value, "name" ) );
            }
            else if ( "href".equals( name ) )
            {
                logo.setHref( interpolatedTrimmed( value, "href" ) );
            }
            else if ( "img".equals( name ) )
            {
                logo.setImg( interpolatedTrimmed( value, "img" ) );
            }
            else if ( "position".equals( name ) )
            {
                logo.setPosition( interpolatedTrimmed( value, "position" ) );
            }
            else if ( "alt".equals( name ) )
            {
                logo.setAlt( interpolatedTrimmed( value, "alt" ) );
            }
            else if ( "border".equals( name ) )
            {
                logo.setBorder( interpolatedTrimmed( value, "border" ) );
            }
            else if ( "width".equals( name ) )
            {
                logo.setWidth( interpolatedTrimmed( value, "width" ) );
            }
            else if ( "height".equals( name ) )
            {
                logo.setHeight( interpolatedTrimmed( value, "height" ) );
            }
            else if ( "target".equals( name ) )
            {
                logo.setTarget( interpolatedTrimmed( value, "target" ) );
            }
            else if ( "title".equals( name ) )
            {
                logo.setTitle( interpolatedTrimmed( value, "title" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return logo;
    } //-- Logo parseLogo( XmlPullParser, boolean )

    /**
     * Method parseMenu.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Menu
     */
    private Menu parseMenu( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Menu menu = new Menu();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "name".equals( name ) )
            {
                menu.setName( interpolatedTrimmed( value, "name" ) );
            }
            else if ( "inherit".equals( name ) )
            {
                menu.setInherit( interpolatedTrimmed( value, "inherit" ) );
            }
            else if ( "inheritAsRef".equals( name ) )
            {
                menu.setInheritAsRef( getBooleanValue( interpolatedTrimmed( value, "inheritAsRef" ), "inheritAsRef", parser, "false" ) );
            }
            else if ( "ref".equals( name ) )
            {
                menu.setRef( interpolatedTrimmed( value, "ref" ) );
            }
            else if ( "img".equals( name ) )
            {
                menu.setImg( interpolatedTrimmed( value, "img" ) );
            }
            else if ( "alt".equals( name ) )
            {
                menu.setAlt( interpolatedTrimmed( value, "alt" ) );
            }
            else if ( "position".equals( name ) )
            {
                menu.setPosition( interpolatedTrimmed( value, "position" ) );
            }
            else if ( "border".equals( name ) )
            {
                menu.setBorder( interpolatedTrimmed( value, "border" ) );
            }
            else if ( "width".equals( name ) )
            {
                menu.setWidth( interpolatedTrimmed( value, "width" ) );
            }
            else if ( "height".equals( name ) )
            {
                menu.setHeight( interpolatedTrimmed( value, "height" ) );
            }
            else if ( "title".equals( name ) )
            {
                menu.setTitle( interpolatedTrimmed( value, "title" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( "item".equals( parser.getName() ) )
            {
                java.util.List<MenuItem> items = menu.getItems();
                if ( items == null )
                {
                    items = new java.util.ArrayList<MenuItem>();
                }
                items.add( parseMenuItem( parser, strict ) );
                menu.setItems( items );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return menu;
    } //-- Menu parseMenu( XmlPullParser, boolean )

    /**
     * Method parseMenuItem.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return MenuItem
     */
    private MenuItem parseMenuItem( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        MenuItem menuItem = new MenuItem();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "collapse".equals( name ) )
            {
                menuItem.setCollapse( getBooleanValue( interpolatedTrimmed( value, "collapse" ), "collapse", parser, "false" ) );
            }
            else if ( "ref".equals( name ) )
            {
                menuItem.setRef( interpolatedTrimmed( value, "ref" ) );
            }
            else if ( "name".equals( name ) )
            {
                menuItem.setName( interpolatedTrimmed( value, "name" ) );
            }
            else if ( "href".equals( name ) )
            {
                menuItem.setHref( interpolatedTrimmed( value, "href" ) );
            }
            else if ( "img".equals( name ) )
            {
                menuItem.setImg( interpolatedTrimmed( value, "img" ) );
            }
            else if ( "position".equals( name ) )
            {
                menuItem.setPosition( interpolatedTrimmed( value, "position" ) );
            }
            else if ( "alt".equals( name ) )
            {
                menuItem.setAlt( interpolatedTrimmed( value, "alt" ) );
            }
            else if ( "border".equals( name ) )
            {
                menuItem.setBorder( interpolatedTrimmed( value, "border" ) );
            }
            else if ( "width".equals( name ) )
            {
                menuItem.setWidth( interpolatedTrimmed( value, "width" ) );
            }
            else if ( "height".equals( name ) )
            {
                menuItem.setHeight( interpolatedTrimmed( value, "height" ) );
            }
            else if ( "target".equals( name ) )
            {
                menuItem.setTarget( interpolatedTrimmed( value, "target" ) );
            }
            else if ( "title".equals( name ) )
            {
                menuItem.setTitle( interpolatedTrimmed( value, "title" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "description", null, parsed ) )
            {
                menuItem.setDescription( interpolatedTrimmed( parser.nextText(), "description" ) );
            }
            else if ( "item".equals( parser.getName() ) )
            {
                java.util.List<MenuItem> items = menuItem.getItems();
                if ( items == null )
                {
                    items = new java.util.ArrayList<MenuItem>();
                }
                items.add( parseMenuItem( parser, strict ) );
                menuItem.setItems( items );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return menuItem;
    } //-- MenuItem parseMenuItem( XmlPullParser, boolean )

    /**
     * Method parsePublishDate.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return PublishDate
     */
    private PublishDate parsePublishDate( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        PublishDate publishDate = new PublishDate();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "position".equals( name ) )
            {
                publishDate.setPosition( interpolatedTrimmed( value, "position" ) );
            }
            else if ( "format".equals( name ) )
            {
                publishDate.setFormat( interpolatedTrimmed( value, "format" ) );
            }
            else if ( "timezone".equals( name ) )
            {
                publishDate.setTimezone( interpolatedTrimmed( value, "timezone" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return publishDate;
    } //-- PublishDate parsePublishDate( XmlPullParser, boolean )

    /**
     * Method parseSkin.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Skin
     */
    private Skin parseSkin( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Skin skin = new Skin();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            if ( checkFieldWithDuplicate( parser, "groupId", null, parsed ) )
            {
                skin.setGroupId( interpolatedTrimmed( parser.nextText(), "groupId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "artifactId", null, parsed ) )
            {
                skin.setArtifactId( interpolatedTrimmed( parser.nextText(), "artifactId" ) );
            }
            else if ( checkFieldWithDuplicate( parser, "version", null, parsed ) )
            {
                skin.setVersion( interpolatedTrimmed( parser.nextText(), "version" ) );
            }
            else
            {
                checkUnknownElement( parser, strict );
            }
        }
        return skin;
    } //-- Skin parseSkin( XmlPullParser, boolean )

    /**
     * Method parseVersion.
     * 
     * @param parser a parser object.
     * @param strict a strict object.
     * @throws IOException IOException if any.
     * @throws XmlPullParserException XmlPullParserException if
     * any.
     * @return Version
     */
    private Version parseVersion( XmlPullParser parser, boolean strict )
        throws IOException, XmlPullParserException
    {
        String tagName = parser.getName();
        Version version = new Version();
        for ( int i = parser.getAttributeCount() - 1; i >= 0; i-- )
        {
            String name = parser.getAttributeName( i );
            String value = parser.getAttributeValue( i );

            if ( name.indexOf( ':' ) >= 0 )
            {
                // just ignore attributes with non-default namespace (for example: xmlns:xsi)
            }
            else if ( "position".equals( name ) )
            {
                version.setPosition( interpolatedTrimmed( value, "position" ) );
            }
            else
            {
                checkUnknownAttribute( parser, name, tagName, strict );
            }
        }
        java.util.Set parsed = new java.util.HashSet();
        while ( ( strict ? parser.nextTag() : nextTag( parser ) ) == XmlPullParser.START_TAG )
        {
            checkUnknownElement( parser, strict );
        }
        return version;
    } //-- Version parseVersion( XmlPullParser, boolean )

    /**
     * Sets the state of the "add default entities" flag.
     * 
     * @param addDefaultEntities a addDefaultEntities object.
     */
    public void setAddDefaultEntities( boolean addDefaultEntities )
    {
        this.addDefaultEntities = addDefaultEntities;
    } //-- void setAddDefaultEntities( boolean )

    public static interface ContentTransformer
{
    /**
     * Interpolate the value read from the xpp3 document
     * @param source The source value
     * @param fieldName A description of the field being interpolated. The implementation may use this to
     *                           log stuff.
     * @return The interpolated value.
     */
    String transform( String source, String fieldName );
}

}
