/*
 =================== DO NOT EDIT THIS FILE ====================
 
 Generated by Modello 2.4.0,
 
 any modifications will be overwritten.
 
 ==============================================================
 */

package org.apache.maven.doxia.site;

/**
 * A menu in the navigation.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class Menu
    implements java.io.Serializable, java.lang.Cloneable
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * The name to display for the menu.
     */
    private String name;

    /**
     * 
     *             The way in which the menu is inherited. Can be
     * one of : <code>top</code>, <code>bottom</code>.
     *           
     */
    private String inherit;

    /**
     * 
     *             If this is a reference, setting to
     * <code>true</code> means that it will be populated
     *             in the site, whereas if it is
     * <code>false</code>, it is populated in the parent and then
     * inherited.
     *           
     */
    private boolean inheritAsRef = false;

    /**
     * 
     *             Mark this menu as reference to a pre-defined
     * menu: <code>reports</code>, <code>modules</code>
     *             or <code>parent</code>. It will be populated at
     * runtime with corresponding pre-defined content.
     *           
     */
    private String ref;

    /**
     * The image for the menu.
     */
    private Image image;

    /**
     * Field items.
     */
    private java.util.List<MenuItem> items;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method addItem.
     * 
     * @param menuItem a menuItem object.
     */
    public void addItem( MenuItem menuItem )
    {
        getItems().add( menuItem );
    } //-- void addItem( MenuItem )

    /**
     * Method clone.
     * 
     * @return Menu
     */
    public Menu clone()
    {
        try
        {
            Menu copy = (Menu) super.clone();

            if ( this.image != null )
            {
                copy.image = (Image) this.image.clone();
            }

            if ( this.items != null )
            {
                copy.items = new java.util.ArrayList<MenuItem>();
                for ( MenuItem item : this.items )
                {
                    copy.items.add( ( (MenuItem) item).clone() );
                }
            }

            return copy;
        }
        catch ( java.lang.Exception ex )
        {
            throw (java.lang.RuntimeException) new java.lang.UnsupportedOperationException( getClass().getName()
                + " does not support clone()" ).initCause( ex );
        }
    } //-- Menu clone()

    /**
     * Method equals.
     * 
     * @param other a other object.
     * @return boolean
     */
    public boolean equals( Object other )
    {
        if ( this == other )
        {
            return true;
        }

        if ( !( other instanceof Menu ) )
        {
            return false;
        }

        Menu that = (Menu) other;
        boolean result = true;

        result = result && ( getName() == null ? that.getName() == null : getName().equals( that.getName() ) );
        result = result && ( getInherit() == null ? that.getInherit() == null : getInherit().equals( that.getInherit() ) );
        result = result && ( getRef() == null ? that.getRef() == null : getRef().equals( that.getRef() ) );
        result = result && ( getImage() == null ? that.getImage() == null : getImage().equals( that.getImage() ) );
        result = result && ( getItems() == null ? that.getItems() == null : getItems().equals( that.getItems() ) );

        return result;
    } //-- boolean equals( Object )

    /**
     * Get the image for the menu.
     * 
     * @return Image
     */
    public Image getImage()
    {
        return this.image;
    } //-- Image getImage()

    /**
     * Get the way in which the menu is inherited. Can be one of :
     * <code>top</code>, <code>bottom</code>.
     * 
     * @return String
     */
    public String getInherit()
    {
        return this.inherit;
    } //-- String getInherit()

    /**
     * Method getItems.
     * 
     * @return List
     */
    public java.util.List<MenuItem> getItems()
    {
        if ( this.items == null )
        {
            this.items = new java.util.ArrayList<MenuItem>();
        }

        return this.items;
    } //-- java.util.List<MenuItem> getItems()

    /**
     * Get the name to display for the menu.
     * 
     * @return String
     */
    public String getName()
    {
        return this.name;
    } //-- String getName()

    /**
     * Get mark this menu as reference to a pre-defined menu:
     * <code>reports</code>, <code>modules</code>
     *             or <code>parent</code>. It will be populated at
     * runtime with corresponding pre-defined content.
     * 
     * @return String
     */
    public String getRef()
    {
        return this.ref;
    } //-- String getRef()

    /**
     * Method hashCode.
     * 
     * @return int
     */
    public int hashCode()
    {
        int result = 17;

        result = 37 * result + ( name != null ? name.hashCode() : 0 );
        result = 37 * result + ( inherit != null ? inherit.hashCode() : 0 );
        result = 37 * result + ( ref != null ? ref.hashCode() : 0 );
        result = 37 * result + ( image != null ? image.hashCode() : 0 );
        result = 37 * result + ( items != null ? items.hashCode() : 0 );

        return result;
    } //-- int hashCode()

    /**
     * Get if this is a reference, setting to <code>true</code>
     * means that it will be populated
     *             in the site, whereas if it is
     * <code>false</code>, it is populated in the parent and then
     * inherited.
     * 
     * @return boolean
     */
    public boolean isInheritAsRef()
    {
        return this.inheritAsRef;
    } //-- boolean isInheritAsRef()

    /**
     * Method removeItem.
     * 
     * @param menuItem a menuItem object.
     */
    public void removeItem( MenuItem menuItem )
    {
        getItems().remove( menuItem );
    } //-- void removeItem( MenuItem )

    /**
     * Set the image for the menu.
     * 
     * @param image a image object.
     */
    public void setImage( Image image )
    {
        this.image = image;
    } //-- void setImage( Image )

    /**
     * Set the way in which the menu is inherited. Can be one of :
     * <code>top</code>, <code>bottom</code>.
     * 
     * @param inherit a inherit object.
     */
    public void setInherit( String inherit )
    {
        this.inherit = inherit;
    } //-- void setInherit( String )

    /**
     * Set if this is a reference, setting to <code>true</code>
     * means that it will be populated
     *             in the site, whereas if it is
     * <code>false</code>, it is populated in the parent and then
     * inherited.
     * 
     * @param inheritAsRef a inheritAsRef object.
     */
    public void setInheritAsRef( boolean inheritAsRef )
    {
        this.inheritAsRef = inheritAsRef;
    } //-- void setInheritAsRef( boolean )

    /**
     * Set a list of menu item.
     * 
     * @param items a items object.
     */
    public void setItems( java.util.List<MenuItem> items )
    {
        this.items = items;
    } //-- void setItems( java.util.List )

    /**
     * Set the name to display for the menu.
     * 
     * @param name a name object.
     */
    public void setName( String name )
    {
        this.name = name;
    } //-- void setName( String )

    /**
     * Set mark this menu as reference to a pre-defined menu:
     * <code>reports</code>, <code>modules</code>
     *             or <code>parent</code>. It will be populated at
     * runtime with corresponding pre-defined content.
     * 
     * @param ref a ref object.
     */
    public void setRef( String ref )
    {
        this.ref = ref;
    } //-- void setRef( String )

    /**
     * Method toString.
     * 
     * @return String
     */
    public java.lang.String toString()
    {
        StringBuilder buf = new StringBuilder( 128 );

        buf.append( "name = '" );
        buf.append( getName() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "inherit = '" );
        buf.append( getInherit() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "ref = '" );
        buf.append( getRef() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "image = '" );
        buf.append( getImage() );
        buf.append( "'" );
        buf.append( "\n" ); 
        buf.append( "items = '" );
        buf.append( getItems() );
        buf.append( "'" );

        return buf.toString();
    } //-- java.lang.String toString()

}
