/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.checksum;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.buildcache.CacheUtils;
import org.apache.maven.buildcache.MultiModuleSupport;
import org.apache.maven.buildcache.NormalizedModelProvider;
import org.apache.maven.buildcache.PluginScanConfig;
import org.apache.maven.buildcache.ProjectInputCalculator;
import org.apache.maven.buildcache.RemoteCacheRepository;
import org.apache.maven.buildcache.ScanConfigProperties;
import org.apache.maven.buildcache.Xpp3DomUtils;
import org.apache.maven.buildcache.checksum.DependencyNotResolvedException;
import org.apache.maven.buildcache.checksum.DigestUtils;
import org.apache.maven.buildcache.checksum.KeyUtils;
import org.apache.maven.buildcache.checksum.WalkKey;
import org.apache.maven.buildcache.hash.HashAlgorithm;
import org.apache.maven.buildcache.hash.HashChecksum;
import org.apache.maven.buildcache.xml.CacheConfig;
import org.apache.maven.buildcache.xml.DtoUtils;
import org.apache.maven.buildcache.xml.build.DigestItem;
import org.apache.maven.buildcache.xml.build.ProjectsInputInfo;
import org.apache.maven.buildcache.xml.config.Exclude;
import org.apache.maven.buildcache.xml.config.Include;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectInput {
    public static final String CACHE_IMPLEMENTATION_VERSION = "v1";
    private static final String CACHE_INPUT_GLOB_NAME = "maven.build.cache.input.glob";
    public static final String DEFAULT_GLOB = "{*.java,*.groovy,*.yaml,*.svcd,*.proto,*assembly.xml,assembly*.xml,*logback.xml,*.vm,*.ini,*.jks,*.properties,*.sh,*.bat}";
    private static final String CACHE_INPUT_NAME = "maven.build.cache.input";
    private static final String CACHE_EXCLUDE_NAME = "maven.build.cache.exclude";
    private static final String CACHE_PROCESS_PLUGINS = "maven.build.cache.processPlugins";
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenProjectInput.class);
    private final MavenProject project;
    private final MavenSession session;
    private final RemoteCacheRepository remoteCache;
    private final RepositorySystem repoSystem;
    private final CacheConfig config;
    private final PathIgnoringCaseComparator fileComparator;
    private final List<Path> filteredOutPaths;
    private final NormalizedModelProvider normalizedModelProvider;
    private final MultiModuleSupport multiModuleSupport;
    private final ProjectInputCalculator projectInputCalculator;
    private final Path baseDirPath;
    private final String dirGlob;
    private final boolean processPlugins;
    private final String tmpDir;

    public MavenProjectInput(MavenProject project, NormalizedModelProvider normalizedModelProvider, MultiModuleSupport multiModuleSupport, ProjectInputCalculator projectInputCalculator, MavenSession session, CacheConfig config, RepositorySystem repoSystem, RemoteCacheRepository remoteCache) {
        this.project = project;
        this.normalizedModelProvider = normalizedModelProvider;
        this.multiModuleSupport = multiModuleSupport;
        this.projectInputCalculator = projectInputCalculator;
        this.session = session;
        this.config = config;
        this.baseDirPath = project.getBasedir().toPath().toAbsolutePath();
        this.repoSystem = repoSystem;
        this.remoteCache = remoteCache;
        Properties properties = project.getProperties();
        this.dirGlob = properties.getProperty(CACHE_INPUT_GLOB_NAME, config.getDefaultGlob());
        this.processPlugins = Boolean.parseBoolean(properties.getProperty(CACHE_PROCESS_PLUGINS, config.isProcessPlugins()));
        this.tmpDir = System.getProperty("java.io.tmpdir");
        Build build = project.getBuild();
        this.filteredOutPaths = new ArrayList<Path>(Arrays.asList(this.normalizedPath(build.getDirectory()), this.normalizedPath(build.getOutputDirectory()), this.normalizedPath(build.getTestOutputDirectory())));
        List<Exclude> excludes = config.getGlobalExcludePaths();
        for (Exclude excludePath : excludes) {
            this.filteredOutPaths.add(Paths.get(excludePath.getValue(), new String[0]));
        }
        for (String propertyName : properties.stringPropertyNames()) {
            if (!propertyName.startsWith(CACHE_EXCLUDE_NAME)) continue;
            String propertyValue = properties.getProperty(propertyName);
            Path path = Paths.get(propertyValue, new String[0]);
            this.filteredOutPaths.add(path);
            if (!LOGGER.isDebugEnabled()) continue;
            LOGGER.debug("Adding an excludePath from property '{}', values is '{}', path is '{}' ", new Object[]{propertyName, propertyValue, path});
        }
        CacheUtils.debugPrintCollection(LOGGER, this.filteredOutPaths, "List of excluded paths (checked either by fileName or by startsWith prefix)", "Path entry");
        this.fileComparator = new PathIgnoringCaseComparator();
    }

    public ProjectsInputInfo calculateChecksum() throws IOException {
        boolean compareWithBaseline;
        long t0 = System.currentTimeMillis();
        String effectivePom = this.getEffectivePom(this.normalizedModelProvider.normalizedModel(this.project));
        SortedSet<Object> inputFiles = CacheUtils.isPom(this.project) ? Collections.emptySortedSet() : this.getInputFiles();
        SortedMap<String, String> dependenciesChecksum = this.getMutableDependencies();
        long t1 = System.currentTimeMillis();
        int count = 1 + inputFiles.size() + dependenciesChecksum.size();
        ArrayList<DigestItem> items = new ArrayList<DigestItem>(count);
        HashChecksum checksum = this.config.getHashFactory().createChecksum(count);
        Optional<Object> baselineHolder = Optional.empty();
        if (this.config.isBaselineDiffEnabled()) {
            baselineHolder = this.remoteCache.findBaselineBuild(this.project).map(b -> b.getDto().getProjectsInputInfo());
        }
        DigestItem effectivePomChecksum = DigestUtils.pom(checksum, effectivePom);
        items.add(effectivePomChecksum);
        boolean bl = compareWithBaseline = this.config.isBaselineDiffEnabled() && baselineHolder.isPresent();
        if (compareWithBaseline) {
            this.checkEffectivePomMatch((ProjectsInputInfo)baselineHolder.get(), effectivePomChecksum);
        }
        boolean sourcesMatched = true;
        for (Object file : inputFiles) {
            DigestItem digestItem = DigestUtils.file(checksum, this.baseDirPath, (Path)file);
            items.add(digestItem);
            if (!compareWithBaseline) continue;
            sourcesMatched &= this.checkItemMatchesBaseline((ProjectsInputInfo)baselineHolder.get(), digestItem);
        }
        if (compareWithBaseline) {
            LOGGER.info("Source code: {}", (Object)(sourcesMatched ? "MATCHED" : "OUT OF DATE"));
        }
        boolean dependenciesMatched = true;
        for (Map.Entry entry : dependenciesChecksum.entrySet()) {
            DigestItem dependencyDigest = DigestUtils.dependency(checksum, (String)entry.getKey(), (String)entry.getValue());
            items.add(dependencyDigest);
            if (!compareWithBaseline) continue;
            dependenciesMatched &= this.checkItemMatchesBaseline((ProjectsInputInfo)baselineHolder.get(), dependencyDigest);
        }
        if (compareWithBaseline) {
            LOGGER.info("Dependencies: {}", (Object)(dependenciesMatched ? "MATCHED" : "OUT OF DATE"));
        }
        ProjectsInputInfo projectsInputInfoType = new ProjectsInputInfo();
        projectsInputInfoType.setChecksum(checksum.digest());
        projectsInputInfoType.getItems().addAll(items);
        long l = System.currentTimeMillis();
        for (DigestItem item : projectsInputInfoType.getItems()) {
            LOGGER.debug("Hash calculated, item: {}, hash: {}", (Object)item.getType(), (Object)item.getHash());
        }
        LOGGER.info("Project inputs calculated in {} ms. {} checksum [{}] calculated in {} ms.", new Object[]{t1 - t0, this.config.getHashFactory().getAlgorithm(), projectsInputInfoType.getChecksum(), l - t1});
        return projectsInputInfoType;
    }

    private void checkEffectivePomMatch(ProjectsInputInfo baselineBuild, DigestItem effectivePomChecksum) {
        Optional<Object> pomHolder = Optional.empty();
        for (DigestItem it : baselineBuild.getItems()) {
            if (!it.getType().equals("pom")) continue;
            pomHolder = Optional.of(it);
            break;
        }
        if (pomHolder.isPresent()) {
            DigestItem pomItem = (DigestItem)pomHolder.get();
            boolean matches = StringUtils.equals((CharSequence)pomItem.getHash(), (CharSequence)effectivePomChecksum.getHash());
            if (!matches) {
                LOGGER.info("Mismatch in effective poms. Current: {}, remote: {}", (Object)effectivePomChecksum.getHash(), (Object)pomItem.getHash());
            }
            LOGGER.info("Effective pom: {}", (Object)(matches ? "MATCHED" : "OUT OF DATE"));
        }
    }

    private boolean checkItemMatchesBaseline(ProjectsInputInfo baselineBuild, DigestItem fileDigest) {
        Optional<Object> baselineFileDigest = Optional.empty();
        for (DigestItem it : baselineBuild.getItems()) {
            if (!it.getType().equals(fileDigest.getType()) || !fileDigest.getValue().equals(it.getValue().trim())) continue;
            baselineFileDigest = Optional.of(it);
            break;
        }
        boolean matched = false;
        if (baselineFileDigest.isPresent()) {
            String hash = ((DigestItem)baselineFileDigest.get()).getHash();
            matched = StringUtils.equals((CharSequence)hash, (CharSequence)fileDigest.getHash());
            if (!matched) {
                LOGGER.info("Mismatch in {}: {}. Local hash: {}, remote: {}", new Object[]{fileDigest.getType(), fileDigest.getValue(), fileDigest.getHash(), hash});
            }
        } else {
            LOGGER.info("Mismatch in {}: {}. Not found in remote cache", (Object)fileDigest.getType(), (Object)fileDigest.getValue());
        }
        return matched;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getEffectivePom(Model prototype) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        XmlStreamWriter writer = null;
        try {
            writer = WriterFactory.newXmlWriter((OutputStream)output);
            new MavenXpp3Writer().write((Writer)writer, prototype);
            String[] searchList = new String[]{this.baseDirPath.toString(), "\\", "windows", "linux"};
            String[] replacementList = new String[]{"", "/", "os.classifier", "os.classifier"};
            String string = StringUtils.replaceEachRepeatedly((String)output.toString(), (String[])searchList, (String[])replacementList);
            return string;
        }
        finally {
            IOUtil.close((Writer)writer);
        }
    }

    private SortedSet<Path> getInputFiles() {
        long start = System.currentTimeMillis();
        HashSet<WalkKey> visitedDirs = new HashSet<WalkKey>();
        ArrayList<Path> collectedFiles = new ArrayList<Path>();
        Build build = this.project.getBuild();
        boolean recursive = true;
        this.startWalk(Paths.get(build.getSourceDirectory(), new String[0]), this.dirGlob, true, collectedFiles, visitedDirs);
        for (Resource resource : build.getResources()) {
            this.startWalk(Paths.get(resource.getDirectory(), new String[0]), this.dirGlob, true, collectedFiles, visitedDirs);
        }
        this.startWalk(Paths.get(build.getTestSourceDirectory(), new String[0]), this.dirGlob, true, collectedFiles, visitedDirs);
        for (Object testResource : build.getTestResources()) {
            this.startWalk(Paths.get(testResource.getDirectory(), new String[0]), this.dirGlob, true, collectedFiles, visitedDirs);
        }
        Properties properties = this.project.getProperties();
        for (String string : properties.stringPropertyNames()) {
            if (!string.startsWith(CACHE_INPUT_NAME)) continue;
            String path = properties.getProperty(string);
            this.startWalk(Paths.get(path, new String[0]), this.dirGlob, true, collectedFiles, visitedDirs);
        }
        List<Include> includes = this.config.getGlobalIncludePaths();
        for (Include include : includes) {
            String path = include.getValue();
            String glob = (String)StringUtils.defaultIfEmpty((CharSequence)include.getGlob(), (CharSequence)this.dirGlob);
            this.startWalk(Paths.get(path, new String[0]), glob, include.isRecursive(), collectedFiles, visitedDirs);
        }
        long l = System.currentTimeMillis() - start;
        LOGGER.info("Scanning plugins configurations to find input files. Probing is {}", (Object)(this.processPlugins ? "enabled, values will be checked for presence in file system" : "disabled, only tags with attribute maven.build.cache.input=\"true\" will be added"));
        if (this.processPlugins) {
            this.collectFromPlugins(collectedFiles, visitedDirs);
        } else {
            LOGGER.info("Skipping check plugins scan (probing is disabled by config)");
        }
        long pluginsFinished = System.currentTimeMillis() - start - l;
        TreeSet<Path> sorted = new TreeSet<Path>(this.fileComparator);
        for (Path collectedFile : collectedFiles) {
            sorted.add(collectedFile.normalize().toAbsolutePath());
        }
        LOGGER.info("Found {} input files. Project dir processing: {}, plugins: {} millis", new Object[]{sorted.size(), l, pluginsFinished});
        LOGGER.debug("Src input: {}", sorted);
        return sorted;
    }

    private void startWalk(Path candidate, String glob, boolean recursive, List<Path> collectedFiles, Set<WalkKey> visitedDirs) {
        Path normalized = candidate.isAbsolute() ? candidate : this.baseDirPath.resolve(candidate);
        WalkKey key = new WalkKey(normalized = normalized.toAbsolutePath().normalize(), glob, recursive);
        if (visitedDirs.contains(key) || !Files.exists(normalized, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(normalized, new LinkOption[0])) {
            if (this.baseDirPath.startsWith(normalized)) {
                key = new WalkKey(normalized, glob, false);
            }
            try {
                this.walkDir(key, collectedFiles, visitedDirs);
                visitedDirs.add(key);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (!this.isFilteredOutSubpath(normalized)) {
            LOGGER.debug("Adding: {}", (Object)normalized);
            collectedFiles.add(normalized);
        }
    }

    private Path normalizedPath(String directory) {
        return Paths.get(directory, new String[0]).normalize();
    }

    private void collectFromPlugins(List<Path> files, HashSet<WalkKey> visitedDirs) {
        List plugins = this.project.getBuild().getPlugins();
        for (Plugin plugin : plugins) {
            PluginScanConfig scanConfig = this.config.getPluginDirScanConfig(plugin);
            if (scanConfig.isSkip()) {
                LOGGER.debug("Skipping plugin config scan (skip by config): {}", (Object)plugin.getArtifactId());
                continue;
            }
            Object configuration = plugin.getConfiguration();
            LOGGER.debug("Processing plugin config: {}", (Object)plugin.getArtifactId());
            if (configuration != null) {
                this.addInputsFromPluginConfigs(Xpp3DomUtils.getChildren(configuration), scanConfig, files, visitedDirs);
            }
            for (PluginExecution exec : plugin.getExecutions()) {
                PluginScanConfig executionScanConfig = this.config.getExecutionDirScanConfig(plugin, exec);
                PluginScanConfig mergedConfig = scanConfig.mergeWith(executionScanConfig);
                if (mergedConfig.isSkip()) {
                    LOGGER.debug("Skipping plugin execution config scan (skip by config): {}, execId: {}", (Object)plugin.getArtifactId(), (Object)exec.getId());
                    continue;
                }
                Object execConfiguration = exec.getConfiguration();
                LOGGER.debug("Processing plugin: {}, execution: {}", (Object)plugin.getArtifactId(), (Object)exec.getId());
                if (execConfiguration == null) continue;
                this.addInputsFromPluginConfigs(Xpp3DomUtils.getChildren(execConfiguration), mergedConfig, files, visitedDirs);
            }
        }
    }

    private Path walkDir(final WalkKey key, final List<Path> collectedFiles, final Set<WalkKey> visitedDirs) throws IOException {
        return Files.walkFileTree(key.getPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                WalkKey currentDirKey = new WalkKey(path.toAbsolutePath().normalize(), key.getGlob(), key.isRecursive());
                if (MavenProjectInput.isHidden(path)) {
                    LOGGER.debug("Skipping subtree (hidden): {}", (Object)path);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (!MavenProjectInput.isReadable(path)) {
                    LOGGER.debug("Skipping subtree (not readable): {}", (Object)path);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (MavenProjectInput.this.isFilteredOutSubpath(path)) {
                    LOGGER.debug("Skipping subtree (blacklisted): {}", (Object)path);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (visitedDirs.contains(currentDirKey)) {
                    LOGGER.debug("Skipping subtree (visited): {}", (Object)path);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                MavenProjectInput.walkDirectoryFiles(path, collectedFiles, key.getGlob(), entry -> MavenProjectInput.this.filteredOutPaths.stream().anyMatch(it -> it.getFileName().equals(entry.getFileName())));
                if (!key.isRecursive()) {
                    LOGGER.debug("Skipping subtree (non recursive): {}", (Object)path);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                LOGGER.debug("Visiting subtree: {}", (Object)path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path path, IOException exc) throws IOException {
                LOGGER.debug("Skipping subtree (exception: {}): {}", (Object)exc, (Object)path);
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
    }

    private void addInputsFromPluginConfigs(Object[] configurationChildren, PluginScanConfig scanConfig, List<Path> files, HashSet<WalkKey> visitedDirs) {
        if (configurationChildren == null) {
            return;
        }
        for (Object configChild : configurationChildren) {
            String tagName = Xpp3DomUtils.getName(configChild);
            String tagValue = Xpp3DomUtils.getValue(configChild);
            if (!scanConfig.accept(tagName)) {
                LOGGER.debug("Skipping property (scan config)): {}, value: {}", (Object)tagName, (Object)StringUtils.stripToEmpty((String)tagValue));
                continue;
            }
            LOGGER.debug("Checking xml tag. Tag: {}, value: {}", (Object)tagName, (Object)StringUtils.stripToEmpty((String)tagValue));
            this.addInputsFromPluginConfigs(Xpp3DomUtils.getChildren(configChild), scanConfig, files, visitedDirs);
            ScanConfigProperties propertyConfig = scanConfig.getTagScanProperties(tagName);
            String glob = (String)StringUtils.defaultIfEmpty((CharSequence)propertyConfig.getGlob(), (CharSequence)this.dirGlob);
            if ("true".equals(Xpp3DomUtils.getAttribute(configChild, CACHE_INPUT_NAME))) {
                LOGGER.info("Found tag marked with {} attribute. Tag: {}, value: {}", new Object[]{CACHE_INPUT_NAME, tagName, tagValue});
                this.startWalk(Paths.get(tagValue, new String[0]), glob, propertyConfig.isRecursive(), files, visitedDirs);
                continue;
            }
            Path candidate = this.getPathOrNull(tagValue);
            if (candidate == null) continue;
            this.startWalk(candidate, glob, propertyConfig.isRecursive(), files, visitedDirs);
            if (!"descriptorRef".equals(tagName)) continue;
            this.startWalk(Paths.get(tagValue + ".xml", new String[0]), glob, propertyConfig.isRecursive(), files, visitedDirs);
        }
    }

    private Path getPathOrNull(String text) {
        if (!StringUtils.isBlank((CharSequence)text)) {
            if (StringUtils.equalsAnyIgnoreCase((CharSequence)text, (CharSequence[])new CharSequence[]{"true", "false", "utf-8", "null", "\\"}) || StringUtils.contains((CharSequence)text, (CharSequence)"*") || StringUtils.contains((CharSequence)text, (CharSequence)":") && !StringUtils.contains((CharSequence)text, (CharSequence)":\\") || StringUtils.startsWithAny((CharSequence)text, (CharSequence[])new CharSequence[]{"com.", "org.", "io.", "java.", "javax."}) || StringUtils.startsWithAny((CharSequence)text, (CharSequence[])new CharSequence[]{"${env."}) || StringUtils.startsWithAny((CharSequence)text, (CharSequence[])new CharSequence[]{"http:", "https:", "scm:", "ssh:", "git:", "svn:", "cp:", "classpath:"})) {
                LOGGER.debug("Skipping directory (blacklisted literal): {}", (Object)text);
            } else if (StringUtils.startsWithAny((CharSequence)text, (CharSequence[])new CharSequence[]{this.tmpDir})) {
                LOGGER.debug("Skipping directory (temp dir): {}", (Object)text);
            } else {
                try {
                    return Paths.get(text, new String[0]);
                }
                catch (Exception ignore) {
                    LOGGER.debug("Skipping directory (invalid path): {}", (Object)text);
                }
            }
        }
        return null;
    }

    static void walkDirectoryFiles(Path dir, List<Path> collectedFiles, String glob, Predicate<Path> mustBeSkipped) {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, glob);){
            for (Path entry : stream) {
                File file;
                if (mustBeSkipped.test(entry) || !(file = entry.toFile()).isFile() || MavenProjectInput.isHidden(entry) || !MavenProjectInput.isReadable(entry)) continue;
                collectedFiles.add(entry);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot process directory: " + dir, e);
        }
    }

    private static boolean isHidden(Path entry) throws IOException {
        return Files.isHidden(entry) || entry.toFile().getName().startsWith(".");
    }

    private static boolean isReadable(Path entry) throws IOException {
        return Files.isReadable(entry);
    }

    private boolean isFilteredOutSubpath(Path path) {
        Path normalized = path.normalize();
        for (Path filteredOutDir : this.filteredOutPaths) {
            if (!normalized.startsWith(filteredOutDir)) continue;
            return true;
        }
        return false;
    }

    private SortedMap<String, String> getMutableDependencies() throws IOException {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Dependency dependency : this.project.getDependencies()) {
            String projectHash;
            if (CacheUtils.isPom(dependency)) continue;
            MavenProject dependencyProject = this.multiModuleSupport.tryToResolveProject(dependency.getGroupId(), dependency.getArtifactId(), dependency.getVersion()).orElse(null);
            boolean isSnapshot = CacheUtils.isSnapshot(dependency.getVersion());
            if (dependencyProject == null && !isSnapshot) continue;
            if (dependencyProject != null) {
                projectHash = this.projectInputCalculator.calculateInput(dependencyProject).getChecksum();
            } else {
                DigestItem resolved = this.resolveArtifact(this.repoSystem.createDependencyArtifact(dependency), false);
                projectHash = resolved.getHash();
            }
            result.put(KeyUtils.getVersionlessArtifactKey(this.repoSystem.createDependencyArtifact(dependency)), projectHash);
        }
        return result;
    }

    @Nonnull
    private DigestItem resolveArtifact(Artifact dependencyArtifact, boolean isOffline) throws IOException {
        ArtifactResolutionRequest request = new ArtifactResolutionRequest().setArtifact(dependencyArtifact).setResolveRoot(true).setResolveTransitively(false).setLocalRepository(this.session.getLocalRepository()).setRemoteRepositories(this.project.getRemoteArtifactRepositories()).setOffline(this.session.isOffline() || isOffline).setForceUpdate(this.session.getRequest().isUpdateSnapshots()).setServers(this.session.getRequest().getServers()).setMirrors(this.session.getRequest().getMirrors()).setProxies(this.session.getRequest().getProxies());
        ArtifactResolutionResult result = this.repoSystem.resolve(request);
        if (!result.isSuccess()) {
            throw new DependencyNotResolvedException("Cannot resolve in-project dependency: " + dependencyArtifact);
        }
        if (!result.getMissingArtifacts().isEmpty()) {
            throw new DependencyNotResolvedException("Cannot resolve artifact: " + dependencyArtifact + ", missing: " + result.getMissingArtifacts());
        }
        if (result.getArtifacts().size() != 1) {
            throw new IllegalStateException("Unexpected number of artifacts returned. Requested: " + dependencyArtifact + ", expected: 1, actual: " + result.getArtifacts());
        }
        Artifact resolved = (Artifact)result.getArtifacts().iterator().next();
        HashAlgorithm algorithm = this.config.getHashFactory().createAlgorithm();
        String hash = algorithm.hash(resolved.getFile().toPath());
        return DtoUtils.createDigestedFile(resolved, hash);
    }

    public static boolean isSkipCache(MavenProject project) {
        return Boolean.parseBoolean(project.getProperties().getProperty("maven.build.cache.skipCache", "false"));
    }

    public static boolean isRestoreGeneratedSources(MavenProject project) {
        return Boolean.parseBoolean(project.getProperties().getProperty("maven.build.cache.restoreGeneratedSources", "true"));
    }

    public static class PathIgnoringCaseComparator
    implements Comparator<Path> {
        @Override
        public int compare(Path f1, Path f2) {
            String s1 = f1.toAbsolutePath().toString();
            String s2 = f2.toAbsolutePath().toString();
            if (File.separator.equals("\\")) {
                s1 = s1.replaceAll("\\\\", "/");
                s2 = s2.replaceAll("\\\\", "/");
            }
            return s1.compareToIgnoreCase(s2);
        }
    }
}

