/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.hash;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.Path;
import net.openhft.hashing.LongHashFunction;
import org.apache.maven.buildcache.hash.Hash;
import org.apache.maven.buildcache.hash.HexUtils;

public class XX
implements Hash.Factory {
    static final LongHashFunction INSTANCE = LongHashFunction.xx();

    @Override
    public String getAlgorithm() {
        return "XX";
    }

    @Override
    public Hash.Algorithm algorithm() {
        return new Algorithm();
    }

    @Override
    public Hash.Checksum checksum(int count) {
        return new Checksum(ByteBuffer.allocate(XX.capacity(count)));
    }

    static int capacity(int count) {
        return count * 64 / 8;
    }

    static class Algorithm
    implements Hash.Algorithm {
        Algorithm() {
        }

        @Override
        public byte[] hash(byte[] array) {
            return HexUtils.toByteArray(INSTANCE.hashBytes(array));
        }

        @Override
        public byte[] hash(Path path) throws IOException {
            return this.hash(Files.readAllBytes(path));
        }
    }

    static class Checksum
    implements Hash.Checksum {
        private final ByteBuffer buffer;

        Checksum(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        @Override
        public void update(byte[] hash) {
            this.buffer.put(hash);
        }

        @Override
        public byte[] digest() {
            return HexUtils.toByteArray(INSTANCE.hashBytes(this.buffer, 0, this.buffer.position()));
        }
    }
}

