/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.hash;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.apache.maven.buildcache.hash.CloseableBuffer;
import org.apache.maven.buildcache.hash.Hash;
import org.apache.maven.buildcache.hash.HexUtils;
import org.apache.maven.buildcache.hash.ThreadLocalBuffer;
import org.apache.maven.buildcache.hash.XX;

public class XXMM
implements Hash.Factory {
    private static final ThreadLocal<CloseableBuffer> BUFFER = new ThreadLocal();

    @Override
    public String getAlgorithm() {
        return "XXMM";
    }

    @Override
    public Hash.Algorithm algorithm() {
        return new Algorithm();
    }

    @Override
    public Hash.Checksum checksum(int count) {
        return new XX.Checksum(ThreadLocalBuffer.get(BUFFER, XX.capacity(count)));
    }

    private static class Algorithm
    extends XX.Algorithm {
        private Algorithm() {
        }

        @Override
        public byte[] hash(Path path) throws IOException {
            try (FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);){
                CloseableBuffer buffer = CloseableBuffer.mappedBuffer(channel, FileChannel.MapMode.READ_ONLY);
                try {
                    byte[] byArray = HexUtils.toByteArray(XX.INSTANCE.hashBytes(buffer.getBuffer()));
                    if (buffer != null) {
                        buffer.close();
                    }
                    return byArray;
                }
                catch (Throwable throwable) {
                    if (buffer != null) {
                        try {
                            buffer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
        }
    }
}

