/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.checksum;

import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class KeyUtils {
    private static final String SEPARATOR = ":";

    public static String getProjectKey(MavenProject project) {
        return KeyUtils.getProjectKey(project.getGroupId(), project.getArtifactId(), project.getVersion());
    }

    public static String getProjectKey(String groupId, String artifactId, String version) {
        return StringUtils.joinWith((String)SEPARATOR, (Object[])new Object[]{groupId, artifactId, version});
    }

    public static String getVersionlessProjectKey(MavenProject project) {
        return StringUtils.joinWith((String)SEPARATOR, (Object[])new Object[]{project.getGroupId(), project.getArtifactId()});
    }

    public static String getArtifactKey(org.apache.maven.buildcache.xml.build.Artifact artifact) {
        return KeyUtils.getArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier(), artifact.getVersion());
    }

    public static String getVersionlessArtifactKey(Artifact artifact) {
        return KeyUtils.getVersionlessArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier());
    }

    public static String getArtifactKey(org.apache.maven.buildcache.xml.build.Artifact artifact, String type) {
        return KeyUtils.getArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), type, artifact.getClassifier(), artifact.getVersion());
    }

    public static String getArtifactKey(Artifact artifact) {
        return KeyUtils.getArtifactKey(artifact.getGroupId(), artifact.getArtifactId(), artifact.getType(), artifact.getClassifier(), artifact.getVersion());
    }

    public static String getArtifactKey(String groupId, String artifactId, String type, String classifier, String version) {
        if (classifier != null) {
            return StringUtils.joinWith((String)SEPARATOR, (Object[])new Object[]{groupId, artifactId, type, classifier, version});
        }
        return StringUtils.joinWith((String)SEPARATOR, (Object[])new Object[]{groupId, artifactId, type, version});
    }

    public static String getVersionlessArtifactKey(String groupId, String artifactId, String type, String classifier) {
        if (classifier != null) {
            return StringUtils.joinWith((String)SEPARATOR, (Object[])new Object[]{groupId, artifactId, type, classifier});
        }
        return StringUtils.joinWith((String)SEPARATOR, (Object[])new Object[]{groupId, artifactId, type});
    }
}

