/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.checksum.exclude;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.buildcache.checksum.exclude.Exclusion;
import org.apache.maven.buildcache.xml.CacheConfig;
import org.apache.maven.buildcache.xml.config.Exclude;
import org.apache.maven.model.Build;
import org.apache.maven.project.MavenProject;

public class ExclusionResolver {
    private static final String PROJECT_PROPERTY_EXCLUDE_PREFIX = "maven.build.cache.exclude";
    public static final String PROJECT_PROPERTY_EXCLUDE_VALUE = "maven.build.cache.exclude.value";
    public static final String PROJECT_PROPERTY_EXCLUDE_GLOB = "maven.build.cache.exclude.glob";
    public static final String PROJECT_PROPERTY_EXCLUDE_ENTRY_TYPE = "maven.build.cache.exclude.entryType";
    public static final String PROJECT_PROPERTY_EXCLUDE_MATCHER_TYPE = "maven.build.cache.exclude.matcherType";
    private final List<Exclusion> directoryExclusions = new ArrayList<Exclusion>();
    private final List<Exclusion> filesExclusions = new ArrayList<Exclusion>();
    private final Set<Path> directFileExclusions = new HashSet<Path>();
    private final Path projectBaseDirectory;

    public ExclusionResolver(MavenProject project, CacheConfig config) {
        Path baseDirectory;
        this.addDefaultExcludes(project);
        this.projectBaseDirectory = baseDirectory = project.getBasedir().toPath().toAbsolutePath();
        List<Exclude> excludes = config.getGlobalExcludePaths();
        for (Exclude exclude : excludes) {
            this.addExclusion(baseDirectory, exclude);
        }
        Properties properties = project.getProperties();
        HashMap<String, Exclude> propertyMap = new HashMap<String, Exclude>();
        for (String propertyName : properties.stringPropertyNames()) {
            Exclude exclude;
            String propertyKey;
            if (propertyName.startsWith(PROJECT_PROPERTY_EXCLUDE_VALUE)) {
                propertyKey = propertyName.substring(PROJECT_PROPERTY_EXCLUDE_VALUE.length());
                exclude = propertyMap.computeIfAbsent(propertyKey, key -> new Exclude());
                exclude.setValue(properties.getProperty(propertyName));
                continue;
            }
            if (propertyName.startsWith(PROJECT_PROPERTY_EXCLUDE_GLOB)) {
                propertyKey = propertyName.substring(PROJECT_PROPERTY_EXCLUDE_GLOB.length());
                exclude = propertyMap.computeIfAbsent(propertyKey, key -> new Exclude());
                exclude.setGlob(properties.getProperty(propertyName));
                continue;
            }
            if (propertyName.startsWith(PROJECT_PROPERTY_EXCLUDE_ENTRY_TYPE)) {
                propertyKey = propertyName.substring(PROJECT_PROPERTY_EXCLUDE_ENTRY_TYPE.length());
                exclude = propertyMap.computeIfAbsent(propertyKey, key -> new Exclude());
                exclude.setEntryType(properties.getProperty(propertyName));
                continue;
            }
            if (!propertyName.startsWith(PROJECT_PROPERTY_EXCLUDE_MATCHER_TYPE)) continue;
            propertyKey = propertyName.substring(PROJECT_PROPERTY_EXCLUDE_MATCHER_TYPE.length());
            exclude = propertyMap.computeIfAbsent(propertyKey, key -> new Exclude());
            exclude.setMatcherType(properties.getProperty(propertyName));
        }
        for (Exclude propertyExclude : propertyMap.values()) {
            this.addExclusion(baseDirectory, propertyExclude);
        }
    }

    private void addExclusion(Path baseDirectory, Exclude exclude) {
        block7: {
            Exclusion exclusion;
            block6: {
                exclusion = new Exclusion(baseDirectory, exclude);
                if (!Files.exists(exclusion.getAbsolutePath(), new LinkOption[0])) {
                    return;
                }
                if (!Files.isDirectory(exclusion.getAbsolutePath(), new LinkOption[0])) break block6;
                switch (exclusion.getEntryType()) {
                    case ALL: {
                        this.directoryExclusions.add(exclusion);
                        this.filesExclusions.add(exclusion);
                        break block7;
                    }
                    case FILE: {
                        this.filesExclusions.add(exclusion);
                        break block7;
                    }
                    case DIRECTORY: {
                        this.directoryExclusions.add(exclusion);
                        break block7;
                    }
                    default: {
                        throw new RuntimeException("Exclusion range not handled.");
                    }
                }
            }
            this.directFileExclusions.add(exclusion.getAbsolutePath());
        }
    }

    private void addDefaultExcludes(MavenProject project) {
        Build build = project.getBuild();
        Path buildDirectoryPath = this.absoluteNormalizedPath(build.getDirectory());
        Path outputDirectoryPath = this.absoluteNormalizedPath(build.getOutputDirectory());
        Path testOutputDirectoryPath = this.absoluteNormalizedPath(build.getTestOutputDirectory());
        this.addFileAndDirectoryExclusion(new Exclusion(buildDirectoryPath, Exclusion.MatcherType.FILENAME, Exclusion.EntryType.ALL));
        if (!outputDirectoryPath.startsWith(buildDirectoryPath)) {
            this.addFileAndDirectoryExclusion(new Exclusion(outputDirectoryPath, Exclusion.MatcherType.FILENAME, Exclusion.EntryType.ALL));
        }
        if (!testOutputDirectoryPath.startsWith(buildDirectoryPath)) {
            this.addFileAndDirectoryExclusion(new Exclusion(testOutputDirectoryPath, Exclusion.MatcherType.FILENAME, Exclusion.EntryType.ALL));
        }
    }

    private void addFileAndDirectoryExclusion(Exclusion exclusion) {
        this.directoryExclusions.add(exclusion);
        this.filesExclusions.add(exclusion);
    }

    private Path absoluteNormalizedPath(String directory) {
        return Paths.get(directory, new String[0]).toAbsolutePath().normalize();
    }

    public boolean excludesPath(Path entryAbsolutePath) {
        boolean isDirectory = Files.isDirectory(entryAbsolutePath, new LinkOption[0]);
        if (!isDirectory && this.directFileExclusions.contains(entryAbsolutePath)) {
            return true;
        }
        List<Exclusion> exclusionList = isDirectory ? this.directoryExclusions : this.filesExclusions;
        for (Exclusion exclusion : exclusionList) {
            if (!exclusion.excludesPath(this.projectBaseDirectory, entryAbsolutePath)) continue;
            return true;
        }
        return false;
    }
}

