/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache;

import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.maven.execution.AbstractExecutionListener;
import org.apache.maven.execution.ExecutionEvent;
import org.apache.maven.execution.ExecutionListener;

class ChainedListener
extends AbstractExecutionListener {
    private final ExecutionListener delegate;
    private final CopyOnWriteArrayList<ExecutionListener> chainedListeners = new CopyOnWriteArrayList();

    ChainedListener(ExecutionListener delegate) {
        this.delegate = delegate;
    }

    public boolean chainListener(ExecutionListener listener) {
        return this.chainedListeners.addIfAbsent(listener);
    }

    public void projectDiscoveryStarted(ExecutionEvent event) {
        this.delegate.projectDiscoveryStarted(event);
        this.chainedListeners.forEach(listener -> listener.projectDiscoveryStarted(event));
    }

    public void sessionStarted(ExecutionEvent event) {
        this.delegate.sessionStarted(event);
        this.chainedListeners.forEach(listener -> listener.sessionStarted(event));
    }

    public void sessionEnded(ExecutionEvent event) {
        this.delegate.sessionEnded(event);
        this.chainedListeners.forEach(listener -> listener.sessionEnded(event));
    }

    public void projectSkipped(ExecutionEvent event) {
        this.delegate.projectSkipped(event);
        this.chainedListeners.forEach(listener -> listener.projectSkipped(event));
    }

    public void projectStarted(ExecutionEvent event) {
        this.delegate.projectStarted(event);
        this.chainedListeners.forEach(listener -> listener.projectStarted(event));
    }

    public void projectSucceeded(ExecutionEvent event) {
        this.delegate.projectSucceeded(event);
        this.chainedListeners.forEach(listener -> listener.projectSucceeded(event));
    }

    public void projectFailed(ExecutionEvent event) {
        this.delegate.projectFailed(event);
        this.chainedListeners.forEach(listener -> listener.projectFailed(event));
    }

    public void forkStarted(ExecutionEvent event) {
        this.delegate.forkStarted(event);
        this.chainedListeners.forEach(listener -> listener.forkStarted(event));
    }

    public void forkSucceeded(ExecutionEvent event) {
        this.delegate.forkSucceeded(event);
        this.chainedListeners.forEach(listener -> listener.forkSucceeded(event));
    }

    public void forkFailed(ExecutionEvent event) {
        this.delegate.forkFailed(event);
        this.chainedListeners.forEach(listener -> listener.forkFailed(event));
    }

    public void mojoSkipped(ExecutionEvent event) {
        this.delegate.mojoSkipped(event);
        this.chainedListeners.forEach(listener -> listener.mojoSkipped(event));
    }

    public void mojoStarted(ExecutionEvent event) {
        this.delegate.mojoStarted(event);
        this.chainedListeners.forEach(listener -> listener.mojoStarted(event));
    }

    public void mojoSucceeded(ExecutionEvent event) {
        this.delegate.mojoSucceeded(event);
        this.chainedListeners.forEach(listener -> listener.mojoSucceeded(event));
    }

    public void mojoFailed(ExecutionEvent event) {
        this.delegate.mojoFailed(event);
        this.chainedListeners.forEach(listener -> listener.mojoFailed(event));
    }

    public void forkedProjectStarted(ExecutionEvent event) {
        this.delegate.forkedProjectStarted(event);
        this.chainedListeners.forEach(listener -> listener.forkedProjectStarted(event));
    }

    public void forkedProjectSucceeded(ExecutionEvent event) {
        this.delegate.forkedProjectSucceeded(event);
        this.chainedListeners.forEach(listener -> listener.forkedProjectSucceeded(event));
    }

    public void forkedProjectFailed(ExecutionEvent event) {
        this.delegate.forkedProjectFailed(event);
        this.chainedListeners.forEach(listener -> listener.forkedProjectFailed(event));
    }
}

