/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.checksum;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Strings;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.buildcache.CacheUtils;
import org.apache.maven.buildcache.MultiModuleSupport;
import org.apache.maven.buildcache.NormalizedModelProvider;
import org.apache.maven.buildcache.PluginScanConfig;
import org.apache.maven.buildcache.ProjectInputCalculator;
import org.apache.maven.buildcache.RemoteCacheRepository;
import org.apache.maven.buildcache.ScanConfigProperties;
import org.apache.maven.buildcache.Xpp3DomUtils;
import org.apache.maven.buildcache.checksum.DependencyNotResolvedException;
import org.apache.maven.buildcache.checksum.DigestUtils;
import org.apache.maven.buildcache.checksum.KeyUtils;
import org.apache.maven.buildcache.checksum.WalkKey;
import org.apache.maven.buildcache.checksum.exclude.ExclusionResolver;
import org.apache.maven.buildcache.hash.HashAlgorithm;
import org.apache.maven.buildcache.hash.HashChecksum;
import org.apache.maven.buildcache.xml.CacheConfig;
import org.apache.maven.buildcache.xml.DtoUtils;
import org.apache.maven.buildcache.xml.build.DigestItem;
import org.apache.maven.buildcache.xml.build.ProjectsInputInfo;
import org.apache.maven.buildcache.xml.config.Include;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Build;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Exclusion;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.DefaultArtifactType;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectInput {
    public static final String CACHE_IMPLEMENTATION_VERSION = "v1.1";
    private static final String CACHE_INPUT_GLOB_NAME = "maven.build.cache.input.glob";
    private static final String CACHE_INPUT_NAME = "maven.build.cache.input";
    private static final String CACHE_PROCESS_PLUGINS = "maven.build.cache.processPlugins";
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenProjectInput.class);
    private final MavenProject project;
    private final MavenSession session;
    private final RemoteCacheRepository remoteCache;
    private final RepositorySystem repoSystem;
    private final CacheConfig config;
    private final PathIgnoringCaseComparator fileComparator;
    private final NormalizedModelProvider normalizedModelProvider;
    private final MultiModuleSupport multiModuleSupport;
    private final ProjectInputCalculator projectInputCalculator;
    private final Path baseDirPath;
    private final ArtifactHandlerManager artifactHandlerManager;
    private final String projectGlob;
    private final ExclusionResolver exclusionResolver;
    private final boolean processPlugins;
    private final String tmpDir;

    public MavenProjectInput(MavenProject project, NormalizedModelProvider normalizedModelProvider, MultiModuleSupport multiModuleSupport, ProjectInputCalculator projectInputCalculator, MavenSession session, CacheConfig config, RepositorySystem repoSystem, RemoteCacheRepository remoteCache, ArtifactHandlerManager artifactHandlerManager) {
        this.project = project;
        this.normalizedModelProvider = normalizedModelProvider;
        this.multiModuleSupport = multiModuleSupport;
        this.projectInputCalculator = projectInputCalculator;
        this.session = session;
        this.config = config;
        this.baseDirPath = project.getBasedir().toPath().toAbsolutePath();
        this.repoSystem = repoSystem;
        this.remoteCache = remoteCache;
        Properties properties = project.getProperties();
        this.projectGlob = properties.getProperty(CACHE_INPUT_GLOB_NAME, config.getDefaultGlob());
        this.processPlugins = Boolean.parseBoolean(properties.getProperty(CACHE_PROCESS_PLUGINS, config.isProcessPlugins()));
        this.tmpDir = System.getProperty("java.io.tmpdir");
        this.exclusionResolver = new ExclusionResolver(project, config);
        this.fileComparator = new PathIgnoringCaseComparator();
        this.artifactHandlerManager = artifactHandlerManager;
    }

    public ProjectsInputInfo calculateChecksum() throws IOException {
        boolean compareWithBaseline;
        long t0 = System.currentTimeMillis();
        String effectivePom = this.getEffectivePom(this.normalizedModelProvider.normalizedModel(this.project));
        SortedSet<Object> inputFiles = CacheUtils.isPom(this.project) ? Collections.emptySortedSet() : this.getInputFiles();
        SortedMap<String, String> dependenciesChecksum = this.getMutableDependencies();
        SortedMap<String, String> pluginDependenciesChecksum = this.getMutablePluginDependencies();
        long t1 = System.currentTimeMillis();
        int count = 1 + (this.config.calculateProjectVersionChecksum() ? 1 : 0) + 2 * inputFiles.size() + dependenciesChecksum.size() + pluginDependenciesChecksum.size();
        ArrayList<DigestItem> items = new ArrayList<DigestItem>(count);
        HashChecksum checksum = this.config.getHashFactory().createChecksum(count);
        Optional<Object> baselineHolder = Optional.empty();
        if (this.config.isBaselineDiffEnabled()) {
            baselineHolder = this.remoteCache.findBaselineBuild(this.project).map(b -> b.getDto().getProjectsInputInfo());
        }
        if (this.config.calculateProjectVersionChecksum()) {
            DigestItem projectVersion = new DigestItem();
            projectVersion.setType("version");
            projectVersion.setIsText("yes");
            projectVersion.setValue(this.project.getVersion());
            items.add(projectVersion);
            checksum.update(this.project.getVersion().getBytes(StandardCharsets.UTF_8));
        }
        DigestItem effectivePomChecksum = DigestUtils.pom(checksum, effectivePom);
        items.add(effectivePomChecksum);
        boolean bl = compareWithBaseline = this.config.isBaselineDiffEnabled() && baselineHolder.isPresent();
        if (compareWithBaseline) {
            this.checkEffectivePomMatch((ProjectsInputInfo)baselineHolder.get(), effectivePomChecksum);
        }
        boolean sourcesMatched = true;
        for (Object file : inputFiles) {
            DigestItem digestItem = DigestUtils.file(checksum, this.baseDirPath, (Path)file);
            items.add(digestItem);
            if (!compareWithBaseline) continue;
            sourcesMatched &= this.checkItemMatchesBaseline((ProjectsInputInfo)baselineHolder.get(), digestItem);
        }
        if (compareWithBaseline) {
            LOGGER.info("Source code: {}", (Object)(sourcesMatched ? "MATCHED" : "OUT OF DATE"));
        }
        boolean dependenciesMatched = true;
        for (Map.Entry entry : dependenciesChecksum.entrySet()) {
            DigestItem digestItem = DigestUtils.dependency(checksum, (String)entry.getKey(), (String)entry.getValue());
            items.add(digestItem);
            if (!compareWithBaseline) continue;
            dependenciesMatched &= this.checkItemMatchesBaseline((ProjectsInputInfo)baselineHolder.get(), digestItem);
        }
        if (compareWithBaseline) {
            LOGGER.info("Dependencies: {}", (Object)(dependenciesMatched ? "MATCHED" : "OUT OF DATE"));
        }
        boolean pluginDependenciesMatched = true;
        for (Map.Entry<String, String> entry : pluginDependenciesChecksum.entrySet()) {
            DigestItem dependencyDigest = DigestUtils.pluginDependency(checksum, entry.getKey(), entry.getValue());
            items.add(dependencyDigest);
            if (!compareWithBaseline) continue;
            pluginDependenciesMatched &= this.checkItemMatchesBaseline((ProjectsInputInfo)baselineHolder.get(), dependencyDigest);
        }
        if (compareWithBaseline) {
            LOGGER.info("Plugin dependencies: {}", (Object)(pluginDependenciesMatched ? "MATCHED" : "OUT OF DATE"));
        }
        ProjectsInputInfo projectsInputInfo = new ProjectsInputInfo();
        projectsInputInfo.setChecksum(checksum.digest());
        projectsInputInfo.getItems().addAll(items);
        long l = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            for (DigestItem item : projectsInputInfo.getItems()) {
                LOGGER.debug("Hash calculated, item: {}, hash: {}", (Object)item.getType(), (Object)item.getHash());
            }
        }
        LOGGER.info("Project inputs calculated in {} ms. {} checksum [{}] calculated in {} ms.", new Object[]{t1 - t0, this.config.getHashFactory().getAlgorithm(), projectsInputInfo.getChecksum(), l - t1});
        return projectsInputInfo;
    }

    private void checkEffectivePomMatch(ProjectsInputInfo baselineBuild, DigestItem effectivePomChecksum) {
        Optional<Object> pomHolder = Optional.empty();
        for (DigestItem it : baselineBuild.getItems()) {
            if (!it.getType().equals("pom")) continue;
            pomHolder = Optional.of(it);
            break;
        }
        if (pomHolder.isPresent()) {
            DigestItem pomItem = (DigestItem)pomHolder.get();
            boolean matches = Strings.CS.equals(pomItem.getHash(), effectivePomChecksum.getHash());
            if (!matches) {
                LOGGER.info("Mismatch in effective poms. Current: {}, remote: {}", (Object)effectivePomChecksum.getHash(), (Object)pomItem.getHash());
            }
            LOGGER.info("Effective pom: {}", (Object)(matches ? "MATCHED" : "OUT OF DATE"));
        }
    }

    private boolean checkItemMatchesBaseline(ProjectsInputInfo baselineBuild, DigestItem fileDigest) {
        Optional<Object> baselineFileDigest = Optional.empty();
        for (DigestItem it : baselineBuild.getItems()) {
            if (!it.getType().equals(fileDigest.getType()) || !fileDigest.getValue().equals(it.getValue().trim())) continue;
            baselineFileDigest = Optional.of(it);
            break;
        }
        boolean matched = false;
        if (baselineFileDigest.isPresent()) {
            String hash = ((DigestItem)baselineFileDigest.get()).getHash();
            matched = Strings.CS.equals(hash, fileDigest.getHash());
            if (!matched) {
                LOGGER.info("Mismatch in {}: {}. Local hash: {}, remote: {}", new Object[]{fileDigest.getType(), fileDigest.getValue(), fileDigest.getHash(), hash});
            }
        } else {
            LOGGER.info("Mismatch in {}: {}. Not found in remote cache", (Object)fileDigest.getType(), (Object)fileDigest.getValue());
        }
        return matched;
    }

    private String getEffectivePom(Model prototype) throws IOException {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        try (XmlStreamWriter writer = WriterFactory.newXmlWriter((OutputStream)output);){
            new MavenXpp3Writer().write((Writer)writer, prototype);
            String[] searchList = new String[]{this.baseDirPath.toString(), "\\", "windows", "linux"};
            String[] replacementList = new String[]{"", "/", "os.classifier", "os.classifier"};
            String string = StringUtils.replaceEachRepeatedly((String)output.toString(), (String[])searchList, (String[])replacementList);
            return string;
        }
    }

    private SortedSet<Path> getInputFiles() {
        long start = System.currentTimeMillis();
        HashSet<WalkKey> visitedDirs = new HashSet<WalkKey>();
        ArrayList<Path> collectedFiles = new ArrayList<Path>();
        Build build = this.project.getBuild();
        boolean recursive = true;
        this.startWalk(Paths.get(build.getSourceDirectory(), new String[0]), this.projectGlob, true, collectedFiles, visitedDirs);
        for (Resource resource : build.getResources()) {
            this.startWalk(Paths.get(resource.getDirectory(), new String[0]), this.projectGlob, true, collectedFiles, visitedDirs);
        }
        this.startWalk(Paths.get(build.getTestSourceDirectory(), new String[0]), this.projectGlob, true, collectedFiles, visitedDirs);
        for (Object testResource : build.getTestResources()) {
            this.startWalk(Paths.get(testResource.getDirectory(), new String[0]), this.projectGlob, true, collectedFiles, visitedDirs);
        }
        Properties properties = this.project.getProperties();
        for (String string : properties.stringPropertyNames()) {
            if (!string.startsWith(CACHE_INPUT_NAME) || CACHE_INPUT_GLOB_NAME.equals(string)) continue;
            String path = properties.getProperty(string);
            this.startWalk(Paths.get(path, new String[0]), this.projectGlob, true, collectedFiles, visitedDirs);
        }
        List<Include> includes = this.config.getGlobalIncludePaths();
        for (Include include : includes) {
            String path = include.getValue();
            String glob = (String)StringUtils.defaultIfEmpty((CharSequence)include.getGlob(), (CharSequence)this.projectGlob);
            this.startWalk(Paths.get(path, new String[0]), glob, include.isRecursive(), collectedFiles, visitedDirs);
        }
        long l = System.currentTimeMillis() - start;
        LOGGER.info("Scanning plugins configurations to find input files. Probing is {}", (Object)(this.processPlugins ? "enabled, values will be checked for presence in file system" : "disabled, only tags with attribute maven.build.cache.input=\"true\" will be added"));
        if (this.processPlugins) {
            this.collectFromPlugins(collectedFiles, visitedDirs);
        } else {
            LOGGER.info("Skipping check plugins scan (probing is disabled by config)");
        }
        long pluginsFinished = System.currentTimeMillis() - start - l;
        TreeSet<Path> sorted = new TreeSet<Path>(this.fileComparator);
        for (Path collectedFile : collectedFiles) {
            sorted.add(collectedFile.normalize().toAbsolutePath());
        }
        LOGGER.info("Found {} input files. Project dir processing: {}, plugins: {} millis", new Object[]{sorted.size(), l, pluginsFinished});
        LOGGER.debug("Src input: {}", sorted);
        return sorted;
    }

    private Path convertToAbsolutePath(Path path) {
        Path resolvedPath = path.isAbsolute() ? path : this.baseDirPath.resolve(path);
        return resolvedPath.toAbsolutePath().normalize();
    }

    private void startWalk(Path candidate, String glob, boolean recursive, List<Path> collectedFiles, Set<WalkKey> visitedDirs) {
        Path normalized = this.convertToAbsolutePath(candidate);
        WalkKey key = new WalkKey(normalized, glob, recursive);
        if (visitedDirs.contains(key) || !Files.exists(normalized, new LinkOption[0])) {
            return;
        }
        if (Files.isDirectory(normalized, new LinkOption[0])) {
            if (this.baseDirPath.startsWith(normalized)) {
                key = new WalkKey(normalized, glob, false);
            }
            try {
                this.walkDir(key, collectedFiles, visitedDirs);
                visitedDirs.add(key);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if (!this.exclusionResolver.excludesPath(normalized)) {
            LOGGER.debug("Adding: {}", (Object)normalized);
            collectedFiles.add(normalized);
        }
    }

    private void collectFromPlugins(List<Path> files, HashSet<WalkKey> visitedDirs) {
        List plugins = this.project.getBuild().getPlugins();
        for (Plugin plugin : plugins) {
            PluginScanConfig scanConfig = this.config.getPluginDirScanConfig(plugin);
            if (scanConfig.isSkip()) {
                LOGGER.debug("Skipping plugin config scan (skip by config): {}", (Object)plugin.getArtifactId());
                continue;
            }
            Object configuration = plugin.getConfiguration();
            LOGGER.debug("Processing plugin config: {}", (Object)plugin.getArtifactId());
            if (configuration != null) {
                this.addInputsFromPluginConfigs(Xpp3DomUtils.getChildren(configuration), scanConfig, files, visitedDirs);
            }
            for (PluginExecution exec : plugin.getExecutions()) {
                PluginScanConfig executionScanConfig = this.config.getExecutionDirScanConfig(plugin, exec);
                PluginScanConfig mergedConfig = scanConfig.mergeWith(executionScanConfig);
                if (mergedConfig.isSkip()) {
                    LOGGER.debug("Skipping plugin execution config scan (skip by config): {}, execId: {}", (Object)plugin.getArtifactId(), (Object)exec.getId());
                    continue;
                }
                Object execConfiguration = exec.getConfiguration();
                LOGGER.debug("Processing plugin: {}, execution: {}", (Object)plugin.getArtifactId(), (Object)exec.getId());
                if (execConfiguration == null) continue;
                this.addInputsFromPluginConfigs(Xpp3DomUtils.getChildren(execConfiguration), mergedConfig, files, visitedDirs);
            }
        }
    }

    private Path walkDir(final WalkKey key, final List<Path> collectedFiles, final Set<WalkKey> visitedDirs) throws IOException {
        return Files.walkFileTree(key.getPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                WalkKey currentDirKey = new WalkKey(path.toAbsolutePath().normalize(), key.getGlob(), key.isRecursive());
                if (MavenProjectInput.isHidden(path)) {
                    LOGGER.debug("Skipping subtree (hidden): {}", (Object)path);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (!MavenProjectInput.isReadable(path)) {
                    LOGGER.debug("Skipping subtree (not readable): {}", (Object)path);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (MavenProjectInput.this.exclusionResolver.excludesPath(path)) {
                    LOGGER.debug("Skipping subtree (blacklisted): {}", (Object)path);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                if (visitedDirs.contains(currentDirKey)) {
                    LOGGER.debug("Skipping subtree (visited): {}", (Object)path);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                MavenProjectInput.walkDirectoryFiles(path, collectedFiles, key.getGlob(), MavenProjectInput.this.exclusionResolver::excludesPath);
                if (!key.isRecursive()) {
                    LOGGER.debug("Skipping subtree (non recursive): {}", (Object)path);
                    return FileVisitResult.SKIP_SUBTREE;
                }
                LOGGER.debug("Visiting subtree: {}", (Object)path);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path path, IOException exc) throws IOException {
                LOGGER.debug("Skipping subtree (exception: {}): {}", (Object)exc, (Object)path);
                return FileVisitResult.SKIP_SUBTREE;
            }
        });
    }

    private void addInputsFromPluginConfigs(Object[] configurationChildren, PluginScanConfig scanConfig, List<Path> files, HashSet<WalkKey> visitedDirs) {
        if (configurationChildren == null) {
            return;
        }
        for (Object configChild : configurationChildren) {
            String tagName = Xpp3DomUtils.getName(configChild);
            String tagValue = Xpp3DomUtils.getValue(configChild);
            if (!scanConfig.accept(tagName)) {
                LOGGER.debug("Skipping property (scan config)): {}, value: {}", (Object)tagName, (Object)StringUtils.stripToEmpty((String)tagValue));
                continue;
            }
            LOGGER.debug("Checking xml tag. Tag: {}, value: {}", (Object)tagName, (Object)StringUtils.stripToEmpty((String)tagValue));
            this.addInputsFromPluginConfigs(Xpp3DomUtils.getChildren(configChild), scanConfig, files, visitedDirs);
            ScanConfigProperties propertyConfig = scanConfig.getTagScanProperties(tagName);
            String glob = (String)StringUtils.defaultIfEmpty((CharSequence)propertyConfig.getGlob(), (CharSequence)this.projectGlob);
            if ("true".equals(Xpp3DomUtils.getAttribute(configChild, CACHE_INPUT_NAME))) {
                LOGGER.info("Found tag marked with {} attribute. Tag: {}, value: {}", new Object[]{CACHE_INPUT_NAME, tagName, tagValue});
                this.startWalk(Paths.get(tagValue, new String[0]), glob, propertyConfig.isRecursive(), files, visitedDirs);
                continue;
            }
            Path candidate = this.getPathOrNull(tagValue);
            if (candidate == null) continue;
            this.startWalk(candidate, glob, propertyConfig.isRecursive(), files, visitedDirs);
            if (!"descriptorRef".equals(tagName)) continue;
            this.startWalk(Paths.get(tagValue + ".xml", new String[0]), glob, propertyConfig.isRecursive(), files, visitedDirs);
        }
    }

    private Path getPathOrNull(String text) {
        if (!StringUtils.isBlank((CharSequence)text)) {
            if (Strings.CI.equalsAny((CharSequence)text, new CharSequence[]{"true", "false", "utf-8", "null", "\\"}) || Strings.CS.contains((CharSequence)text, (CharSequence)"*") || Strings.CS.contains((CharSequence)text, (CharSequence)":") && !Strings.CS.contains((CharSequence)text, (CharSequence)":\\") || Strings.CS.startsWithAny((CharSequence)text, new CharSequence[]{"com.", "org.", "io.", "java.", "javax."}) || Strings.CS.startsWithAny((CharSequence)text, new CharSequence[]{"${env."}) || Strings.CS.startsWithAny((CharSequence)text, new CharSequence[]{"http:", "https:", "scm:", "ssh:", "git:", "svn:", "cp:", "classpath:"})) {
                LOGGER.debug("Skipping directory (blacklisted literal): {}", (Object)text);
            } else if (Strings.CS.startsWithAny((CharSequence)text, new CharSequence[]{this.tmpDir})) {
                LOGGER.debug("Skipping directory (temp dir): {}", (Object)text);
            } else {
                try {
                    return Paths.get(text, new String[0]);
                }
                catch (Exception ignore) {
                    LOGGER.debug("Skipping directory (invalid path): {}", (Object)text);
                }
            }
        }
        return null;
    }

    static void walkDirectoryFiles(Path dir, List<Path> collectedFiles, String glob, Predicate<Path> mustBeSkipped) {
        if (!Files.isDirectory(dir, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, glob);){
            for (Path entry : stream) {
                File file;
                if (mustBeSkipped.test(entry) || !(file = entry.toFile()).isFile() || MavenProjectInput.isHidden(entry) || !MavenProjectInput.isReadable(entry)) continue;
                collectedFiles.add(entry);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot process directory: " + dir, e);
        }
    }

    private static boolean isHidden(Path entry) throws IOException {
        return Files.isHidden(entry) || entry.toFile().getName().startsWith(".");
    }

    private static boolean isReadable(Path entry) throws IOException {
        return Files.isReadable(entry);
    }

    private SortedMap<String, String> getMutableDependencies() throws IOException {
        return this.getMutableDependenciesHashes("", this.project.getDependencies());
    }

    private SortedMap<String, String> getMutablePluginDependencies() throws IOException {
        HashMap<String, AtomicInteger> keyPrefixOccurrenceIndex = new HashMap<String, AtomicInteger>();
        TreeMap<String, String> fullMap = new TreeMap<String, String>();
        for (Plugin plugin : this.project.getBuildPlugins()) {
            if (this.config.isPluginDependenciesExcluded(plugin)) continue;
            String rawKeyPrefix = KeyUtils.getVersionlessArtifactKey(this.createPluginArtifact(plugin));
            int occurrenceIndex = keyPrefixOccurrenceIndex.computeIfAbsent(rawKeyPrefix, k -> new AtomicInteger()).getAndIncrement();
            fullMap.putAll(this.getMutableDependenciesHashes(rawKeyPrefix + "|" + occurrenceIndex + "|", plugin.getDependencies()));
        }
        return fullMap;
    }

    public Artifact createPluginArtifact(Plugin plugin) {
        VersionRange versionRange;
        try {
            versionRange = VersionRange.createFromVersionSpec((String)plugin.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            LOGGER.error(String.format("Invalid version specification '%s' creating plugin artifact '%s'.", plugin.getVersion(), plugin), (Throwable)e);
            throw new RuntimeException(e);
        }
        return this.createArtifact(plugin.getGroupId(), plugin.getArtifactId(), versionRange, "maven-plugin", null, "runtime", null, false);
    }

    private Artifact createArtifact(String groupId, String artifactId, VersionRange versionRange, String type, String classifier, String scope, String inheritedScope, boolean optional) {
        String desiredScope = "runtime";
        if (inheritedScope == null) {
            desiredScope = scope;
        } else {
            if ("test".equals(scope) || "provided".equals(scope)) {
                return null;
            }
            if ("compile".equals(scope) && "compile".equals(inheritedScope)) {
                desiredScope = "compile";
            }
        }
        if ("test".equals(inheritedScope)) {
            desiredScope = "test";
        }
        if ("provided".equals(inheritedScope)) {
            desiredScope = "provided";
        }
        if ("system".equals(scope)) {
            desiredScope = "system";
        }
        ArtifactHandler handler = this.artifactHandlerManager.getArtifactHandler(type);
        return new DefaultArtifact(groupId, artifactId, versionRange, desiredScope, type, classifier, handler, optional);
    }

    public Artifact createDependencyArtifact(Dependency d) {
        VersionRange versionRange;
        try {
            versionRange = VersionRange.createFromVersionSpec((String)d.getVersion());
        }
        catch (InvalidVersionSpecificationException e) {
            LOGGER.error(String.format("Invalid version specification '%s' creating dependency artifact '%s'.", d.getVersion(), d), (Throwable)e);
            throw new RuntimeException(e);
        }
        Artifact artifact = this.createArtifact(d.getGroupId(), d.getArtifactId(), versionRange, d.getType(), d.getClassifier(), d.getScope(), null, d.isOptional());
        if ("system".equals(d.getScope()) && d.getSystemPath() != null) {
            artifact.setFile(new File(d.getSystemPath()));
        }
        if (!d.getExclusions().isEmpty()) {
            ArrayList<String> exclusions = new ArrayList<String>();
            for (Exclusion exclusion : d.getExclusions()) {
                exclusions.add(exclusion.getGroupId() + ':' + exclusion.getArtifactId());
            }
            artifact.setDependencyFilter((ArtifactFilter)new ExcludesArtifactFilter(exclusions));
        }
        return artifact;
    }

    private SortedMap<String, String> getMutableDependenciesHashes(String keyPrefix, List<Dependency> dependencies) throws IOException {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Dependency dependency : dependencies) {
            String projectHash;
            MavenProject dependencyProject;
            if (CacheUtils.isPom(dependency)) continue;
            String versionSpec = dependency.getVersion();
            MavenProject mavenProject = dependencyProject = versionSpec == null ? null : (MavenProject)this.multiModuleSupport.tryToResolveProject(dependency.getGroupId(), dependency.getArtifactId(), versionSpec).orElse(null);
            if (dependencyProject == null && MavenProjectInput.isDynamicVersion(versionSpec)) {
                dependencyProject = this.tryResolveReactorProjectByGA(dependency).orElse(null);
            }
            boolean isSnapshot = CacheUtils.isSnapshot(versionSpec);
            if (dependencyProject == null && !isSnapshot) continue;
            if (dependencyProject != null) {
                projectHash = this.projectInputCalculator.calculateInput(dependencyProject).getChecksum();
            } else {
                try {
                    DigestItem resolved = this.resolveArtifact(dependency);
                    projectHash = resolved.getHash();
                }
                catch (InvalidVersionSpecificationException | ArtifactResolutionException e) {
                    throw new IOException(e);
                }
            }
            result.put(keyPrefix + KeyUtils.getVersionlessArtifactKey(this.createDependencyArtifact(dependency)), projectHash);
        }
        return result;
    }

    @Nonnull
    private DigestItem resolveArtifact(Dependency dependency) throws IOException, ArtifactResolutionException, InvalidVersionSpecificationException {
        if ("system".equals(dependency.getScope()) && dependency.getSystemPath() != null) {
            Path systemPath = Paths.get(dependency.getSystemPath(), new String[0]).normalize();
            if (!Files.exists(systemPath, new LinkOption[0])) {
                throw new DependencyNotResolvedException("System dependency file does not exist: " + systemPath + " for dependency: " + dependency);
            }
            HashAlgorithm algorithm = this.config.getHashFactory().createAlgorithm();
            String hash = algorithm.hash(systemPath);
            Artifact artifact = this.createDependencyArtifact(dependency);
            return DtoUtils.createDigestedFile(artifact, hash);
        }
        org.eclipse.aether.artifact.DefaultArtifact dependencyArtifact = new org.eclipse.aether.artifact.DefaultArtifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getClassifier(), null, dependency.getVersion(), (ArtifactType)new DefaultArtifactType(dependency.getType()));
        ArtifactRequest artifactRequest = new ArtifactRequest().setArtifact((org.eclipse.aether.artifact.Artifact)dependencyArtifact);
        artifactRequest.setRepositories(this.project.getRemoteProjectRepositories());
        ArtifactResult result = this.repoSystem.resolveArtifact(this.session.getRepositorySession(), artifactRequest);
        if (!result.isResolved()) {
            throw new DependencyNotResolvedException("Cannot resolve in-project dependency: " + dependencyArtifact);
        }
        if (result.isMissing()) {
            throw new DependencyNotResolvedException("Cannot resolve missing artifact: " + dependencyArtifact);
        }
        org.eclipse.aether.artifact.Artifact resolved = result.getArtifact();
        Artifact artifact = this.createArtifact(resolved.getGroupId(), resolved.getArtifactId(), VersionRange.createFromVersionSpec((String)resolved.getVersion()), dependency.getType(), resolved.getClassifier(), dependency.getType(), dependency.getScope(), false);
        HashAlgorithm algorithm = this.config.getHashFactory().createAlgorithm();
        String hash = algorithm.hash(resolved.getFile().toPath());
        return DtoUtils.createDigestedFile(artifact, hash);
    }

    private static boolean isDynamicVersion(String versionSpec) {
        if (versionSpec == null) {
            return true;
        }
        if ("LATEST".equals(versionSpec) || "RELEASE".equals(versionSpec)) {
            return true;
        }
        return versionSpec.startsWith("[") || versionSpec.startsWith("(") || versionSpec.contains(",");
    }

    private Optional<MavenProject> tryResolveReactorProjectByGA(Dependency dependency) {
        List projects = this.session.getAllProjects();
        if (projects == null || projects.isEmpty()) {
            return Optional.empty();
        }
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        String versionSpec = dependency.getVersion();
        for (MavenProject candidate : projects) {
            if (!Objects.equals(groupId, candidate.getGroupId()) || !Objects.equals(artifactId, candidate.getArtifactId())) continue;
            if (versionSpec == null || "LATEST".equals(versionSpec) || "RELEASE".equals(versionSpec)) {
                return Optional.of(candidate);
            }
            if (!versionSpec.startsWith("[") && !versionSpec.startsWith("(") && !versionSpec.contains(",")) continue;
            try {
                VersionRange range = VersionRange.createFromVersionSpec((String)versionSpec);
                if (!range.containsVersion((ArtifactVersion)new DefaultArtifactVersion(candidate.getVersion()))) continue;
                return Optional.of(candidate);
            }
            catch (InvalidVersionSpecificationException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    public static boolean isSkipCache(MavenProject project) {
        return Boolean.parseBoolean(project.getProperties().getProperty("maven.build.cache.skipCache", "false"));
    }

    public static boolean isRestoreGeneratedSources(MavenProject project) {
        return Boolean.parseBoolean(project.getProperties().getProperty("maven.build.cache.restoreGeneratedSources", "true"));
    }

    public static boolean isRestoreOnDiskArtifacts(MavenProject project) {
        return Boolean.parseBoolean(project.getProperties().getProperty("maven.build.cache.restoreOnDiskArtifacts", "true"));
    }

    public static boolean isCacheDisabled(MavenProject project) {
        return !Boolean.parseBoolean(project.getProperties().getProperty("maven.build.cache.enabled", "true"));
    }

    public static class PathIgnoringCaseComparator
    implements Comparator<Path> {
        @Override
        public int compare(Path f1, Path f2) {
            String s1 = f1.toAbsolutePath().toString();
            String s2 = f2.toAbsolutePath().toString();
            if (File.separator.equals("\\")) {
                s1 = s1.replaceAll("\\\\", "/");
                s2 = s2.replaceAll("\\\\", "/");
            }
            return s1.compareToIgnoreCase(s2);
        }
    }
}

