/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.hash;

import java.io.IOException;
import java.nio.file.Path;
import org.apache.maven.buildcache.hash.Hash;
import org.apache.maven.buildcache.hash.HexUtils;

public class HashChecksum {
    private final Hash.Algorithm algorithm;
    private final Hash.Checksum checksum;

    HashChecksum(Hash.Algorithm algorithm, Hash.Checksum checksum) {
        this.algorithm = algorithm;
        this.checksum = checksum;
    }

    public String update(Path path) throws IOException {
        return this.updateAndEncode(this.algorithm.hash(path));
    }

    public String update(byte[] bytes) {
        return this.updateAndEncode(this.algorithm.hash(bytes));
    }

    public String update(String hexHash) {
        return this.updateAndEncode(HexUtils.decode(hexHash));
    }

    private String updateAndEncode(byte[] hash) {
        this.checksum.update(hash);
        return HexUtils.encode(hash);
    }

    public String digest() {
        return HexUtils.encode(this.checksum.digest());
    }
}

