/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mae.depgraph;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.mae.depgraph.impl.ArtifactOnlyDependencyNode;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactResult;

public class DepGraphNode
implements Iterable<Throwable> {
    private Artifact latestArtifact;
    private ArtifactResult latestResult;
    private final LinkedHashSet<RemoteRepository> remoteRepositories = new LinkedHashSet();
    private String key;
    private final boolean preResolved;
    private final Set<Throwable> errors = new HashSet<Throwable>();
    private DependencyNode latestDependencyNode;

    public DepGraphNode(DependencyNode node) {
        this(node, null, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DepGraphNode(DependencyNode node, String key, boolean preResolved) {
        this.merge(node);
        if (key == null) {
            if (this.latestArtifact == null) throw new NullPointerException("Cannot calculate node key. DependencyNode parameter does not contain a valid artifact!");
            this.key = DepGraphNode.key(this.latestArtifact);
        } else {
            this.key = key;
        }
        this.preResolved = preResolved;
    }

    public DepGraphNode(Artifact artifact, boolean preResolved) {
        this.key = DepGraphNode.key(artifact);
        this.latestArtifact = artifact;
        this.preResolved = preResolved;
    }

    static String key(Artifact a) {
        return ArtifactUtils.key((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getBaseVersion());
    }

    public boolean isPreResolved() {
        return this.preResolved;
    }

    public synchronized void merge(DependencyNode node) {
        this.latestDependencyNode = node;
        if (node.getRepositories() != null) {
            this.remoteRepositories.addAll(node.getRepositories());
        }
        if (this.latestArtifact == null && node.getDependency() != null && node.getDependency().getArtifact() != null) {
            this.latestArtifact = node.getDependency().getArtifact();
        }
    }

    public synchronized void merge(ArtifactResult result) {
        if (result.getArtifact() != null && result.getArtifact().getFile() != null) {
            result.getExceptions().clear();
        }
        this.latestResult = result;
    }

    public DependencyNode getLatestDependencyNode() {
        return this.latestDependencyNode;
    }

    public ArtifactResult getLatestResult() {
        return this.latestResult;
    }

    public Artifact getLatestArtifact() {
        return this.latestArtifact;
    }

    public LinkedHashSet<RemoteRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public String getKey() {
        return this.key;
    }

    public synchronized boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    private String renderErrors() {
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to resolve: ").append(this.getKey());
        sb.append("\n\n").append(this.errors.size()).append(" Resolution errors:\n");
        for (Throwable error : this.errors) {
            StringWriter sWriter = new StringWriter();
            error.printStackTrace(new PrintWriter(sWriter));
            sb.append("\n\n").append(sWriter.toString());
        }
        return sb.toString();
    }

    @Override
    public Iterator<Throwable> iterator() {
        return this.getErrors().iterator();
    }

    public List<Throwable> getErrors() {
        return new ArrayList<Throwable>(this.errors);
    }

    public void logErrors(PrintWriter writer) {
        writer.println(this.renderErrors());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("DependencyTrackingState (\n    latestArtifact=");
        builder.append(this.latestArtifact);
        builder.append("\n    latestResult=");
        builder.append(this.latestResult);
        builder.append("\n    projectId=");
        builder.append(this.key);
        builder.append("\n)");
        return builder.toString();
    }

    public void removeLatestResult() {
        this.latestResult = null;
    }

    public void merge(Artifact child) {
        this.merge(new ArtifactOnlyDependencyNode(child));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DepGraphNode other = (DepGraphNode)obj;
        return !(this.key == null ? other.key != null : !this.key.equals(other.key));
    }
}

