/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mae.depgraph.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.sonatype.aether.collection.DependencyCollectionContext;
import org.sonatype.aether.collection.DependencySelector;
import org.sonatype.aether.graph.Dependency;

public class FlexibleScopeDependencySelector
implements DependencySelector {
    private boolean transitive;
    private final Set<String> included;
    private final Set<String> excluded;

    public FlexibleScopeDependencySelector() {
        this.included = new HashSet<String>();
        this.excluded = new HashSet<String>();
    }

    public FlexibleScopeDependencySelector(Collection<String> included, Collection<String> excluded) {
        this.transitive = false;
        if (included != null) {
            this.included = new HashSet<String>();
            this.included.addAll(included);
        } else {
            this.included = Collections.emptySet();
        }
        if (excluded != null) {
            this.excluded = new HashSet<String>();
            this.excluded.addAll(excluded);
        } else {
            this.excluded = Collections.emptySet();
        }
    }

    public FlexibleScopeDependencySelector(String ... excluded) {
        this(null, Arrays.asList(excluded));
    }

    private FlexibleScopeDependencySelector(boolean transitive, Collection<String> included, Collection<String> excluded) {
        this.transitive = transitive;
        this.included = included == null ? null : new HashSet<String>(included);
        this.excluded = excluded == null ? null : new HashSet<String>(excluded);
    }

    public boolean selectDependency(Dependency dependency) {
        if (!this.transitive) {
            return true;
        }
        String scope = dependency.getScope();
        return !(!this.included.isEmpty() && !this.included.contains(scope) || !this.excluded.isEmpty() && this.excluded.contains(scope));
    }

    public DependencySelector deriveChildSelector(DependencyCollectionContext context) {
        if (this.transitive || context.getDependency() == null) {
            return this;
        }
        return new FlexibleScopeDependencySelector(true, this.included, this.excluded);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (null == obj || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        FlexibleScopeDependencySelector that = (FlexibleScopeDependencySelector)obj;
        return this.transitive == that.transitive && ((Object)this.included).equals(that.included) && ((Object)this.excluded).equals(that.excluded);
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 31 + (this.transitive ? 1 : 0);
        hash = hash * 31 + ((Object)this.included).hashCode();
        hash = hash * 31 + ((Object)this.excluded).hashCode();
        return hash;
    }

    public FlexibleScopeDependencySelector includeScope(String scope) {
        this.included.add(scope);
        return this;
    }

    public FlexibleScopeDependencySelector excludeScope(String scope) {
        this.excluded.add(scope);
        return this;
    }

    public FlexibleScopeDependencySelector setTransitive(boolean transitive) {
        this.transitive = transitive;
        return this;
    }
}

