/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mae.depgraph.impl.collect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.mae.depgraph.impl.collect.DepGraphCache;
import org.apache.maven.mae.depgraph.impl.collect.SlimDependencyEdge;
import org.apache.maven.mae.depgraph.impl.collect.SlimDependencyNode;
import org.apache.maven.mae.graph.DirectedGraph;
import org.apache.maven.mae.graph.DirectionalEdge;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.util.artifact.ArtifacIdUtils;

class SlimDepGraph {
    private static final List<Artifact> NO_ARTIFACTS = Collections.emptyList();
    private final DepGraph graph;
    private final Map<String, Set<Artifact>> relocations = new HashMap<String, Set<Artifact>>();
    private final Map<String, Set<Artifact>> aliases = new HashMap<String, Set<Artifact>>();
    private final Map<String, Set<RemoteRepository>> repositoryMap = new HashMap<String, Set<RemoteRepository>>();
    private final DepGraphCache cache;

    SlimDepGraph(RepositorySystemSession session) {
        this.graph = new DepGraph(this);
        this.cache = new DepGraphCache(session);
    }

    synchronized List<DependencyNode> childrenOf(SlimDependencyNode node) {
        Collection<SlimDependencyEdge> allEdges = this.graph.edgesFrom(node);
        ArrayList<DependencyNode> children = new ArrayList<DependencyNode>(allEdges);
        for (SlimDependencyEdge edge : allEdges) {
            if (edge.getFrom() != node || edge.getTo() != node) continue;
            children.remove((Object)edge);
        }
        return children;
    }

    synchronized void setArtifact(Artifact artifact) {
        this.cache.setArtifact(artifact);
    }

    synchronized Artifact intern(Artifact artifact) {
        return this.cache.intern(artifact);
    }

    synchronized RemoteRepository intern(RemoteRepository repo) {
        return this.cache.intern(repo);
    }

    synchronized List<Artifact> getArtifacts(List<String> ids) {
        if (ids == null) {
            return NO_ARTIFACTS;
        }
        ArrayList<Artifact> result = new ArrayList<Artifact>(ids.size());
        for (String id : ids) {
            result.add(this.cache.getArtifact(id));
        }
        return result;
    }

    Artifact getArtifact(String id) {
        return this.cache.getArtifact(id);
    }

    synchronized void addEdge(SlimDependencyEdge edge) {
        this.graph.addEdge(edge);
    }

    SlimDependencyNode getNode(String id) {
        SlimDependencyNode node = new SlimDependencyNode(id, this);
        if (this.graph.containsVertex(node)) {
            return node;
        }
        return null;
    }

    SlimDependencyNode getNode(Artifact artifact) {
        return this.getNode(ArtifacIdUtils.toId((Artifact)artifact));
    }

    List<Artifact> getRelocations(String id) {
        Set<Artifact> r = this.relocations.get(id);
        return r == null ? null : new ArrayList<Artifact>(r);
    }

    synchronized void addRelocation(String id, Artifact relocation) {
        Set<Artifact> r = this.relocations.get(id);
        if (r == null) {
            r = new LinkedHashSet<Artifact>();
            this.relocations.put(id, r);
        }
        r.add(this.intern(relocation));
    }

    synchronized void setRelocations(String id, List<Artifact> relocations) {
        if (relocations == null) {
            return;
        }
        LinkedHashSet<Artifact> r = new LinkedHashSet<Artifact>();
        for (Artifact artifact : relocations) {
            r.add(this.intern(artifact));
        }
        this.relocations.put(id, r);
    }

    Collection<Artifact> getAliases(String id) {
        return this.aliases.get(id);
    }

    synchronized void addAlias(String id, Artifact alias) {
        Set<Artifact> a = this.aliases.get(id);
        if (a == null) {
            a = new LinkedHashSet<Artifact>();
            this.aliases.put(id, a);
        }
        a.add(this.intern(alias));
    }

    synchronized void setAliases(String id, Collection<Artifact> aliases) {
        if (aliases == null) {
            return;
        }
        LinkedHashSet<Artifact> a = new LinkedHashSet<Artifact>();
        for (Artifact artifact : aliases) {
            a.add(this.intern(artifact));
        }
        this.aliases.put(id, a);
    }

    List<RemoteRepository> getRepositories(String id) {
        Set<RemoteRepository> repos = this.repositoryMap.get(id);
        return repos == null ? null : new ArrayList<RemoteRepository>(repos);
    }

    synchronized void setRepositories(String id, List<RemoteRepository> repositories) {
        if (repositories == null) {
            return;
        }
        LinkedHashSet<RemoteRepository> repos = new LinkedHashSet<RemoteRepository>();
        for (RemoteRepository repo : repositories) {
            repos.add(this.intern(repo));
        }
        this.repositoryMap.put(id, repos);
    }

    public void removeEdge(SlimDependencyEdge edge) {
        this.graph.removeEdge(edge);
    }

    private static final class DepGraph
    extends DirectedGraph<SlimDependencyNode, SlimDependencyEdge> {
        DepGraph(SlimDepGraph owner) {
            super((DirectionalEdge.DirectionalEdgeFactory)new SlimDependencyEdge.Factory(owner));
        }

        Collection<SlimDependencyEdge> edgesFrom(SlimDependencyNode from) {
            return this.getNakedGraph().getOutEdges((Object)from);
        }

        void addEdge(SlimDependencyEdge edge) {
            if (!this.getNakedGraph().containsVertex(edge.getFrom())) {
                this.getNakedGraph().addVertex(edge.getFrom());
            }
            if (!this.getNakedGraph().containsVertex(edge.getTo())) {
                this.getNakedGraph().addVertex(edge.getTo());
            }
            this.getNakedGraph().addEdge((Object)edge, edge.getFrom(), edge.getTo());
        }

        boolean containsVertex(SlimDependencyNode vertex) {
            return this.getNakedGraph().containsVertex((Object)vertex);
        }

        void removeEdge(SlimDependencyEdge edge) {
            this.getNakedGraph().removeEdge((Object)edge);
            SlimDependencyNode to = (SlimDependencyNode)edge.getTo();
            Collection in = this.getNakedGraph().getInEdges((Object)to);
            if (in == null || in.isEmpty()) {
                this.getNakedGraph().removeVertex((Object)to);
            }
        }
    }
}

