/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mae.depgraph.impl.collect;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.mae.depgraph.impl.collect.SlimDepGraph;
import org.apache.maven.mae.depgraph.impl.collect.SlimDependencyNode;
import org.apache.maven.mae.graph.DirectionalEdge;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.Dependency;
import org.sonatype.aether.graph.DependencyNode;
import org.sonatype.aether.graph.DependencyVisitor;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.version.Version;
import org.sonatype.aether.version.VersionConstraint;

class SlimDependencyEdge
extends DirectionalEdge<SlimDependencyNode>
implements DependencyNode {
    private final SlimDepGraph graph;
    private Dependency dependency;
    private String key;
    private VersionConstraint versionConstraint;
    private Version version;
    private String scope;
    private String preManagedVersion;
    private String preManagedScope;
    private String requestContext;
    private Map<Object, Object> data;

    SlimDependencyEdge(SlimDependencyNode from, SlimDependencyNode to, SlimDepGraph graph) {
        super((Object)from, (Object)to);
        graph.addEdge(this);
        this.graph = graph;
    }

    SlimDependencyEdge(SlimDependencyNode root, SlimDepGraph graph) {
        super((Object)root, (Object)root);
        graph.addEdge(this);
        this.graph = graph;
    }

    public List<DependencyNode> getChildren() {
        return this.graph.childrenOf((SlimDependencyNode)this.getTo());
    }

    public Dependency getDependency() {
        return this.dependency == null ? null : this.dependency.setArtifact(this.graph.intern(this.dependency.getArtifact()));
    }

    public void setArtifact(Artifact artifact) {
        this.graph.setArtifact(artifact);
        if (this.dependency != null) {
            this.dependency = this.dependency.setArtifact(artifact);
        }
    }

    Artifact getArtifact() {
        return this.graph.getArtifact(this.key);
    }

    public List<Artifact> getRelocations() {
        return this.graph.getRelocations(this.key);
    }

    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setScope(String scope) {
        this.scope = scope.intern();
    }

    String getScope() {
        return this.scope;
    }

    public String getPremanagedVersion() {
        return this.preManagedVersion;
    }

    public String getPremanagedScope() {
        return this.preManagedScope;
    }

    public List<RemoteRepository> getRepositories() {
        return ((SlimDependencyNode)this.getTo()).getRepositories();
    }

    public String getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(String requestContext) {
        this.requestContext = requestContext.intern();
    }

    public Map<Object, Object> getData() {
        return Collections.unmodifiableMap(this.data);
    }

    public synchronized void setData(Object key, Object value) {
        if (this.data == null) {
            this.data = new HashMap<Object, Object>();
        }
        if (key != null) {
            this.data.put(key, value);
        }
    }

    public boolean accept(DependencyVisitor visitor) {
        block1: {
            if (!visitor.visitEnter((DependencyNode)this)) break block1;
            for (DependencyNode child : this.getChildren()) {
                if (!child.accept(visitor)) break;
            }
        }
        return visitor.visitLeave((DependencyNode)this);
    }

    void setDependency(Dependency dependency) {
        this.dependency = dependency == null ? null : dependency.setArtifact(this.graph.intern(dependency.getArtifact()));
    }

    void setRelocations(List<Artifact> relocations) {
        this.graph.setRelocations(this.key, relocations);
    }

    void addRelocation(Artifact relocation) {
        this.graph.addRelocation(this.key, relocation);
    }

    void setVersionConstraint(VersionConstraint versionConstraint) {
        this.versionConstraint = versionConstraint;
    }

    void setVersion(Version version) {
        this.version = version;
    }

    void setPreManagedVersion(String preManagedVersion) {
        this.preManagedVersion = preManagedVersion;
    }

    void setPreManagedScope(String preManagedScope) {
        this.preManagedScope = preManagedScope;
    }

    public Collection<Artifact> getAliases() {
        return ((SlimDependencyNode)this.getTo()).getAliases();
    }

    void setPremanagedScope(String premanagedScope) {
        this.preManagedScope = premanagedScope;
    }

    void setPremanagedVersion(String premanagedVersion) {
        this.preManagedVersion = premanagedVersion;
    }

    public String toString() {
        return "Edge:\n\tFrom: " + this.getFrom() + "\n\tTo: " + this.getTo();
    }

    static final class Factory
    implements DirectionalEdge.DirectionalEdgeFactory<SlimDependencyNode, SlimDependencyEdge> {
        private final SlimDepGraph graph;

        Factory(SlimDepGraph graph) {
            this.graph = graph;
        }

        public SlimDependencyEdge createEdge(SlimDependencyNode from, SlimDependencyNode to) {
            return new SlimDependencyEdge(from, to, this.graph);
        }
    }
}

