/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mae.app;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.maven.mae.MAEException;
import org.apache.maven.mae.app.MAEApplication;
import org.apache.maven.mae.boot.embed.MAEEmbedder;
import org.apache.maven.mae.boot.embed.MAEEmbedderBuilder;
import org.apache.maven.mae.conf.MAEConfiguration;
import org.apache.maven.mae.conf.MAELibrary;
import org.apache.maven.mae.conf.VersionProvider;
import org.apache.maven.mae.conf.ext.ExtensionConfiguration;
import org.apache.maven.mae.conf.ext.ExtensionConfigurationException;
import org.apache.maven.mae.conf.loader.InstanceLibraryLoader;
import org.apache.maven.mae.conf.loader.MAELibraryLoader;
import org.apache.maven.mae.internal.container.ComponentKey;
import org.apache.maven.mae.internal.container.ComponentSelector;
import org.apache.maven.mae.internal.container.InstanceRegistry;
import org.apache.maven.mae.internal.container.VirtualInstance;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public abstract class AbstractMAEApplication
implements MAEApplication {
    private final List<MAELibrary> additionalLibraries = new ArrayList<MAELibrary>();
    private final InstanceRegistry instanceRegistry = new InstanceRegistry();
    private transient boolean loaded = false;

    protected AbstractMAEApplication() {
        this.withLibrary(this);
        this.withComponentInstance(new ComponentKey(this.getClass()), this);
    }

    protected final AbstractMAEApplication withLibrary(MAELibrary library) {
        this.additionalLibraries.add(library);
        return this;
    }

    @Override
    public MAEApplication load() throws MAEException {
        return this.doLoad();
    }

    private final synchronized MAEApplication doLoad() throws MAEException {
        if (this.loaded) {
            return this;
        }
        MAEEmbedderBuilder builder = new MAEEmbedderBuilder().withLibraryLoader((MAELibraryLoader)new InstanceLibraryLoader(this.additionalLibraries));
        this.configureBuilder(builder);
        MAEEmbedder embedder = builder.build();
        for (ComponentKey key : this.getInstanceRegistry().getInstances().keySet()) {
            try {
                builder.container().lookup(key.getRoleClass(), key.getHint());
            }
            catch (ComponentLookupException e) {
                throw new MAEException("Forced member-injection for registered instance: %s failed. Reason: %s", (Throwable)e, new Object[]{key, e.getMessage()});
            }
        }
        this.afterLoading(embedder);
        this.loaded = true;
        return this;
    }

    protected final void withComponentInstance(Object instance) {
        this.getInstanceRegistry().add(new ComponentKey(instance.getClass()), instance);
    }

    protected final <C> void withVirtualComponent(Class<C> virtualClass) {
        this.getInstanceRegistry().addVirtual(new VirtualInstance(virtualClass));
    }

    protected final <C, T extends C> void setVirtualInstance(Class<C> virtualKey, T instance) {
        this.getInstanceRegistry().setVirtualInstance(virtualKey, instance);
    }

    protected final <C> void withComponentInstance(ComponentKey<C> componentKey, C instance) {
        this.getInstanceRegistry().add(componentKey, instance);
    }

    protected final <C> void withVirtualComponent(ComponentKey<C> virtualKey) {
        this.getInstanceRegistry().addVirtual(virtualKey, new VirtualInstance(virtualKey.getRoleClass()));
    }

    protected final <C, T extends C> void setVirtualInstance(ComponentKey<C> virtualKey, T instance) {
        this.getInstanceRegistry().setVirtualInstance(virtualKey, instance);
    }

    protected void configureBuilder(MAEEmbedderBuilder builder) throws MAEException {
    }

    protected void afterLoading(MAEEmbedder embedder) throws MAEException {
    }

    public Logger getLogger() {
        return Logger.getLogger((String)this.getLogHandle());
    }

    public ExtensionConfiguration getConfiguration() {
        return null;
    }

    public ComponentSelector getComponentSelector() {
        return null;
    }

    public Set<ComponentKey<?>> getExportedComponents() {
        return null;
    }

    public Set<ComponentKey<?>> getManagementComponents(Class<?> managementType) {
        return null;
    }

    public Map<Class<?>, Set<ComponentKey<?>>> getManagementComponents() {
        return null;
    }

    public String getLabel() {
        return this.getName();
    }

    public String getLogHandle() {
        return this.getId();
    }

    public void loadConfiguration(MAEConfiguration embConfig) throws ExtensionConfigurationException {
    }

    public final InstanceRegistry getInstanceRegistry() {
        return this.instanceRegistry;
    }

    public String getVersion() {
        VersionProvider provider = this.getVersionProvider();
        if (provider == null) {
            throw new IllegalStateException("Your application booter: " + this.getClass().getName() + " must implement either getVersion() or getVersionProvider().");
        }
        return provider.getVersion();
    }

    protected VersionProvider getVersionProvider() {
        return null;
    }
}

