/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mae.boot.embed;

import com.google.inject.Injector;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.Maven;
import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.exception.DefaultExceptionHandler;
import org.apache.maven.exception.ExceptionSummary;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequestPopulationException;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.mae.MAEExecutionRequest;
import org.apache.maven.mae.boot.embed.MAEEmbeddingException;
import org.apache.maven.mae.boot.log.EventLogger;
import org.apache.maven.mae.boot.services.MAEServiceManager;
import org.apache.maven.mae.conf.MAEConfiguration;
import org.apache.maven.mae.conf.MAELibraries;
import org.apache.maven.mae.conf.MAELibrary;
import org.apache.maven.mae.conf.loader.MAELibraryLoader;
import org.apache.maven.mae.conf.mgmt.LoadOnFinish;
import org.apache.maven.mae.conf.mgmt.LoadOnStart;
import org.apache.maven.mae.conf.mgmt.MAEManagementException;
import org.apache.maven.mae.conf.mgmt.MAEManagementView;
import org.apache.maven.mae.internal.container.ComponentKey;
import org.apache.maven.mae.internal.container.MAEContainer;
import org.apache.maven.project.MavenProject;
import org.apache.maven.properties.internal.EnvironmentUtils;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.apache.maven.settings.building.SettingsProblem;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.cipher.PlexusCipherException;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcherException;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

@Component(role=MAEEmbedder.class)
public class MAEEmbedder {
    private static boolean infoShown;
    private final Logger logger;
    private final PrintStream standardOut;
    private final boolean shouldShowErrors;
    private final Maven maven;
    private final boolean showVersion;
    private final MAEContainer container;
    private final MAEConfiguration embConfiguration;
    private final SettingsBuilder settingsBuilder;
    private final MavenExecutionRequestPopulator executionRequestPopulator;
    private final DefaultSecDispatcher securityDispatcher;
    private final transient MAEServiceManager serviceManager;
    private final List<MAELibraryLoader> libraryLoaders;
    private boolean infoPrinted = false;
    private boolean stopped = false;

    MAEEmbedder(Maven maven, MAEConfiguration embConfiguration, MAEContainer container, SettingsBuilder settingsBuilder, MavenExecutionRequestPopulator executionRequestPopulator, DefaultSecDispatcher securityDispatcher, MAEServiceManager serviceManager, List<MAELibraryLoader> libraryLoaders, PrintStream standardOut, Logger logger, boolean shouldShowErrors, boolean showVersion) {
        this.maven = maven;
        this.embConfiguration = embConfiguration;
        this.container = container;
        this.settingsBuilder = settingsBuilder;
        this.executionRequestPopulator = executionRequestPopulator;
        this.securityDispatcher = securityDispatcher;
        this.serviceManager = serviceManager;
        this.libraryLoaders = libraryLoaders;
        this.standardOut = standardOut;
        this.logger = logger;
        this.shouldShowErrors = shouldShowErrors;
        this.showVersion = showVersion;
    }

    public synchronized Injector injector() throws MAEEmbeddingException {
        return this.container.getInjector();
    }

    public synchronized Map<Object, Throwable> wire(Object ... instances) throws MAEEmbeddingException {
        this.checkStopped();
        return this.container.extrudeDependencies(instances);
    }

    protected void checkStopped() {
        if (this.stopped) {
            throw new IllegalStateException("This MAEEmbedder instance has been shutdown! It is no longer available for use.");
        }
    }

    public synchronized MAEServiceManager serviceManager() {
        this.checkStopped();
        this.printInfo(null);
        return this.serviceManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenExecutionResult execute(MAEExecutionRequest request) throws MAEEmbeddingException {
        this.checkStopped();
        PrintStream oldOut = System.out;
        try {
            if (this.standardOut != null) {
                System.setOut(this.standardOut);
            }
            this.doExecutionStarting();
            this.injectEnvironment(request);
            this.printInfo(request);
            MavenExecutionResult mavenExecutionResult = this.maven.execute(request.asMavenExecutionRequest());
            return mavenExecutionResult;
        }
        finally {
            this.shutdown();
            System.setOut(oldOut);
        }
    }

    public String encryptMasterPassword(MAEExecutionRequest request) throws MAEEmbeddingException {
        this.checkStopped();
        this.printInfo(null);
        String passwd = request.getPasswordToEncyrpt();
        if (passwd == null) {
            passwd = "";
        }
        try {
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            String result = cipher.encryptAndDecorate(passwd, "settings.security");
            this.logger.info(result);
            return result;
        }
        catch (PlexusCipherException e) {
            throw new MAEEmbeddingException("Failed to encrypt master password: {0}", e, e.getMessage());
        }
    }

    public String encryptPassword(MAEExecutionRequest request) throws MAEEmbeddingException {
        this.checkStopped();
        this.printInfo(null);
        String passwd = request.getPasswordToEncyrpt();
        String configurationFile = this.securityDispatcher.getConfigurationFile();
        if (configurationFile.startsWith("~")) {
            configurationFile = System.getProperty("user.home") + configurationFile.substring(1);
        }
        String file = System.getProperty("settings.security", configurationFile);
        String master = null;
        try {
            SettingsSecurity sec = SecUtil.read((String)file, (boolean)true);
            if (sec != null) {
                master = sec.getMaster();
            }
            if (master == null) {
                throw new IllegalStateException("Master password is not set in the setting security file: " + file);
            }
            DefaultPlexusCipher cipher = new DefaultPlexusCipher();
            String masterPasswd = cipher.decryptDecorated(master, "settings.security");
            String result = cipher.encryptAndDecorate(passwd, masterPasswd);
            this.logger.info(result);
            return result;
        }
        catch (PlexusCipherException e) {
            throw new MAEEmbeddingException("Failed to encrypt password: {0}", e, e.getMessage());
        }
        catch (SecDispatcherException e) {
            throw new MAEEmbeddingException("Failed to encrypt password: {0}", e, e.getMessage());
        }
    }

    protected void doExecutionStarting() throws MAEEmbeddingException {
        this.checkStopped();
        for (MAELibrary library : this.embConfiguration.getLibraries()) {
            Set components = library.getManagementComponents(LoadOnStart.class);
            if (components == null || components.isEmpty()) continue;
            EmbedderManagementView mgmtView = new EmbedderManagementView(this.container, this.embConfiguration);
            for (ComponentKey key : components) {
                try {
                    LoadOnStart los = (LoadOnStart)this.container.lookup(key.getRole(), key.getHint());
                    los.executionStarting((MAEManagementView)mgmtView);
                }
                catch (ComponentLookupException e) {
                    throw new MAEEmbeddingException("Failed to lookup load-on-start component for initialization: %s.\nReason: %s", e, key, e.getMessage());
                }
            }
        }
    }

    public synchronized void shutdown() {
        if (this.stopped) {
            return;
        }
        this.stopped = true;
        for (MAELibrary library : this.embConfiguration.getLibraries()) {
            Set components = library.getManagementComponents(LoadOnFinish.class);
            if (components == null || components.isEmpty()) continue;
            EmbedderManagementView mgmtView = new EmbedderManagementView(this.container, this.embConfiguration);
            for (ComponentKey key : components) {
                try {
                    LoadOnFinish lof = (LoadOnFinish)this.container.lookup(key.getRole(), key.getHint());
                    lof.executionFinished((MAEManagementView)mgmtView);
                }
                catch (ComponentLookupException e) {
                    this.logger.error(String.format("Failed to lookup load-on-start component for initialization: %s.\nReason: %s", key, e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    protected synchronized void injectEnvironment(MAEExecutionRequest request) throws MAEEmbeddingException {
        this.checkStopped();
        this.injectLogSettings(request);
        this.initialize(request);
        this.injectProperties(request);
        this.injectSettings(request);
        this.injectFromProperties(request);
    }

    private void initialize(MAEExecutionRequest request) {
        this.embConfiguration.withExecutionRequest(request);
        if (request.isInteractiveMode()) {
            this.embConfiguration.interactive();
        } else {
            this.embConfiguration.nonInteractive();
        }
        if (0 == request.getLoggingLevel()) {
            this.embConfiguration.withDebug();
        } else {
            this.embConfiguration.withoutDebug();
        }
    }

    protected void injectFromProperties(MAEExecutionRequest request) {
        this.checkStopped();
        String localRepoProperty = request.getUserProperties().getProperty("maven.repo.local");
        if (localRepoProperty == null) {
            localRepoProperty = request.getSystemProperties().getProperty("maven.repo.local");
        }
        if (localRepoProperty != null) {
            request.setLocalRepositoryPath(localRepoProperty);
        }
    }

    protected void injectLogSettings(MAEExecutionRequest request) {
        this.checkStopped();
        int logLevel = request.getLoggingLevel();
        if (0 == logLevel) {
            this.embConfiguration.withDebug();
        } else {
            this.embConfiguration.withoutDebug();
        }
        this.logger.setThreshold(logLevel);
        try {
            ((LoggerManager)this.container.lookup(LoggerManager.class)).setThresholds(request.getLoggingLevel());
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
        request.setExecutionListener((ExecutionListener)new EventLogger(this.logger));
    }

    protected void injectProperties(MAEExecutionRequest request) {
        Properties systemProperties = new Properties();
        EnvironmentUtils.addEnvVars((Properties)systemProperties);
        systemProperties.putAll((Map<?, ?>)System.getProperties());
        if (request.getSystemProperties() != null) {
            systemProperties.putAll((Map<?, ?>)request.getSystemProperties());
        }
        request.setSystemProperties(systemProperties);
    }

    protected void injectSettings(MAEExecutionRequest request) throws MAEEmbeddingException {
        Settings settings = request.getSettings();
        SettingsBuildingResult settingsResult = null;
        if (settings == null) {
            DefaultSettingsBuildingRequest settingsRequest = new DefaultSettingsBuildingRequest();
            settingsRequest.setGlobalSettingsFile(request.getGlobalSettingsFile());
            settingsRequest.setUserSettingsFile(request.getUserSettingsFile());
            settingsRequest.setSystemProperties(request.getSystemProperties());
            settingsRequest.setUserProperties(request.getUserProperties());
            try {
                settingsResult = this.settingsBuilder.build((SettingsBuildingRequest)settingsRequest);
            }
            catch (SettingsBuildingException e) {
                throw new MAEEmbeddingException("Failed to build settings; {0}\nGlobal settings: {1}\nUser settings: {2}", e, e.getMessage(), request.getGlobalSettingsFile(), request.getUserSettingsFile());
            }
            settings = settingsResult.getEffectiveSettings();
        }
        try {
            this.executionRequestPopulator.populateFromSettings(request.asMavenExecutionRequest(), settings);
        }
        catch (MavenExecutionRequestPopulationException e) {
            throw new MAEEmbeddingException("Failed to populate request from settings; {0}", e, e.getMessage());
        }
        if (!settingsResult.getProblems().isEmpty() && this.logger.isWarnEnabled()) {
            this.logger.warn("");
            this.logger.warn("Some problems were encountered while building the effective settings");
            for (SettingsProblem problem : settingsResult.getProblems()) {
                this.logger.warn(problem.getMessage() + " @ " + problem.getLocation());
            }
            this.logger.warn("");
        }
    }

    public static void showInfo(MAEConfiguration config, List<MAELibraryLoader> loaders, PrintStream standardOut) throws IOException {
        if (infoShown) {
            return;
        }
        standardOut.println();
        standardOut.println("-- MAE Libraries Loaded --");
        standardOut.println();
        Collection libraries = MAELibraries.loadLibraries((MAEConfiguration)config, loaders);
        for (MAELibrary ext : libraries) {
            standardOut.println("+" + ext.getLabel() + " (Log handle: '" + ext.getLogHandle() + "')");
        }
        standardOut.println();
        standardOut.println("--------------------------");
        standardOut.println();
        infoShown = true;
    }

    public static void showVersion(MAEConfiguration config, List<MAELibraryLoader> loaders, PrintStream standardOut) throws IOException {
        MAEEmbedder.showInfo(config, loaders, standardOut);
        CLIReportingUtils.showVersion((PrintStream)standardOut);
    }

    protected synchronized void printInfo(MAEExecutionRequest request) {
        if (this.infoPrinted) {
            return;
        }
        this.infoPrinted = true;
        if (this.showVersion || request != null && 0 == request.getLoggingLevel()) {
            try {
                MAEEmbedder.showVersion(this.embConfiguration, this.libraryLoaders, this.standardOut);
            }
            catch (IOException e) {
                this.logger.error("Failed to retrieve EMB extension information: " + e.getMessage(), (Throwable)e);
            }
        }
        if (this.shouldShowErrors) {
            this.logger.info("Error stacktraces are turned on.");
        }
        if (request != null) {
            if ("warn".equals(request.getGlobalChecksumPolicy())) {
                this.logger.info("Disabling strict checksum verification on all artifact downloads.");
            } else if ("fail".equals(request.getGlobalChecksumPolicy())) {
                this.logger.info("Enabling strict checksum verification on all artifact downloads.");
            }
        }
    }

    public int formatErrorOutput(MAEExecutionRequest request, MavenExecutionResult result) {
        if (result.hasExceptions()) {
            DefaultExceptionHandler handler = new DefaultExceptionHandler();
            LinkedHashMap<String, String> references = new LinkedHashMap<String, String>();
            MavenProject project = null;
            for (Throwable throwable : result.getExceptions()) {
                ExceptionSummary summary = handler.handleException(throwable);
                this.logSummary(summary, references, "", this.shouldShowErrors);
                if (project != null || !(throwable instanceof LifecycleExecutionException)) continue;
                project = ((LifecycleExecutionException)throwable).getProject();
            }
            this.logger.error("");
            if (!this.shouldShowErrors) {
                this.logger.error("To see the full stack trace of the errors, re-run Maven with the -e switch.");
            }
            if (!this.logger.isDebugEnabled()) {
                this.logger.error("Re-run Maven using the -X switch to enable full debug logging.");
            }
            if (!references.isEmpty()) {
                this.logger.error("");
                this.logger.error("For more information about the errors and possible solutions, please read the following articles:");
                for (Map.Entry entry : references.entrySet()) {
                    this.logger.error((String)entry.getValue() + " " + (String)entry.getKey());
                }
            }
            if (project != null && !project.equals(result.getTopologicallySortedProjects().get(0))) {
                this.logger.error("");
                this.logger.error("After correcting the problems, you can resume the build with the command");
                this.logger.error("  mvn <goals> -rf :" + project.getArtifactId());
            }
            if ("FAIL_NEVER".equals(request.getReactorFailureBehavior())) {
                this.logger.info("Build failures were ignored.");
                return 0;
            }
            return 1;
        }
        return 0;
    }

    protected void logSummary(ExceptionSummary summary, Map<String, String> references, String indent, boolean showErrors) {
        String referenceKey = "";
        if (StringUtils.isNotEmpty((String)summary.getReference()) && (referenceKey = references.get(summary.getReference())) == null) {
            referenceKey = "[Help " + (references.size() + 1) + "]";
            references.put(summary.getReference(), referenceKey);
        }
        String msg = indent + summary.getMessage();
        if (StringUtils.isNotEmpty((String)referenceKey)) {
            msg = msg.indexOf(10) < 0 ? msg + " -> " + referenceKey : msg + '\n' + indent + "-> " + referenceKey;
        }
        if (showErrors) {
            this.logger.error(msg, summary.getException());
        } else {
            this.logger.error(msg);
        }
        indent = indent + "  ";
        for (ExceptionSummary child : summary.getChildren()) {
            this.logSummary(child, references, indent, showErrors);
        }
    }

    private static final class EmbedderManagementView
    implements MAEManagementView {
        private final MAEContainer container;
        private final MAEConfiguration configuration;

        EmbedderManagementView(MAEContainer container, MAEConfiguration configuration) {
            this.container = container;
            this.configuration = configuration;
        }

        public <T> T lookup(Class<T> role, String hint) throws MAEManagementException {
            try {
                return (T)this.container.lookup(role, hint);
            }
            catch (ComponentLookupException e) {
                throw new MAEManagementException("Failed to lookup component for managed component.\nRole: %s\nHint: %s\nReason: %s", (Throwable)e, new Object[]{role, hint, e.getMessage()});
            }
        }

        public <T> T lookup(Class<T> role) throws MAEManagementException {
            try {
                return (T)this.container.lookup(role);
            }
            catch (ComponentLookupException e) {
                throw new MAEManagementException("Failed to lookup component for managed component.\nRole: %s\nHint: %s\nReason: %s", (Throwable)e, new Object[]{role, "default", e.getMessage()});
            }
        }

        public MAEConfiguration getConfiguration() {
            return this.configuration;
        }

        public <T> Map<String, T> lookupMap(Class<T> role) throws MAEManagementException {
            try {
                return this.container.lookupMap(role);
            }
            catch (ComponentLookupException e) {
                throw new MAEManagementException("Failed to lookup component-map for managed component.\nRole: %s\nReason: %s", (Throwable)e, new Object[]{role, e.getMessage()});
            }
        }

        public <T> List<T> lookupList(Class<T> role) throws MAEManagementException {
            try {
                return this.container.lookupList(role);
            }
            catch (ComponentLookupException e) {
                throw new MAEManagementException("Failed to lookup component-list for managed component.\nRole: %s\nReason: %s", (Throwable)e, new Object[]{role, e.getMessage()});
            }
        }
    }
}

