/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mae.boot.embed;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.maven.Maven;
import org.apache.maven.cli.MavenLoggerManager;
import org.apache.maven.cli.PrintStreamLogger;
import org.apache.maven.execution.MavenExecutionRequestPopulator;
import org.apache.maven.mae.boot.embed.MAEEmbedder;
import org.apache.maven.mae.boot.embed.MAEEmbeddingException;
import org.apache.maven.mae.boot.services.MAEServiceManager;
import org.apache.maven.mae.conf.CoreLibrary;
import org.apache.maven.mae.conf.MAEConfiguration;
import org.apache.maven.mae.conf.MAELibraries;
import org.apache.maven.mae.conf.MAELibrary;
import org.apache.maven.mae.conf.loader.MAELibraryLoader;
import org.apache.maven.mae.conf.loader.ServiceLibraryLoader;
import org.apache.maven.mae.internal.container.ComponentKey;
import org.apache.maven.mae.internal.container.ComponentSelector;
import org.apache.maven.mae.internal.container.InstanceRegistry;
import org.apache.maven.mae.internal.container.MAEContainer;
import org.apache.maven.mae.internal.container.VirtualInstance;
import org.apache.maven.model.building.ModelProcessor;
import org.apache.maven.settings.building.SettingsBuilder;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.LoggerManager;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;

public class MAEEmbedderBuilder {
    private static final MAELibraryLoader CORE_LOADER = new MAELibraryLoader(){

        public Collection<? extends MAELibrary> loadLibraries(MAEConfiguration embConfig) throws IOException {
            return Collections.singleton(new CoreLibrary());
        }
    };
    private boolean showErrors = false;
    private boolean quiet = false;
    private boolean debug = false;
    private boolean showVersion = false;
    private PrintStream stdout = System.out;
    private PrintStream stderr = System.err;
    private InputStream stdin = System.in;
    private Logger logger;
    private File logFile;
    private MAEConfiguration config;
    private ClassWorld classWorld;
    private ClassLoader coreClassLoader;
    private Maven maven;
    private ModelProcessor modelProcessor;
    private MAEContainer container;
    private MavenExecutionRequestPopulator executionRequestPopulator;
    private SettingsBuilder settingsBuilder;
    private DefaultSecDispatcher securityDispatcher;
    private MAEServiceManager serviceManager;
    private transient String mavenHome;
    private transient boolean loggerAutoCreated = false;
    private MAEEmbedder embedder;
    private String[] debugLogHandles;
    private boolean modelProcessorProvided;
    private boolean mavenProvided;
    private boolean executionRequestPopulatorProvided;
    private boolean settingsBuilderProvided;
    private boolean securityDispatcherProvided;
    private boolean serviceManagerProvided;
    private boolean logHandlesConfigured;
    private boolean configProvided;
    private ContainerConfiguration containerConfiguration;
    private boolean classScanningEnabled;
    private List<MAELibraryLoader> libraryLoaders;
    private final VirtualInstance<MAEEmbedder> embedderVirtual = new VirtualInstance(MAEEmbedder.class);

    public synchronized MAEEmbedderBuilder withSettingsBuilder(SettingsBuilder settingsBuilder) {
        this.settingsBuilder = settingsBuilder;
        this.settingsBuilderProvided = true;
        return this;
    }

    public synchronized SettingsBuilder settingsBuilder() throws MAEEmbeddingException {
        if (this.settingsBuilder == null) {
            this.settingsBuilder = this.lookup(SettingsBuilder.class);
            this.settingsBuilderProvided = false;
        }
        return this.settingsBuilder;
    }

    public synchronized MAEEmbedderBuilder withSecurityDispatcher(DefaultSecDispatcher securityDispatcher) {
        this.securityDispatcher = securityDispatcher;
        this.securityDispatcherProvided = true;
        return this;
    }

    public synchronized DefaultSecDispatcher securityDispatcher() throws MAEEmbeddingException {
        if (this.securityDispatcher == null) {
            this.securityDispatcher = (DefaultSecDispatcher)this.lookup(SecDispatcher.class, "maven");
            this.securityDispatcherProvided = false;
        }
        return this.securityDispatcher;
    }

    public synchronized MAEEmbedderBuilder withServiceManager(MAEServiceManager serviceManager) {
        this.serviceManager = serviceManager;
        this.serviceManagerProvided = true;
        return this;
    }

    public synchronized MAEServiceManager serviceManager() throws MAEEmbeddingException {
        if (this.serviceManager == null) {
            this.serviceManager = this.lookup(MAEServiceManager.class);
            this.serviceManagerProvided = true;
        }
        return this.serviceManager;
    }

    public synchronized MAEEmbedderBuilder withExecutionRequestPopulator(MavenExecutionRequestPopulator executionRequestPopulator) {
        this.executionRequestPopulator = executionRequestPopulator;
        this.executionRequestPopulatorProvided = true;
        return this;
    }

    public synchronized MavenExecutionRequestPopulator executionRequestPopulator() throws MAEEmbeddingException {
        if (this.executionRequestPopulator == null) {
            this.executionRequestPopulator = this.lookup(MavenExecutionRequestPopulator.class);
            this.executionRequestPopulatorProvided = false;
        }
        return this.executionRequestPopulator;
    }

    public synchronized MAEEmbedderBuilder withCoreClassLoader(ClassLoader classLoader) {
        this.coreClassLoader = classLoader;
        return this;
    }

    public synchronized MAEEmbedderBuilder withCoreClassLoader(ClassLoader root, Object ... constituents) throws MalformedURLException {
        if (constituents != null && constituents.length > 0) {
            LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
            for (Object object : constituents) {
                int idx;
                ClassLoader cloader;
                String fname;
                if (object instanceof URL) {
                    urls.add((URL)object);
                    continue;
                }
                if (object instanceof CharSequence) {
                    urls.add(new URL(object.toString()));
                    continue;
                }
                if (object instanceof File) {
                    urls.add(((File)object).toURI().toURL());
                    continue;
                }
                if (object instanceof Class) {
                    fname = ((Class)object).getName();
                    cloader = ((Class)object).getClassLoader();
                } else {
                    fname = object.getClass().getName();
                    cloader = object.getClass().getClassLoader();
                }
                fname = "/" + fname.replace('.', '/') + ".class";
                URL resource = cloader.getResource(fname);
                if (resource == null) {
                    throw new IllegalStateException("Class doesn't appear in its own classloader! [" + object.getClass().getName() + "]");
                }
                String path = resource.toExternalForm();
                if (path.startsWith("jar:")) {
                    path = path.substring("jar:".length());
                }
                if ((idx = path.indexOf(33)) > -1) {
                    path = path.substring(0, idx);
                }
                urls.add(new URL(path));
            }
            this.coreClassLoader = new URLClassLoader(urls.toArray(new URL[0]), root);
        } else {
            this.coreClassLoader = root;
        }
        return this;
    }

    public synchronized MAEEmbedderBuilder withClassWorld(ClassWorld classWorld) {
        this.classWorld = classWorld;
        return this;
    }

    public synchronized ClassLoader coreClassLoader() {
        if (this.coreClassLoader == null) {
            this.coreClassLoader = Thread.currentThread().getContextClassLoader();
        }
        return this.coreClassLoader;
    }

    public synchronized ClassWorld classWorld() {
        if (this.classWorld == null) {
            this.classWorld = new ClassWorld("plexus.core", this.coreClassLoader());
        }
        return this.classWorld;
    }

    public synchronized MAEEmbedderBuilder withContainerConfiguration(ContainerConfiguration containerConfiguration) {
        this.containerConfiguration = containerConfiguration;
        return this;
    }

    public synchronized ContainerConfiguration containerConfiguration() {
        if (this.containerConfiguration == null) {
            this.containerConfiguration = new DefaultContainerConfiguration().setClassWorld(this.classWorld()).setName("maven").setClassPathScanning(this.classScanningEnabled ? "ON" : "OFF");
        }
        return this.containerConfiguration;
    }

    public synchronized MAEEmbedderBuilder withClassScanningEnabled(boolean classScanningEnabled) {
        this.classScanningEnabled = classScanningEnabled;
        return this;
    }

    public boolean isClassScanningEnabled() {
        return this.classScanningEnabled;
    }

    public synchronized MAEEmbedderBuilder withMaven(Maven maven) {
        this.maven = maven;
        this.mavenProvided = true;
        return this;
    }

    public synchronized Maven maven() throws MAEEmbeddingException {
        if (this.maven == null) {
            this.maven = this.lookup(Maven.class);
            this.mavenProvided = false;
        }
        return this.maven;
    }

    public synchronized MAEEmbedderBuilder withModelProcessor(ModelProcessor modelProcessor) {
        this.modelProcessor = modelProcessor;
        this.modelProcessorProvided = true;
        return this;
    }

    public synchronized ModelProcessor modelProcessor() throws MAEEmbeddingException {
        if (this.modelProcessor == null) {
            this.modelProcessor = this.lookup(ModelProcessor.class);
            this.modelProcessorProvided = false;
        }
        return this.modelProcessor;
    }

    private <T> T lookup(Class<T> cls) throws MAEEmbeddingException {
        try {
            return (T)this.container().lookup(cls);
        }
        catch (ComponentLookupException e) {
            throw new MAEEmbeddingException("Failed to lookup component: %s. Reason: %s", e, cls.getName(), e.getMessage());
        }
    }

    private <T> T lookup(Class<T> cls, String hint) throws MAEEmbeddingException {
        try {
            return (T)this.container().lookup(cls, hint);
        }
        catch (ComponentLookupException e) {
            throw new MAEEmbeddingException("Failed to lookup component: {0} with hint: {1}. Reason: {2}", e, cls.getName(), hint, e.getMessage());
        }
    }

    public synchronized MAEEmbedderBuilder withContainer(MAEContainer container) {
        this.container = container;
        this.resetContainer();
        return this;
    }

    public synchronized void resetContainer() {
        if (!this.modelProcessorProvided) {
            this.modelProcessor = null;
        }
        if (!this.executionRequestPopulatorProvided) {
            this.executionRequestPopulator = null;
        }
        if (!this.settingsBuilderProvided) {
            this.settingsBuilder = null;
        }
        if (!this.securityDispatcherProvided) {
            this.securityDispatcher = null;
        }
        if (!this.serviceManagerProvided) {
            this.serviceManager = null;
        }
        if (!this.mavenProvided) {
            this.maven = null;
        }
        if (!this.configProvided) {
            this.config = null;
        }
        if (this.container != null) {
            this.container = null;
        }
    }

    public synchronized MAEContainer container() throws MAEEmbeddingException {
        if (this.container == null) {
            MAEContainer c;
            ContainerConfiguration cc = this.containerConfiguration();
            InstanceRegistry reg = new InstanceRegistry(new InstanceRegistry[]{this.instanceRegistry()});
            reg.addVirtual(new ComponentKey(MAEEmbedder.class), this.embedderVirtual);
            try {
                c = new MAEContainer(cc, this.selector(), reg);
            }
            catch (PlexusContainerException e) {
                throw new MAEEmbeddingException("Failed to initialize component container: {0}", e, e.getMessage());
            }
            c.setLoggerManager((LoggerManager)new MavenLoggerManager(this.logger));
            this.container = c;
        }
        return this.container;
    }

    public synchronized ComponentSelector selector() {
        return this.configuration().getComponentSelector();
    }

    public synchronized InstanceRegistry instanceRegistry() {
        return this.configuration().getInstanceRegistry();
    }

    public MAEEmbedderBuilder withConfiguration(MAEConfiguration config) {
        this.config = config;
        this.configProvided = true;
        return this;
    }

    public synchronized MAEConfiguration configuration() {
        Object[] debugLogHandles = this.debugLogHandles();
        if (!this.logHandlesConfigured && debugLogHandles != null) {
            for (String string : debugLogHandles) {
                org.apache.log4j.Logger logger = org.apache.log4j.Logger.getLogger((String)string);
                logger.setLevel(Level.DEBUG);
            }
            this.logHandlesConfigured = true;
        }
        if (this.config == null) {
            this.config = new MAEConfiguration();
            if (this.shouldShowDebug()) {
                this.config.withDebug();
            } else {
                this.config.withoutDebug();
            }
            try {
                List<MAELibraryLoader> loaders = this.libraryLoaders();
                Collection libraries = MAELibraries.loadLibraries((MAEConfiguration)this.config, loaders);
                this.config.withLibraries(libraries);
                if (debugLogHandles != null && Arrays.binarySearch(debugLogHandles, "core") > -1) {
                    MAEEmbedder.showInfo(this.config, loaders, this.standardOut());
                }
            }
            catch (IOException e) {
                this.logger.error("Failed to query context classloader for component-overrides files. Reason: " + e.getMessage(), (Throwable)e);
            }
            this.configProvided = false;
        }
        return this.config;
    }

    public MAEEmbedderBuilder withServiceLibraryLoader(boolean enabled) {
        boolean found = false;
        List<MAELibraryLoader> loaders = this.libraryLoadersInternal();
        for (MAELibraryLoader loader : new LinkedHashSet<MAELibraryLoader>(loaders)) {
            if (!(loader instanceof ServiceLibraryLoader)) continue;
            found = true;
            if (enabled) break;
            loaders.remove(loader);
        }
        if (enabled && !found) {
            this.withLibraryLoader((MAELibraryLoader)new ServiceLibraryLoader());
        }
        return this;
    }

    public boolean isServiceLibraryLoaderUsed() {
        for (MAELibraryLoader loader : this.libraryLoadersInternal()) {
            if (!(loader instanceof ServiceLibraryLoader)) continue;
            return true;
        }
        return false;
    }

    public MAEEmbedderBuilder withLibraryLoader(MAELibraryLoader loader) {
        this.libraryLoadersInternal().add(loader);
        return this;
    }

    public MAEEmbedderBuilder withLibraryLoader(MAELibraryLoader loader, int offset) {
        List<MAELibraryLoader> loaders = this.libraryLoadersInternal();
        if (offset < 0) {
            loaders.add(loaders.size() + offset, loader);
        } else {
            loaders.add(offset, loader);
        }
        return this;
    }

    private List<MAELibraryLoader> libraryLoadersInternal() {
        if (this.libraryLoaders == null) {
            this.libraryLoaders = new ArrayList<ServiceLibraryLoader>(Collections.singletonList(new ServiceLibraryLoader()));
        }
        return this.libraryLoaders;
    }

    public List<MAELibraryLoader> libraryLoaders() {
        List<MAELibraryLoader> loaders = this.libraryLoadersInternal();
        if (!loaders.isEmpty() && CORE_LOADER != loaders.get(0)) {
            loaders.remove(CORE_LOADER);
        }
        loaders.add(0, CORE_LOADER);
        return loaders;
    }

    public MAEEmbedderBuilder withVersion(boolean showVersion) {
        this.showVersion = showVersion;
        return this;
    }

    public boolean showVersion() {
        return this.showVersion;
    }

    public MAEEmbedderBuilder withLogFile(File logFile) {
        this.logFile = logFile;
        return this;
    }

    public File logFile() {
        return this.logFile;
    }

    public MAEEmbedderBuilder withQuietMode(boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    public boolean shouldBeQuiet() {
        return this.quiet;
    }

    public MAEEmbedderBuilder withDebugMode(boolean debug) {
        this.debug = debug;
        return this;
    }

    public boolean shouldShowDebug() {
        return this.debug;
    }

    public MAEEmbedderBuilder withErrorMode(boolean showErrors) {
        this.showErrors = showErrors;
        return this;
    }

    public boolean shouldShowErrors() {
        return this.showErrors;
    }

    public synchronized MAEEmbedderBuilder withStandardOut(PrintStream stdout) {
        this.stdout = stdout;
        if (this.loggerAutoCreated) {
            this.logger = null;
        }
        return this;
    }

    public PrintStream standardOut() {
        return this.stdout;
    }

    public MAEEmbedderBuilder withStandardErr(PrintStream stderr) {
        this.stderr = stderr;
        return this;
    }

    public PrintStream standardErr() {
        return this.stderr;
    }

    public MAEEmbedderBuilder withStandardIn(InputStream stdin) {
        this.stdin = stdin;
        return this;
    }

    public InputStream standardIn() {
        return this.stdin;
    }

    public MAEEmbedderBuilder withLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public synchronized Logger logger() {
        if (this.logger == null) {
            this.logger = new PrintStreamLogger(this.stdout);
            this.loggerAutoCreated = true;
        }
        return this.logger;
    }

    public synchronized String mavenHome() {
        String mavenHome;
        if (this.mavenHome == null && (mavenHome = System.getProperty("maven.home")) != null) {
            try {
                mavenHome = new File(mavenHome).getCanonicalPath();
            }
            catch (IOException e) {
                mavenHome = new File(mavenHome).getAbsolutePath();
            }
            System.setProperty("maven.home", mavenHome);
            this.mavenHome = mavenHome;
        }
        return this.mavenHome;
    }

    protected synchronized void wireLogging() {
        if (this.logFile() != null) {
            try {
                PrintStream newOut = new PrintStream(this.logFile);
                this.withStandardOut(newOut);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        this.logger();
    }

    protected synchronized MAEEmbedder createEmbedder() throws MAEEmbeddingException {
        MAEEmbedder embedder = new MAEEmbedder(this.maven(), this.configuration(), this.container(), this.settingsBuilder(), this.executionRequestPopulator(), this.securityDispatcher(), this.serviceManager(), this.libraryLoaders(), this.standardOut(), this.logger(), this.shouldShowErrors(), this.showVersion());
        this.embedderVirtual.setInstance((Object)embedder);
        return embedder;
    }

    public synchronized MAEEmbedder build() throws MAEEmbeddingException {
        if (this.embedder == null) {
            this.logger();
            this.configuration();
            this.mavenHome();
            this.wireLogging();
            this.embedder = this.createEmbedder();
        }
        return this.embedder;
    }

    public MAEEmbedderBuilder withDebugLogHandles(String[] debugLogHandles) {
        this.debugLogHandles = debugLogHandles;
        this.logHandlesConfigured = false;
        return this;
    }

    public String[] debugLogHandles() {
        return this.debugLogHandles;
    }
}

