/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.mae.boot.log;

import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.apache.maven.repository.ArtifactTransferEvent;
import org.apache.maven.repository.ArtifactTransferListener;
import org.apache.maven.repository.ArtifactTransferResource;

public class BatchTransferListener
implements ArtifactTransferListener {
    protected PrintStream out;
    private boolean showChecksumEvents;

    public BatchTransferListener(PrintStream out) {
        this.out = out != null ? out : System.out;
    }

    protected boolean showEvent(ArtifactTransferEvent event) {
        if (event.getResource() == null) {
            return true;
        }
        String resource = event.getResource().getName();
        if (resource == null || resource.trim().length() == 0) {
            return true;
        }
        if (resource.endsWith(".sha1") || resource.endsWith(".md5")) {
            return this.showChecksumEvents;
        }
        return true;
    }

    public void transferInitiated(ArtifactTransferEvent transferEvent) {
        if (!this.showEvent(transferEvent)) {
            return;
        }
        this.doInitiated(transferEvent);
    }

    protected void doInitiated(ArtifactTransferEvent transferEvent) {
        String message = transferEvent.getRequestType() == 6 ? "Uploading" : "Downloading";
        this.out.println(message + ": " + transferEvent.getResource().getUrl());
    }

    public void transferStarted(ArtifactTransferEvent transferEvent) {
        if (!this.showEvent(transferEvent)) {
            return;
        }
        this.doStarted(transferEvent);
    }

    protected void doStarted(ArtifactTransferEvent transferEvent) {
    }

    public void transferProgress(ArtifactTransferEvent transferEvent) {
        if (!this.showEvent(transferEvent)) {
            return;
        }
        this.doProgress(transferEvent);
    }

    protected void doProgress(ArtifactTransferEvent transferEvent) {
    }

    public void transferCompleted(ArtifactTransferEvent transferEvent) {
        if (!this.showEvent(transferEvent)) {
            return;
        }
        this.doCompleted(transferEvent);
    }

    protected void doCompleted(ArtifactTransferEvent transferEvent) {
        ArtifactTransferResource artifact = transferEvent.getResource();
        long contentLength = transferEvent.getTransferredBytes();
        if (contentLength >= 0L) {
            String type = transferEvent.getRequestType() == 6 ? "Uploaded" : "Downloaded";
            String len = contentLength >= 1024L ? this.toKB(contentLength) + " KB" : contentLength + " B";
            String throughput = "";
            long duration = System.currentTimeMillis() - artifact.getTransferStartTime();
            if (duration > 0L) {
                DecimalFormat format = new DecimalFormat("0.0", new DecimalFormatSymbols(Locale.ENGLISH));
                double kbPerSec = (double)contentLength / 1024.0 / ((double)duration / 1000.0);
                throughput = " at " + format.format(kbPerSec) + " KB/sec";
            }
            this.out.println(type + ": " + artifact.getUrl() + " (" + len + throughput + ")");
        }
    }

    protected long toKB(long bytes) {
        return (bytes + 1023L) / 1024L;
    }

    public boolean isShowChecksumEvents() {
        return this.showChecksumEvents;
    }

    public void setShowChecksumEvents(boolean showChecksumEvents) {
        this.showChecksumEvents = showChecksumEvents;
    }
}

