/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.settings;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.settings.InputLocation;
import org.apache.maven.api.settings.InputLocationTracker;
import org.apache.maven.api.settings.TrackableBase;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class IdentifiableBase
extends TrackableBase
implements Serializable,
InputLocationTracker {
    final String id;

    IdentifiableBase(String id, Map<Object, InputLocation> locations) {
        super(locations);
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    @Override
    @Nonnull
    public Builder with() {
        return IdentifiableBase.newBuilder(this);
    }

    @Nonnull
    public IdentifiableBase withId(String id) {
        return IdentifiableBase.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public static IdentifiableBase newInstance() {
        return IdentifiableBase.newInstance(true);
    }

    @Nonnull
    public static IdentifiableBase newInstance(boolean withDefaults) {
        return IdentifiableBase.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return IdentifiableBase.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(IdentifiableBase from) {
        return IdentifiableBase.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(IdentifiableBase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends TrackableBase.Builder {
        IdentifiableBase base;
        String id;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.id = "default";
            }
        }

        Builder(IdentifiableBase base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.id = base.id;
                this.locations = base.locations;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public IdentifiableBase build() {
            if (this.base != null && (this.id == null || this.id == this.base.id)) {
                return this.base;
            }
            Map newlocs = this.locations != null ? this.locations : Collections.emptyMap();
            Map oldlocs = this.base != null && this.base.locations != null ? this.base.locations : Collections.emptyMap();
            HashMap<Object, InputLocation> locations = new HashMap<Object, InputLocation>();
            locations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
            locations.put("id", newlocs.containsKey("id") ? (InputLocation)newlocs.get("id") : (InputLocation)oldlocs.get("id"));
            return new IdentifiableBase(this.id != null ? this.id : (this.base != null ? this.base.id : null), locations);
        }
    }
}

