/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.toolchain;

import java.io.Serializable;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class TrackableBase
implements Serializable {
    public static final String USER_LEVEL = "user-level";
    public static final String GLOBAL_LEVEL = "global-level";
    private String sourceLevel = "user-level";
    private boolean sourceLevelSet = false;

    TrackableBase() {
    }

    @Nonnull
    public Builder with() {
        return TrackableBase.newBuilder(this);
    }

    @Nonnull
    public static TrackableBase newInstance() {
        return TrackableBase.newInstance(true);
    }

    @Nonnull
    public static TrackableBase newInstance(boolean withDefaults) {
        return TrackableBase.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return TrackableBase.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(TrackableBase from) {
        return TrackableBase.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(TrackableBase from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public void setSourceLevel(String sourceLevel) {
        if (this.sourceLevelSet) {
            throw new IllegalStateException("Cannot reset sourceLevel attribute; it is already set to: " + sourceLevel);
        }
        if (!USER_LEVEL.equals(sourceLevel) && !GLOBAL_LEVEL.equals(sourceLevel)) {
            throw new IllegalArgumentException("sourceLevel must be one of: {user-level,global-level}");
        }
        this.sourceLevel = sourceLevel;
        this.sourceLevelSet = true;
    }

    public String getSourceLevel() {
        return this.sourceLevel;
    }

    @NotThreadSafe
    public static class Builder {
        TrackableBase base;

        Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(TrackableBase base, boolean forceCopy) {
            if (!forceCopy) {
                this.base = base;
            }
        }

        @Nonnull
        public TrackableBase build() {
            if (this.base != null) {
                return this.base;
            }
            return new TrackableBase();
        }
    }
}

