/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.metadata;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.metadata.AbstractArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.metadata.LegacyArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractVersionArtifactMetadata
extends AbstractArtifactMetadata
implements LegacyArtifactMetadata {
    protected static final String SNAPSHOT_VERSION_FILE = "version.txt";
    protected long lastModified;

    public AbstractVersionArtifactMetadata(Artifact artifact) {
        super(artifact);
    }

    public void readFromFile(File file) throws IOException {
        this.setContent(FileUtils.fileRead((File)file));
        this.lastModified = file.lastModified();
    }

    protected abstract void setContent(String var1);

    public void retrieveFromRemoteRepository(ArtifactRepository remoteRepository, WagonManager wagonManager, String checksumPolicy) throws ArtifactMetadataRetrievalException, ResourceDoesNotExistException {
        try {
            File destination = File.createTempFile("maven-artifact", null);
            destination.deleteOnExit();
            wagonManager.getArtifactMetadata(this, remoteRepository, destination, checksumPolicy);
            this.readFromFile(destination);
        }
        catch (TransferFailedException e) {
            throw new ArtifactMetadataRetrievalException("Unable to retrieve metadata", (Throwable)e);
        }
        catch (IOException e) {
            throw new ArtifactMetadataRetrievalException("Unable to retrieve metadata", (Throwable)e);
        }
    }

    public void storeInLocalRepository(ArtifactRepository localRepository) throws ArtifactMetadataRetrievalException {
        String version = this.constructVersion();
        if (version != null) {
            try {
                File file = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata((ArtifactMetadata)this, null));
                file.getParentFile().mkdirs();
                FileUtils.fileWrite((String)file.getPath(), (String)version);
                this.lastModified = file.lastModified();
            }
            catch (IOException e) {
                throw new ArtifactMetadataRetrievalException("Unable to retrieve metadata", (Throwable)e);
            }
        }
    }

    public void storeInLocalRepository(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws ArtifactMetadataRetrievalException {
        throw new IllegalStateException("This code should no longer be called");
    }

    public Date getLastModified() {
        return new Date(this.lastModified);
    }

    public Object getKey() {
        return "legacy " + this.artifact.getGroupId() + ":" + this.artifact.getArtifactId();
    }

    public void merge(ArtifactMetadata metadata) {
        throw new IllegalStateException("Cannot add two pieces of metadata for: " + this.getKey());
    }

    public abstract /* synthetic */ String constructVersion();

    public abstract /* synthetic */ boolean newerThanFile(File var1);

    public abstract /* synthetic */ String getRemoteFilename();

    public abstract /* synthetic */ String getLocalFilename(ArtifactRepository var1);

    public abstract /* synthetic */ String getBaseVersion();

    public abstract /* synthetic */ boolean storedInArtifactVersionDirectory();

    public abstract /* synthetic */ int compareTo(Object var1);
}

