/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.metadata;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.AbstractVersionArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;

public class LatestArtifactMetadata
extends AbstractVersionArtifactMetadata {
    private String version;

    public LatestArtifactMetadata(Artifact artifact) {
        super(artifact);
    }

    public String getRemoteFilename() {
        return this.getFilename();
    }

    public String getLocalFilename(ArtifactRepository repository) {
        return this.getFilename();
    }

    private String getFilename() {
        return this.artifact.getArtifactId() + "-" + "LATEST" + "." + "version.txt";
    }

    public String constructVersion() {
        return this.version;
    }

    public int compareTo(Object o) {
        LatestArtifactMetadata metadata = (LatestArtifactMetadata)o;
        if (this.version == null) {
            if (metadata.version == null) {
                return 0;
            }
            return -1;
        }
        if (metadata.version == null) {
            return 1;
        }
        return this.version.compareTo(metadata.version);
    }

    public boolean newerThanFile(File file) {
        long fileTime = file.lastModified();
        return this.lastModified > fileTime;
    }

    public String toString() {
        return "latest-version information for " + this.artifact.getArtifactId();
    }

    protected void setContent(String content) {
        this.version = content.trim();
    }

    public String getBaseVersion() {
        return "LATEST";
    }

    public boolean storedInArtifactVersionDirectory() {
        return false;
    }
}

